/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tasks.thread.CommonTimerTasks;
import com.cognos.jsmcommon.tse.NCTSEStateMapTable;
import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.tse.TaskTable;
import com.cognos.jsmcommon.util.CommonHistoryHelper;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TimerTask;

public class HistoryConsistencyThread {
    private static final int m_ForceWait = 120;
    private static final String DELETE_COMPLETE_TREE = "historyConsistencyThread.deleteCompleteTree";
    private static final String FINAL_HISTORY_GRACE_PERIOD = "historyConsistencyThread.finalHistoryGracePeriod";
    private static final String BUSY_THRESHOLD = "event.historyconsistencycheck.threshold";
    private static final String SHORT_POLL_INTERVAL = "event.historyconsistencycheck.batch.interval";
    private static final String LONG_POLL_INTERVAL = "event.historyconsistencycheck.interval";
    private static final String CHECK_BATCH_SIZE = "event.historyconsistencycheck.batch.size";
    private static final String FORCED_CLEAN = "event.historyconsistencycheck.enable.forced.clean";
    private static final String REQUEST_OPERATION = "HistoryConsistencyThread.run";
    private static final int MILLIS_IN_SECOND = 1000;
    private int m_busyThreshold = 2;
    private static ThreadLocal<Boolean> initHolder = new ThreadLocal();
    private static HistoryConsistencyThread instance;
    private static int MAX_BATCH;
    private int m_checkBatchSize = 10;
    private boolean m_deleteCompleteTree = true;
    private int m_LongPollInterval = 43200;
    private int m_shortPollInterval = 60;
    private int m_finalHistoryGracePeriod = 180000;
    private boolean m_moreToCheck = true;
    private boolean m_isActive = true;
    private boolean m_isForcedCleanEnabled = false;
    private boolean m_exit = false;
    private LinkedList<TaskTable.StoreInfo> m_unknowns = new LinkedList();
    private TimerTask m_timer_task = null;

    private HistoryConsistencyThread() {
        try {
            String isActiveStr = CRNProperties.getInstance().getProperty("event.historyconsistencycheck.active");
            this.m_isActive = isActiveStr != null ? Boolean.valueOf(isActiveStr) : true;
            String isActiveThrStr = CRNProperties.getInstance().getProperty(BUSY_THRESHOLD);
            this.m_busyThreshold = isActiveThrStr != null ? Integer.valueOf(isActiveThrStr) : 4;
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("Error reading tse history poll isActive: " + e.getMessage());
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("tse history check isActive [" + this.m_isActive + "] will be used.");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_HISTORY_CONSISTENCY_CHECK_FAILED, new Object[]{e.getLocalizedMessage()});
        }
        TSE.trace("HistoryConsistencyChecker is active = " + this.m_isActive);
        try {
            String pollInterval = CRNProperties.getInstance().getProperty("event.check.interval");
            if (pollInterval != null && !"".equals(pollInterval)) {
                int newPollInterval;
                this.m_LongPollInterval = newPollInterval = Integer.valueOf(pollInterval).intValue();
            }
            if ((pollInterval = CRNProperties.getInstance().getProperty(LONG_POLL_INTERVAL)) != null && !"".equals(pollInterval)) {
                int newPollInterval;
                this.m_LongPollInterval = newPollInterval = Integer.valueOf(pollInterval).intValue();
            }
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_HISTORY_CONSISTENCY_CHECK_FAILED, new Object[]{e.getLocalizedMessage()});
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("Error reading poll interval: " + e.getMessage());
            TSE.trace("Error reading poll interval:  " + e.getMessage());
            e.printStackTrace();
        }
        TSE.trace("HistoryConsistencyChecker thread polling interval = " + this.m_LongPollInterval);
    }

    public void run() {
        this.m_isActive = this.getProperty("event.historyconsistencycheck.active", true);
        this.m_isForcedCleanEnabled = this.getProperty(FORCED_CLEAN, false);
        this.m_checkBatchSize = this.getProperty(CHECK_BATCH_SIZE, this.m_checkBatchSize);
        this.m_checkBatchSize = this.getProperty(CHECK_BATCH_SIZE, this.m_checkBatchSize);
        this.m_LongPollInterval = this.getProperty(LONG_POLL_INTERVAL, this.m_LongPollInterval);
        this.m_shortPollInterval = this.getProperty(SHORT_POLL_INTERVAL, this.m_shortPollInterval);
        this.m_busyThreshold = this.getProperty(BUSY_THRESHOLD, this.m_busyThreshold);
        this.m_finalHistoryGracePeriod = this.getProperty(FINAL_HISTORY_GRACE_PERIOD, this.m_finalHistoryGracePeriod);
        this.m_deleteCompleteTree = this.getProperty(DELETE_COMPLETE_TREE, this.m_deleteCompleteTree);
        if (!this.m_isActive) {
            TSE.trace("HistoryConsistencyChecker is disabled. will try again after " + this.m_LongPollInterval + " sec");
            this.rescheduleCleaningThread(this.m_LongPollInterval);
            return;
        }
        ThreadProperties.setProperty((String)"componentID", (String)"MS");
        ThreadProperties.setProperty((String)"requestOperation", (String)REQUEST_OPERATION);
        TSE.trace("History consistency run()");
        this.m_moreToCheck = true;
        boolean allOk = true;
        while (!this.m_unknowns.isEmpty() || this.m_moreToCheck && !this.m_exit) {
            boolean systemBusy = true;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("HistoryconsistencyChecker: checking items to clean allOk = " + allOk);
            try {
                systemBusy = this.isSystemBusy();
                if (systemBusy || !allOk) {
                    TSE.trace("History consistency checking is pausing while the system is busy or last run had errors");
                } else {
                    allOk = this.findInvalidTseHistoriesAndClean();
                }
            }
            catch (Throwable t) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_HISTORY_CONSISTENCY_CHECK_FAILED, new Object[0]);
                TSE.trace("Fatal Error checking tse history consistency " + t.getMessage());
                t.printStackTrace();
            }
            long delay = this.m_LongPollInterval;
            if (!allOk) {
                allOk = true;
                this.m_shortPollInterval = 120;
            }
            if (!systemBusy && this.m_moreToCheck) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("HistoryConsistencyChecker Thread reschedule shortinterval set at " + this.m_shortPollInterval + " seconds");
                this.sleep(this.m_shortPollInterval);
                continue;
            }
            this.rescheduleCleaningThread(delay);
        }
    }

    private void rescheduleCleaningThread(long delay) {
        this.m_unknowns.clear();
        this.m_moreToCheck = false;
        try {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("HistoryConsistencyChecker Thread schedule interval set at " + delay + " seconds");
            CommonTimerTasks.getInstance().schedule(this.resetTimerTask(), delay * 1000L);
        }
        catch (IllegalStateException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_HISTORY_CONSISTENCY_CHECK_FAILED, new Object[0]);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("Error scheduling tse history consistency thread" + e.getMessage());
            TSE.trace("Error scheduling tse history consistency thread" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("Error scheduling tse history consistency thread" + e.getMessage());
            TSE.trace("UNEXPECTED ERROR scheduling tse history consistency thread" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time * 1000L);
        }
        catch (InterruptedException e) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findInvalidTseHistoriesAndClean() {
        boolean allOk = true;
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"HistoryConsistencyThread.checkTseHistories");
        try {
            PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "BEGIN");
            PerfLog perfCheck = null;
            PerfLog perfUpdate = null;
            try {
                perfCheck = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "BEGIN", "Checking tse history consitency.");
                TSE.trace("Checking tse history consitency");
                if (this.m_unknowns.size() == 0) {
                    this.getConsistencyCandidates(this.m_unknowns);
                }
                ArrayList<TaskTable.StoreInfo> checkers = new ArrayList<TaskTable.StoreInfo>();
                for (int count = 0; !this.m_unknowns.isEmpty() && count < this.m_checkBatchSize; ++count) {
                    checkers.add(this.m_unknowns.removeLast());
                }
                this.m_moreToCheck = !this.m_unknowns.isEmpty();
                TaskTable.StoreInfo[] invalids = this.areHistoriesValid(checkers.toArray(new TaskTable.StoreInfo[0]));
                if (invalids != null && invalids.length > 0) {
                    allOk = this.cleanRecords(invalids);
                    this.m_moreToCheck = true;
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("HistoryconsistencyChecker: CleanRecords returned with allok = " + allOk);
                } else {
                    if (this.m_isForcedCleanEnabled && (invalids = checkers.toArray(new TaskTable.StoreInfo[0])) != null && invalids.length > 0) {
                        allOk = this.cleanRecords(invalids);
                    }
                    this.m_unknowns = null;
                    this.m_unknowns = new LinkedList();
                    this.m_moreToCheck = false;
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("HistoryconsistencyChecker: CleanRecords unknown entries reset as nothing was to be cleaned.");
                }
                perfCheck.stop();
                perfUpdate = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "BEGIN", "Updating tse record state.");
                perfUpdate.stop();
            }
            catch (Exception e) {
                this.m_isActive = false;
                SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("general error checking tse record history consistency.");
                SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug(e.getMessage());
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_HISTORY_CONSISTENCY_CHECK_FAILED, new Object[0]);
                TSE.trace("UNEXPECTED ERROR checking tse record history consistency:  " + e.toString());
                e.printStackTrace();
            }
            finally {
                perf.stop();
                if (perfCheck != null) {
                    perfCheck.stop();
                }
                if (perfUpdate != null) {
                    perfUpdate.stop();
                }
            }
        }
        finally {
            zipiTimer.stopAndClear();
        }
        return allOk;
    }

    private TaskTable.StoreInfo[] areHistoriesValid(TaskTable.StoreInfo[] info) throws SDKClientException, EMFSecurityException {
        String[] paths = new String[info.length];
        HashMap<String, TaskTable.StoreInfo> checkMap = new HashMap<String, TaskTable.StoreInfo>();
        for (int i = 0; i < info.length; ++i) {
            if (info[i].storeId != null) {
                paths[i] = "storeID('" + info[i].storeId + "')";
                checkMap.put(info[i].storeId, info[i]);
                continue;
            }
            if (info[i].restartId != null) {
                paths[i] = "//history[@eventID = '" + info[i].restartId + "']";
                checkMap.put(info[i].restartId.getID(), info[i]);
                continue;
            }
            String eventId = info[i].taskId.toEventId();
            paths[i] = "//history[@eventID = '" + info[i].taskId.toEventId() + "']";
            checkMap.put(eventId, info[i]);
        }
        SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("HistoryconsistencyChecker: getHistoryFromCM call");
        History[] histories = CommonHistoryHelper.getHistoryFromCM((String[])paths, (BiBusHeader)new BiBusHeader(), (PropEnum[])new PropEnum[]{PropEnum.storeID, PropEnum.eventID, PropEnum.restartEventID});
        for (int i = 0; i < histories.length; ++i) {
            if (histories[i] == null || histories[i].getStoreID() == null) continue;
            checkMap.remove(histories[i].getStoreID().getValue().get_value());
            checkMap.remove(histories[i].getEventID().getValue());
            if (histories[i].getRestartEventID().getValue() == null) continue;
            checkMap.remove(histories[i].getRestartEventID().getValue());
        }
        return checkMap.values().toArray(new TaskTable.StoreInfo[0]);
    }

    private boolean cleanRecords(final TaskTable.StoreInfo[] info) throws TSEException {
        SQLExecute sqlExecute = new SQLExecute(){
            boolean allOk = false;

            public Object execute() throws TaskPersistLayerException {
                TSE.trace("HistoryconsistencyChecker: number of records to clean: " + info.length);
                TaskID[] toDelete = new TaskID[info.length];
                for (int i = 0; i < info.length; ++i) {
                    toDelete[i] = info[i].taskId;
                    TSE.trace("HistoryconsistencyChecker cleaning for taskId: " + info[i].taskId);
                }
                if (HistoryConsistencyThread.this.m_deleteCompleteTree) {
                    this.allOk = TaskPersistLayer.getInstance().deleteRecordsIncludingChildren(toDelete);
                } else {
                    try {
                        int orphaned = NCTSEStateMapTable.getInstance().setParentToNullOnChildren(toDelete, TaskStatus.TERMINATED);
                        if (orphaned > 0) {
                            HistoryConsistencyThread.this.m_moreToCheck = true;
                        }
                        this.allOk = TaskPersistLayer.getInstance().deleteRecords(toDelete);
                        TSE.trace("HistoryconsistencyChecker: number of records cleaned: " + info.length + " : " + this.allOk);
                    }
                    catch (SQLException e) {
                        HistoryConsistencyThread.this.m_moreToCheck = false;
                        this.allOk = false;
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).log(SDSLevel.ERROR, (Throwable)e);
                        throw new TaskPersistLayerException((Exception)e);
                    }
                }
                return this.allOk;
            }
        };
        boolean allok = true;
        SQLTransactionExecuteHandler transHandler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
        try {
            allok = (Boolean)transHandler.execute(sqlExecute);
        }
        catch (Exception e) {
            TSE.throwException(e);
        }
        return allok;
    }

    public void start() {
        this.m_exit = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                HistoryConsistencyThread.getInstance().sleep(30L);
                HistoryConsistencyThread.getInstance().run();
            }
        }).start();
    }

    private int getProperty(String propName, int defaultValue) {
        int result = defaultValue;
        try {
            String property = CRNProperties.getInstance().getProperty(propName);
            if (property != null) {
                result = Integer.valueOf(property);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, (LocalizableException)((Object)ex));
        }
        catch (Throwable t) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        TSE.trace("HistoryConsistencyChecker : " + propName + "=" + result);
        return result;
    }

    private boolean getProperty(String propName, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String property = CRNProperties.getInstance().getProperty(propName);
            if (property != null) {
                result = Boolean.valueOf(property);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, (LocalizableException)((Object)ex));
        }
        catch (Throwable t) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        TSE.trace("HistoryConsistencyChecker : " + propName + "=" + result);
        return result;
    }

    public void stop() {
        this.m_exit = true;
        if (this.m_timer_task != null) {
            this.m_timer_task.cancel();
        }
        this.m_timer_task = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSystemBusy() throws TaskPersistLayerException {
        boolean isBusy;
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"HistoryConsistencyThread.isSystemBusy");
        try {
            isBusy = TSE.getInstance().failedInstanceListener.isRunning();
            if (isBusy) {
                boolean bl = isBusy;
                return bl;
            }
            int readyTasks = TaskPersistLayer.getInstance().getCountReadyTasks();
            isBusy = readyTasks > this.m_busyThreshold;
        }
        finally {
            zipiTimer.stopAndClear();
        }
        return isBusy;
    }

    private void getConsistencyCandidates(LinkedList<TaskTable.StoreInfo> unknowns) throws TSEException {
        try {
            TaskTable.StoreInfo[] purgerers = TaskTable.getCompletedStoreInfo(null, (int)MAX_BATCH);
            Date graceDate = new Date(new Date().getTime() - (long)this.m_finalHistoryGracePeriod);
            for (int i = 0; i < purgerers.length; ++i) {
                TaskHistoryDetailRecord record;
                if (purgerers[i].executionTime != null && purgerers[i].executionTime.after(graceDate) && (record = new TaskHistoryDetailRecord(purgerers[i].taskId)).count() > 0) continue;
                unknowns.addFirst(purgerers[i]);
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("SQL Error when retrieving events from the datastore.");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug(e.getMessage());
            TSE.throwException(e);
        }
    }

    private TimerTask resetTimerTask() {
        if (this.m_timer_task != null) {
            this.m_timer_task.cancel();
            this.m_timer_task = null;
        }
        return this.getTimerTask();
    }

    private TimerTask getTimerTask() {
        if (this.m_timer_task == null) {
            this.m_timer_task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        HistoryConsistencyThread.getInstance().run();
                    }
                    catch (Exception e) {
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("Error trying to run the History Consistency Thread.");
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug((Throwable)e);
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_HISTORY_CONSISTENCY_CHECK_FAILED, new Object[]{e.getLocalizedMessage()});
                    }
                }
            };
        }
        return this.m_timer_task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HistoryConsistencyThread getInstance() {
        if (initHolder.get() != null) return instance;
        Class<HistoryConsistencyThread> clazz = HistoryConsistencyThread.class;
        synchronized (HistoryConsistencyThread.class) {
            if (instance == null) {
                instance = new HistoryConsistencyThread();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            initHolder.set(Boolean.TRUE);
            return instance;
        }
    }

    static {
        MAX_BATCH = 100;
    }
}

