/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.util.Validate;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.run.commands.RunCommand;
import java.util.HashMap;

public class RunCommandProcessor {
    static RunCommandProcessor singleton = new RunCommandProcessor();
    HashMap<Class<? extends CmdSpec>, RunCommand> runCommands;

    public static RunCommandProcessor getInstance() {
        return singleton;
    }

    RunCommandProcessor() {
        RunCommand[] cmds = RunCommand.getCommands();
        this.runCommands = new HashMap();
        for (int i = 0; i != cmds.length; ++i) {
            this.runCommands.put(cmds[i].getType(), cmds[i]);
        }
    }

    RunCommand commandForType(Class<? extends CmdSpec> type) {
        return this.runCommands.get(type);
    }

    public void preRun(TaskRunContext task) throws TSEException {
        CmdSpec[] commands = task.getTaskRecord().getRunSpec().runCommands;
        if (commands != null) {
            try {
                for (int i = 0; i != commands.length; ++i) {
                    RunCommand handler = this.commandForType(commands[i].getClass());
                    Validate.notNull((Object)handler);
                    handler.preRun(task, commands[i]);
                }
            }
            catch (Exception e) {
                TSE.throwException(e);
            }
        }
    }

    public void postConversation(TaskRunContext task, AsynchReply reply) throws TSEException {
        CmdSpec[] commands = task.getTaskRecord().getRunSpec().runCommands;
        if (commands != null) {
            try {
                for (int i = 0; i != commands.length; ++i) {
                    RunCommand handler = this.commandForType(commands[i].getClass());
                    Validate.notNull((Object)handler);
                    handler.postConversation(task, commands[i], reply);
                }
            }
            catch (Exception e) {
                TSE.throwException(e);
            }
        }
    }

    public void postRun(TaskRunContext task) throws TSEException {
        CmdSpec[] commands = task.getTaskRecord().getRunSpec().runCommands;
        if (commands != null) {
            try {
                for (int i = 0; i != commands.length; ++i) {
                    RunCommand handler = this.commandForType(commands[i].getClass());
                    Validate.notNull((Object)handler);
                    handler.postRun(task, commands[i]);
                }
            }
            catch (Exception e) {
                TSE.throwException(e);
            }
        }
    }
}

