/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ConversationContext;
import com.cognos.developer.schemas.bibus._3.Dispatcher_Type;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.serverinst.SDSInstance;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.monitor.impl.EventResultType;
import com.cognos.monitor.impl.EventsResult;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.monitor.tse.EventCanceler;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;

public class StandardEventCanceler
implements EventCanceler {
    private TaskRunContext m_taskRunContext = null;
    private BiBusHeader m_biBusHeader = null;

    public StandardEventCanceler(TaskRunContext context) {
        this.m_taskRunContext = context;
    }

    public StandardEventCanceler(TaskRunContext context, BiBusHeader header) {
        this.m_biBusHeader = header;
        this.m_taskRunContext = context;
    }

    @Override
    public EventsResult cancel(String sdsInstanceId, String eventId, String userName, boolean background) throws TSEException {
        EventsResult result = new EventsResult();
        try {
            if (sdsInstanceId != null) {
                if (sdsInstanceId.compareToIgnoreCase(TaskPersistLayer.getSdsInstance()) == 0) {
                    if (background) {
                        MonitorService.instance().cancelLocalEvent(eventId, userName, result);
                    } else {
                        Event event = new Event(EventStatus.CANCELLED, EventId.valueOf(eventId));
                        if (this.m_taskRunContext.cancel()) {
                            result.addResult(EventResultType.CANCEL_SUCCEEDED, event);
                        } else {
                            result.addResult(EventResultType.CANCEL_FAILED, event);
                        }
                    }
                } else {
                    this.callRemoteCancelEvent(sdsInstanceId, eventId, userName);
                }
            } else {
                TSE.trace("Task running has no sdsInstanceID");
            }
        }
        catch (Exception e) {
            TSE.throwException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callRemoteCancelEvent(String sdsInstanceId, String eventId, String userName) throws RemoteException, MalformedURLException, ServiceException {
        SDSInstance inst = SDSInstanceManager.getInstance().getSDSInstance(sdsInstanceId);
        if (this.m_biBusHeader == null) {
            this.m_biBusHeader = BiBusUtilities.extractBiBusHeader();
        }
        Dispatcher_Type dispatcher = null;
        try {
            dispatcher = inst.getDispatcherType(this.m_biBusHeader);
        }
        catch (SDKClientException e) {
            TSE.trace("StandardEventCanceler::callRemoteCancelEvent SDKClientException " + e.getLocalizedMessage());
        }
        catch (EMFSecurityException e) {
            TSE.trace("StandardEventCanceler::callRemoteCancelEvent EMFSecurityException " + e.getLocalizedMessage());
        }
        Tracking prevTracking = this.m_biBusHeader.getTracking();
        try {
            ConversationContext conversationContext = new ConversationContext();
            conversationContext.setNodeID(dispatcher.getDispatcherID().getValue().get_value());
            this.m_biBusHeader.setTracking(new Tracking());
            this.m_biBusHeader.getTracking().setConversationContext(conversationContext);
            this.callMonitorService(this.m_biBusHeader, "cancelEvent", new Object[]{"LOCAL:" + eventId}, inst.getUrl());
        }
        finally {
            this.m_biBusHeader.setTracking(prevTracking);
        }
    }

    private Object callMonitorService(BiBusHeader header, String method, Object[] args, String endPoint) throws ServiceException, RemoteException, MalformedURLException {
        Object obj = null;
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(new URL(endPoint));
        call.setUseSOAPAction(true);
        String uri = "http://developer.cognos.com/schemas/monitorService/1.server";
        call.setSOAPActionURI(uri);
        call.setSOAPVersion((SOAPConstants)SOAPConstants.SOAP11_CONSTANTS);
        call.setOperationName(new QName(uri, method));
        SOAPHeaderElement hdr = new SOAPHeaderElement("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
        call.addHeader(hdr);
        try {
            obj = call.invoke(args);
        }
        catch (Exception e) {
            TSE.trace("StandardEventCanceler::callMonitorService Exception " + e.getLocalizedMessage());
        }
        return obj;
    }
}

