/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.ConversationContext;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.BiBusSpec;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueMetrics;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.api.Monitorable;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.impl.BaseMonitorable;
import com.cognos.monitor.impl.DelegatedTaskRunner;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.monitor.impl.MonitorableObject;
import com.cognos.monitor.impl.MonitorableSpecification;
import com.cognos.monitor.tse.BiBusContext;
import com.cognos.monitor.tse.BiBusRunContext;
import com.cognos.monitor.tse.BiBusRunMonitorableAdapter;
import com.cognos.monitor.tse.HistoryWriter;
import com.cognos.monitor.tse.ITSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEFailedInstanceListener;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.cognos.monitor.tse.commands.CleanTaskTableCmd;
import com.cognos.monitor.tse.commands.RestartTasksCmd;
import com.cognos.monitor.tse.commands.ResumeTaskCmd;
import com.cognos.monitor.tse.commands.RunNewTaskCmd;
import com.cognos.monitor.tse.commands.SuspendTaskCmd;
import com.cognos.monitor.tse.commands.TaskRunCancelledCmd;
import com.cognos.monitor.tse.commands.TaskStatusChangedCmd;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.sds.event.EventId;
import com.cognos.sds.event.EventTransition;
import com.cognos.sds.event.IEventId;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import org.dom4j.Element;

public final class TSE
implements ITSE {
    TSEFailedInstanceListener failedInstanceListener;
    private static TSE singleton = new TSE();
    private static boolean trace = false;

    public static TSE getInstance() {
        return singleton;
    }

    TSE() {
        trace = Boolean.valueOf(System.getProperty("tse.trace"));
        TaskQueueMetrics.getInstance();
        this.failedInstanceListener = new TSEFailedInstanceListener();
    }

    @Override
    public void start() {
        TSEStateMapProcessor.getInstance().start();
        this.failedInstanceListener.start();
    }

    @Override
    public void stop(boolean immediate) {
        TSEStateMapProcessor.getInstance().stop(immediate);
        this.failedInstanceListener.stop();
    }

    @Override
    public void cleanupInstance(String instanceId, I18NCode message) {
        this.failedInstanceListener.instanceFailed(instanceId, message, true);
    }

    @Override
    public IEventId getEventId(TaskID taskID) {
        return EventId.valueOf(taskID.getID());
    }

    @Override
    public int getCountReadyTasks() throws TaskPersistLayerException {
        return TaskPersistLayer.getInstance().getCountReadyTasks();
    }

    @Override
    public TaskRunContext receiveTaskToRun(String service, String group) throws TSEException {
        TaskRunContext context = null;
        try {
            TaskID taskID = TaskPersistLayer.getInstance().getNextTaskFromQueue(service, group);
            if (taskID != null) {
                context = TaskRunContextFactory.createTaskRunContext(taskID);
            }
        }
        catch (TaskPersistLayerException e) {
            TSE.throwException((Exception)((Object)e));
        }
        if (context != null) {
            context.onReceiveTaskToRun();
        }
        return context;
    }

    @Override
    public void restartTask(TaskStateRecord restart, TaskID[] skippies, TaskID newEventId, BiBusHeader userPassport) throws LocalizableException {
        TSE.trace("Restarting task " + restart.taskID.getID());
        TSE.trace("new restart event id  " + newEventId.getID());
        TSEStateMapProcessor.getInstance().queueCmd(new RestartTasksCmd(restart, skippies, newEventId, userPassport));
    }

    @Override
    public void setTaskAsReady(TaskRunContext context) throws LocalizableException {
        TSEStateMapProcessor.getInstance().queueCmd(new RunNewTaskCmd(context));
    }

    @Override
    public IEventId delegate(JobBiBusHeaders headers, Attachment[] attachments, AsynchRequest request) throws LocalizableException, TSEException {
        Tracking tracking = headers.getBiBusHeader().getTracking();
        ConversationContext originalContext = this.cloneConversationContext(tracking.getConversationContext());
        String sessionID = tracking.getSessionContext();
        String requestID = tracking.getRequestContext();
        Monitorable monitorable = null;
        if (request.getObjectPath() != null) {
            BiBusRunSpec task = new BiBusRunSpec(headers.getBiBusHeader());
            task.searchPath = request.getObjectPath().get_value();
            SequenceSpec spec = new SequenceSpec(SequenceSpec.SEQ_NEW, (TaskRunSpec)task);
            BiBusSpec.initialiseHeaders((SequenceSpec[])new SequenceSpec[]{spec});
            TaskID id = TaskID.create();
            BiBusContext bbrc = this.createDelegatedRunContext(id, spec);
            monitorable = this.createMonitorable((BiBusRunMonitorableAdapter)((Object)bbrc), request, attachments, headers);
        } else if (request.getSpecification() != null) {
            monitorable = this.createMonitorable(null, request, attachments, headers);
        } else {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("No specification or objectPath in the AsynchRequest provided to the Monitoring Service background() method.");
            MonitorServiceException mse = new MonitorServiceException(I18NCode.MON_BACKGROUND_ERROR);
            throw mse;
        }
        monitorable.getBiBusHeader().getTracking().setConversationContext(originalContext);
        monitorable.getBiBusHeader().getTracking().setRequestContext(requestID);
        monitorable.getBiBusHeader().getTracking().setSessionContext(sessionID);
        DelegatedTaskRunner runner = new DelegatedTaskRunner(monitorable);
        Thread thread = new Thread((Runnable)runner, "DelegatedTaskRunner-" + monitorable.getId().toXMLString());
        thread.start();
        return monitorable.getId();
    }

    @Override
    public Object runTaskImmediate(TaskRunContext context) throws LocalizableException {
        if (context instanceof BiBusRunContext) {
            TSE.trace("Immediate run started");
            context.setStatus(TaskStatus.READY);
            NCTaskQueueTable.getInstance().setStatus(context.getTaskId(), TaskQueueStatus.ALLOCATED);
            if (context.getTaskRecord() != null) {
                context.getTaskRecord().setStatus(TaskQueueStatus.ALLOCATED);
            }
            TaskStatusChangedCmd cmd = new TaskStatusChangedCmd(context);
            TSEStateMapProcessor.getInstance().queueCmdAndWait(cmd);
            Object reply = ((BiBusContext)context).run();
            TSE.trace("Immediate run finished");
            return reply;
        }
        return null;
    }

    @Override
    public void authenticateHeader(BiBusSpec taskSpec, boolean clone) throws LocalizableException, EMFSecurityException, RemoteException {
        BiBusHeader header = taskSpec.header;
        JobBiBusHeaders jobHdr = new JobBiBusHeaders(header);
        CAM cam = header.getCAM();
        if (cam != null && cam.getAction() != null && cam.getAction().equals("logonAs")) {
            AuthenticatorFactory.getInstance().logon(jobHdr);
            taskSpec.logOff = true;
        } else {
            AuthenticatorFactory.getInstance().authenticate(jobHdr);
            if (clone) {
                AuthenticatorFactory.getInstance().clonePassport(jobHdr);
                if (taskSpec.getCredentialPath() != null) {
                    jobHdr.setCamCredential(taskSpec.getCredentialPath());
                }
                taskSpec.logOff = true;
            }
        }
        taskSpec.header = this.validateRequestContext(jobHdr.getBiBusHeader());
        taskSpec.authenticated = true;
    }

    private BiBusHeader validateRequestContext(BiBusHeader hdr) {
        BIBusEnvelope biBusEnvelope = null;
        Element trackingElement = null;
        String trackingRequestID = null;
        String requestContext = null;
        Tracking tracking = hdr.getTracking();
        if (tracking == null) {
            tracking = new Tracking();
        }
        if ((requestContext = tracking.getRequestContext()) == null || requestContext.trim().equalsIgnoreCase("")) {
            biBusEnvelope = new BIBusEnvelope();
            trackingElement = biBusEnvelope.getTracking();
            com.cognos.pogo.pdk.Tracking.getInstance().prepareRequestContext(trackingElement, true, hdr.getCAM().getCAMPassport().getId());
            trackingRequestID = trackingElement.element(BIBusEnvelope.BUS_REQUEST_CONTEXT.getName()).getText();
            tracking.setRequestContext(trackingRequestID);
            hdr.setTracking(tracking);
        }
        return hdr;
    }

    @Override
    public boolean cancel(IEventId event, String userName) throws TSEException {
        boolean cancelled = false;
        try {
            TaskID task = TaskID.fromEventId((String)event.toXMLString());
            TaskRunContext context = TaskRunContextFactory.createTaskRunContext(task);
            if (context.getTaskRecord().getRunSpec().cancelledBy == null) {
                context.getTaskRecord().getRunSpec().cancelledBy = userName;
            }
            if (context == null) {
                return false;
            }
            cancelled = this.cancel(context);
        }
        catch (Exception e) {
            TSE.throwException(e);
        }
        return cancelled;
    }

    @Override
    public boolean cancel(TaskRunContext context) throws TaskPersistLayerException {
        TaskRunCancelledCmd cancelCmd = new TaskRunCancelledCmd(context);
        TSEStateMapProcessor.getInstance().queueCmdAndWait(cancelCmd);
        return cancelCmd.cancelled();
    }

    @Override
    public boolean suspend(IEventId event, String userName) throws TSEException {
        boolean suspended = false;
        try {
            TaskID task = TaskID.fromEventId((String)event.toString());
            TaskStateRecord state = new TaskStateRecord();
            if (!state.find(task)) {
                EventTransition.validate(null, null);
            }
            if (state.parentID != null) {
                EventTransition.validate(null, null);
            }
            TSE.validateTransition(state.status, TaskStatus.PAUSED);
            SuspendTaskCmd cmd = new SuspendTaskCmd(task);
            TSEStateMapProcessor.getInstance().queueCmdAndWait(cmd);
            suspended = cmd.isSuspended();
            if (suspended) {
                TSE.trace(this, "Paused PENDING task");
                this.pauseTask(state, userName);
            }
        }
        catch (Exception e) {
            TSE.throwException(e);
        }
        return suspended;
    }

    @Override
    public boolean resume(IEventId event, String userName) throws TSEException {
        boolean resumed = false;
        try {
            TaskID task = TaskID.fromEventId((String)event.toString());
            TaskStateRecord state = new TaskStateRecord();
            if (!state.find(task)) {
                EventTransition.validate(null, null);
            }
            if (state.parentID != null) {
                EventTransition.validate(null, null);
            }
            TSE.validateTransition(state.status, TaskStatus.PENDING);
            ResumeTaskCmd cmd = new ResumeTaskCmd(task);
            TSEStateMapProcessor.getInstance().queueCmdAndWait(cmd);
            resumed = cmd.isResumed();
            if (resumed) {
                TSE.trace(this, "Resumed task from PAUSED to READY/PENDING");
                this.resumeTask(state, userName);
            }
        }
        catch (TaskPersistLayerException e) {
            TSE.throwException((Exception)((Object)e));
        }
        catch (Exception e) {
            TSE.throwException(e);
        }
        return resumed;
    }

    void pauseTask(TaskStateRecord tsr, String userName) throws TaskPersistLayerException, RemoteException, MalformedURLException, ServiceException, MonitorServiceException, TSEException {
        TaskRecord tr = NCTaskQueueTable.getInstance().find(tsr.taskID, true);
        TaskRunContext parentContext = TaskRunContextFactory.createTaskRunContext(tr, tsr);
        HistoryWriter writer = parentContext.getHistoryWriter();
        if (writer != null) {
            parentContext.getHistoryWriter().updateHistoryStatus();
            writer.addInfoDetail(MonitorI18NCode.MSG_MS_SUSPENDED_BY_USER_Y, new Object[]{userName});
        }
    }

    void resumeTask(TaskStateRecord tsr, String userName) throws TaskPersistLayerException, RemoteException, MalformedURLException, ServiceException, MonitorServiceException, TSEException {
        TaskRecord tr = NCTaskQueueTable.getInstance().find(tsr.taskID, true);
        TaskRunContext parentContext = TaskRunContextFactory.createTaskRunContext(tr, tsr);
        HistoryWriter writer = parentContext.getHistoryWriter();
        if (writer != null) {
            parentContext.getHistoryWriter().updateHistoryStatus();
            writer.addInfoDetail(MonitorI18NCode.MSG_MS_RELEASED_BY_USER_Y, new Object[]{userName});
        }
        MonitorService.instance().getJobQueueReceiver().notifyNewQueueEntries();
    }

    public static void validateTransition(TaskStatus from, TaskStatus to) throws MonitorServiceException {
        EventStatus current = TaskStatus.mapStatus((TaskStatus)from);
        EventStatus target = TaskStatus.mapStatus((TaskStatus)to);
        EventTransition.validate(current, target);
    }

    public static void trace(String msg) {
        TSE.getRTLogger().debug(msg);
        if (trace) {
            System.out.println(msg);
        }
    }

    public static void trace(Object obj, String msg) {
        msg = obj.getClass().getName() + ':' + msg;
        TSE.trace(msg);
    }

    public static void logException(Throwable e) {
        TSE.getRTLogger().debug(e);
        TSE.getRTLogger().log(SDSLevel.WARN, MonitorI18NCode.MSG_TSE_GENERAL_ERROR, new Object[]{e.getMessage()});
    }

    public static void throwException(Exception e) throws TSEException {
        SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug((Throwable)e);
        if (e instanceof TSEException) {
            throw (TSEException)e;
        }
        TSE.logException(e);
        throw new TSEException(e);
    }

    public static SDSLogger getRTLogger() {
        return SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME);
    }

    @Override
    public void doCleanup() {
        TSEStateMapProcessor.getInstance().queueCmd(new CleanTaskTableCmd(MonitorI18NCode.MSG_MS_FAIL_RECOVERED));
    }

    public static boolean isTrace() {
        return trace;
    }

    private ConversationContext cloneConversationContext(ConversationContext context) {
        String cid = context.getId();
        String nodeID = context.getNodeID();
        int pid = context.getProcessID();
        int affinity = context.getAffinityStrength();
        String status = context.getStatus();
        ConversationContext cc = new ConversationContext();
        cc.setId(cid);
        cc.setNodeID(nodeID);
        cc.setProcessID(pid);
        cc.setAffinityStrength(affinity);
        cc.setStatus(status);
        return cc;
    }

    private BiBusContext createDelegatedRunContext(final TaskID id, final SequenceSpec spec) throws TSEException {
        BiBusContext result = null;
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                TaskRecord record = TSE.this.createDelegatedTaskRecord(id, spec);
                TaskStateRecord state = TSE.this.createDelegatedTaskStateRecord(id, spec);
                record.create();
                state.create();
                return new BiBusRunContext(record, null, state);
            }
        };
        SQLTransactionExecuteHandler transHandler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
        try {
            result = (BiBusContext)transHandler.execute(sqlExecute);
        }
        catch (TaskPersistLayerException e) {
            TSE.throwException((Exception)((Object)e));
        }
        return result;
    }

    private TaskRecord createDelegatedTaskRecord(TaskID id, SequenceSpec spec) {
        TaskRecord record = new TaskRecord(spec, id, null, false);
        record.setActualExecutionTime(new Date().getTime());
        record.setSdsInstanceId(SDSInstanceManager.getInstance().getThisInstance().getGuid());
        record.setStatus(TaskQueueStatus.ALLOCATED);
        return record;
    }

    private TaskStateRecord createDelegatedTaskStateRecord(TaskID id, SequenceSpec spec) {
        TaskStateRecord state = new TaskStateRecord(spec, 1, null, false);
        state.count = 0;
        state.countSeq = 1;
        state.curSeq = 1;
        state.executing = 1;
        state.parentID = null;
        state.seq = 1;
        state.status = TaskStatus.RUNNING;
        state.stopOnError = false;
        state.taskID = id;
        state.writeAllHistories = true;
        return state;
    }

    private Monitorable createMonitorable(BiBusRunMonitorableAdapter task, AsynchRequest request, Attachment[] attachments, JobBiBusHeaders header) throws TSEException {
        BaseMonitorable monitorable;
        block5: {
            monitorable = null;
            try {
                if (task != null) {
                    monitorable = new MonitorableObject(task, request, attachments, header, true);
                    break block5;
                }
                if (request.getSpecification() != null) {
                    monitorable = new MonitorableSpecification(request, attachments, header);
                    break block5;
                }
                throw new TSEException("Invalid objects passed to TSE.createMonitorable()");
            }
            catch (RemoteException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("Remote exception when creating Monitorable : " + e.getLocalizedMessage());
                TSE.throwException(e);
            }
            catch (SDSServiceException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("SDSServiceException when creating Monitorable : " + e.getLocalizedMessage());
                TSE.throwException((Exception)((Object)e));
            }
        }
        return monitorable;
    }
}

