/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.serverinst.InstanceFailedEvent;
import com.cognos.jsmcommon.serverinst.SDSInstance;
import com.cognos.jsmcommon.serverinst.SDSInstanceListener;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.impl.state.HistoryRecord;
import com.cognos.monitor.tse.BiBusRunContext;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.cognos.monitor.tse.WriteFinalHistoryTask;
import com.cognos.monitor.tse.commands.RunCompleteCmd;
import com.cognos.monitor.tse.commands.TaskRunFinishedCmd;
import com.cognos.monitor.util.HistoryHelper;
import com.cognos.sds.event.IEventId;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TSEFailedInstanceListener
implements SDSInstanceListener {
    String failedSdsId;
    I18NMessage message;
    private boolean running;

    public void start() {
        SDSInstanceManager.getInstance().addInstanceListener((SDSInstanceListener)this);
    }

    public void stop() {
        SDSInstanceManager.getInstance().removeInstanceListener((SDSInstanceListener)this);
    }

    public void instanceFailed(InstanceFailedEvent event) {
        boolean interrupted = false;
        while (!TSEStateMapProcessor.getInstance().isIdle()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e2) {
                interrupted = true;
            }
        }
        if (!interrupted) {
            this.doInstanceFailed(event.getFailedInstance().getGuid(), MonitorI18NCode.MSG_MS_FAIL_RECOVERED, false);
        }
    }

    void doInstanceFailed(String sdsInst, I18NCode message, boolean immediate) {
        this.instanceFailed(sdsInst, message, immediate);
    }

    public void otherInstanceCountChanged(List<SDSInstance> instances) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceFailed(String sdsInst, I18NCode message, boolean immediate) {
        boolean doCheck = false;
        TSEFailedInstanceListener tSEFailedInstanceListener = this;
        synchronized (tSEFailedInstanceListener) {
            if (!this.running) {
                this.running = true;
                doCheck = true;
            }
        }
        if (!doCheck) {
            return;
        }
        try {
            this.message = new I18NMessage(message, null, null);
            this.failedSdsId = sdsInst;
            HashSet completed = new HashSet();
            TSE.trace(this, "instanceFailed " + this.failedSdsId);
            TaskStateTable.StepInfo[] inactiveTasks = this.fixInactiveRootTaskInstanceIds();
            TaskStateTable.StepInfo[] tasks = TaskStateTable.getRunningTasks((String)this.failedSdsId);
            for (int i = 0; i != tasks.length && !Thread.interrupted(); ++i) {
                try {
                    TaskStatus status = tasks[i].getStatus();
                    if (tasks[i].runViaMS || tasks[i].parentId == null) {
                        this.handleMonitorServiceParentTask(tasks[i]);
                    } else {
                        this.failTask(status, tasks[i], completed);
                    }
                    if (immediate) continue;
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException status) {
                    continue;
                }
                catch (Exception e) {
                    TSE.logException(e);
                }
            }
            this.writeIncompleteHistories(tasks, completed);
        }
        catch (TaskPersistLayerException e) {
            TSE.logException(e);
        }
        finally {
            TSEFailedInstanceListener tSEFailedInstanceListener2 = this;
            synchronized (tSEFailedInstanceListener2) {
                this.running = false;
            }
        }
    }

    private void handleMonitorServiceParentTask(TaskStateTable.StepInfo task) throws TaskPersistLayerException {
        BiBusRunContext.markHistoryAsFailed(task.taskId, MonitorI18NCode.MSG_MS_CORRUPT_EVENT);
        if (task.status != TaskStatus.COMPLETED.getId()) {
            TaskStateRecord.setStatus((TaskID)task.taskId, (TaskStatus)TaskStatus.FAILED);
        }
    }

    private TaskStateTable.StepInfo[] fixInactiveRootTaskInstanceIds() throws TaskPersistLayerException {
        TaskStateTable.StepInfo[] inactiveTasks = TaskStateTable.getInactiveTasks((String)this.failedSdsId);
        for (int j = 0; j < inactiveTasks.length && !Thread.interrupted(); ++j) {
            final TaskStateTable.StepInfo inactiveTask = inactiveTasks[j];
            SQLExecute sqlExecute = new SQLExecute(){

                public Object execute() throws TaskPersistLayerException {
                    TaskStateTable.StepInfo[] steps = TaskStateTable.getStatusChildren((TaskID)inactiveTask.parentId, (TaskStatus)TaskStatus.RUNNING);
                    if (steps != null && steps.length > 0) {
                        return null;
                    }
                    if (TSEFailedInstanceListener.this.hasExecutingDescendents(inactiveTask.taskId)) {
                        return null;
                    }
                    TaskStateTable.setChildrensInstanceID((TaskID)inactiveTask.taskId);
                    return null;
                }
            };
            SQLTransactionExecuteHandler transHandler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
            transHandler.execute(sqlExecute);
        }
        return inactiveTasks;
    }

    private boolean hasExecutingDescendents(TaskID taskId) throws TaskPersistLayerException {
        boolean hasExecutingChildren = false;
        TaskStateTable.StepInfo[] steps = TaskStateTable.getStatusChildren((TaskID)taskId, (TaskStatus)TaskStatus.RUNNING);
        if (steps != null && steps.length > 0) {
            hasExecutingChildren = true;
        } else {
            TaskStateTable.StepInfo[] children = TaskStateTable.getChildren((TaskID)taskId, null);
            TaskStateTable.StepInfo childTask = null;
            if (children != null) {
                for (int i = 0; !(i >= children.length || (childTask = children[i]) != null && (hasExecutingChildren = this.hasExecutingDescendents(childTask.taskId))); ++i) {
                }
            }
        }
        return hasExecutingChildren;
    }

    private void writeIncompleteHistories(TaskStateTable.StepInfo[] tasks, Set completed) {
        HistoryRecord historyRecord = null;
        WriteFinalHistoryTask wfht = new WriteFinalHistoryTask();
        for (int i = 0; i != tasks.length && !Thread.interrupted(); ++i) {
            try {
                if (tasks[i].parentId != null || tasks[i].taskId == null) continue;
                TaskRunContext trc = TaskRunContextFactory.createTaskRunContext(tasks[i].taskId);
                IEventId id = TSE.getInstance().getEventId(tasks[i].taskId);
                historyRecord = HistoryHelper.getHistoryRecord(id);
                if (historyRecord == null) {
                    TaskStateTable.setChildrensInstanceID((TaskID)tasks[i].taskId);
                    if (completed.contains(tasks[i].parentId) || completed.contains(tasks[i].taskId)) continue;
                    TSEStateMapProcessor.getInstance().queueCmdAndWait(new RunCompleteCmd(trc, true));
                    continue;
                }
                historyRecord.addErrorDetail(MonitorI18NCode.MSG_MS_HISTORY_RECOVERED, new Object[0]);
                wfht.purgeTasks(trc);
                continue;
            }
            catch (Exception ex) {
                TSE.trace("FAILOVER: TSEFailedInstanceListener : instanceFailed : Error recovering history : Exception " + ex);
            }
        }
    }

    private void failTask(TaskStatus currentStatus, TaskStateTable.StepInfo step, Set completedMap) throws TaskPersistLayerException, TSEException {
        TaskStateRecord state;
        if (currentStatus == TaskStatus.COMPLETED) {
            NCTaskQueueTable.getInstance().clearSdsInstance(step.taskId);
        } else if (currentStatus.isTerminatingStatus()) {
            if (step.curSeq < step.countSeq || step.count > 0) {
                this.abortChildSteps(step.taskId, completedMap);
            } else {
                BiBusRunContext.markHistoryAsFailed(step.taskId, MonitorI18NCode.MSG_MS_CORRUPT_EVENT);
                NCTaskQueueTable.getInstance().clearSdsInstance(step.taskId);
            }
        } else if (currentStatus == TaskStatus.RUNNING || currentStatus == TaskStatus.PAUSED || currentStatus == TaskStatus.INACTIVE) {
            if (step.curSeq < step.countSeq || step.count > 0) {
                if (this.abortChildSteps(step.taskId, completedMap) == 0) {
                    if (step.count == 0) {
                        this.completeTask(step.taskId, TaskStatus.TERMINATED, completedMap);
                    } else {
                        this.completeTask(step.taskId, TaskStatus.FAILED, completedMap);
                    }
                }
            } else {
                TaskStateRecord state2 = new TaskStateRecord();
                if (state2.find(step.taskId)) {
                    if (state2.parentID != null) {
                        this.abortChildSteps(state2.parentID, completedMap);
                    }
                    if (state2.status.equals((Object)TaskStatus.RUNNING)) {
                        this.completeTask(step.taskId, TaskStatus.TERMINATED, completedMap);
                    }
                }
            }
        } else if (currentStatus == TaskStatus.READY) {
            TaskStateRecord state3 = new TaskStateRecord();
            if (state3.find(step.taskId)) {
                if (state3.parentID != null) {
                    this.abortChildSteps(state3.parentID, completedMap);
                } else if (NCTaskQueueTable.getInstance().stampSdsInstance(step.taskId, TaskQueueStatus.ALLOCATED, TaskQueueStatus.READY)) {
                    TaskStateRecord.setStatus((TaskID)step.taskId, (TaskStatus)TaskStatus.PURGED);
                    this.completeTask(step.taskId, TaskStatus.PURGED, completedMap);
                }
            }
        } else if (currentStatus == TaskStatus.PENDING && (state = new TaskStateRecord()).find(step.taskId) && state.parentID != null && NCTaskQueueTable.getInstance().stampSdsInstance(step.taskId, TaskQueueStatus.ALLOCATED, TaskQueueStatus.QUEUED)) {
            TaskStateRecord.setStatus((TaskID)step.taskId, (TaskStatus)TaskStatus.PURGED);
            this.completeTask(step.taskId, TaskStatus.PURGED, completedMap);
        }
    }

    private void completeTask(TaskID taskID, TaskStatus status, Set completed) throws TaskPersistLayerException, TSEException {
        if (completed.contains(taskID)) {
            return;
        }
        TaskRunContext context = TaskRunContextFactory.createTaskRunContext(taskID);
        context.setStatus(status);
        TaskRunFinishedCmd cmd = new TaskRunFinishedCmd(context, this.message);
        TSEStateMapProcessor.getInstance().queueCmdAndWait(cmd);
        completed.add(taskID);
    }

    private int abortChildSteps(TaskID taskID, Set completed) throws TaskPersistLayerException, TSEException {
        if (completed.contains(taskID)) {
            return 0;
        }
        TaskStateRecord state = new TaskStateRecord();
        if (state.find(taskID)) {
            completed.add(taskID);
            TaskStateRecord.setStepFailedAbort((TaskID)taskID);
            TaskStateTable.StepInfo[] steps = TaskStateTable.getChildren((TaskID)taskID, (TaskStatus)TaskStatus.READY);
            for (int i = 0; i != steps.length; ++i) {
                NCTaskQueueTable.getInstance().stampSdsInstance(steps[i].taskId, TaskQueueStatus.ALLOCATED, TaskQueueStatus.READY);
                TaskStateRecord.updateStatus((TaskID)steps[i].taskId, (TaskStatus)TaskStatus.PURGED, (TaskStatus)TaskStatus.READY);
                this.completeTask(steps[i].taskId, TaskStatus.PURGED, completed);
            }
            return steps.length;
        }
        return 0;
    }

    TaskID getParentId(TaskID taskId) throws TaskPersistLayerException {
        TaskID id = null;
        TaskStateRecord state = new TaskStateRecord();
        if (state.find(taskId)) {
            id = state.parentID;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        TSEFailedInstanceListener tSEFailedInstanceListener = this;
        synchronized (tSEFailedInstanceListener) {
            return this.running;
        }
    }
}

