/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.ITSEStateMapProcessor;
import com.cognos.monitor.tse.LowPriorityCmd;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;

public final class TSEStateMapProcessorImpl
implements ITSEStateMapProcessor {
    ArrayList cmdQueue = new ArrayList();
    ArrayList cmdLowPriorityQueue = new ArrayList();
    boolean exit;
    Thread thread;
    boolean idle;
    private boolean m_waitAndQueue = false;

    TSEStateMapProcessorImpl() {
    }

    @Override
    public synchronized void start() {
        try {
            String queueAndWait = CRNProperties.getInstance().getProperty("state.map.processor.queue.and.wait");
            if (queueAndWait != null) {
                this.m_waitAndQueue = Boolean.valueOf(queueAndWait);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, (LocalizableException)((Object)ex));
        }
        catch (Throwable t) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        if (this.thread == null) {
            this.exit = false;
            this.thread = new Thread((Runnable)this, "StateMapProcessor");
            this.thread.setDaemon(true);
            this.thread.start();
        }
        TSE.trace("tse state map processor start called");
    }

    @Override
    public synchronized void stop(boolean immediately) {
        this.exit = true;
        if (this.thread != null && immediately) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
            this.cmdQueue.clear();
            this.cmdLowPriorityQueue.clear();
        }
        TSE.trace("tse state map processor stop called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        TSEStateMapProcessorImpl tSEStateMapProcessorImpl = this;
        synchronized (tSEStateMapProcessorImpl) {
            return this.idle;
        }
    }

    @Override
    public void queueCmdAndWait(Cmd cmd) throws TaskPersistLayerException {
        this.queueCmd(cmd, true);
        cmd.rethrowCaughtException();
    }

    @Override
    public void queueCmd(Cmd cmd) {
        this.queueCmd(cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueCmd(Cmd cmd, boolean wait) {
        if (this.thread == null || this.exit) {
            return;
        }
        if (!wait) {
            ArrayList arrayList = this.cmdQueue;
            synchronized (arrayList) {
                if (cmd instanceof LowPriorityCmd) {
                    this.cmdLowPriorityQueue.add(cmd);
                } else {
                    this.cmdQueue.add(cmd);
                }
                this.cmdQueue.notify();
            }
        }
        if (this.thread == Thread.currentThread() || TaskPersistLayer.inTransaction()) {
            this.doActionAndNotify(cmd);
        } else {
            try {
                cmd.setDoNotify(true);
                this.queueCmd(cmd, false);
                ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TSEStateMapProcessorImpl.queueCmd.WaitToComplete");
                try {
                    Cmd cmd2 = cmd;
                    synchronized (cmd2) {
                        if (cmd.getDoNotify()) {
                            cmd.wait();
                        }
                    }
                }
                finally {
                    zipiTimer.stop();
                }
            }
            catch (InterruptedException e) {
                TSE.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Cmd cmd = null;
        this.exit = false;
        while (!this.exit) {
            try {
                ArrayList arrayList = this.cmdQueue;
                synchronized (arrayList) {
                    if (this.cmdQueue.size() == 0 && this.cmdLowPriorityQueue.size() == 0) {
                        ZipiTimer zipiTimer3 = ZipiBridge.startTimer((String)"TSEStateMapProcessorImpl.IdleAndWaitNothingInQueue");
                        try {
                            this.idle = true;
                            this.cmdQueue.wait(5000L);
                            if (this.cmdQueue.size() == 0 && this.cmdLowPriorityQueue.size() == 0) {
                                this.cmdQueue.wait();
                            }
                        }
                        finally {
                            zipiTimer3.stopAndClear();
                        }
                    }
                    Cmd cmd2 = cmd = this.cmdQueue.size() != 0 ? (Cmd)this.cmdQueue.remove(0) : null;
                    if (cmd == null && this.cmdLowPriorityQueue.size() != 0) {
                        cmd = (Cmd)this.cmdLowPriorityQueue.remove(0);
                    }
                    if (cmd != null) {
                        this.idle = false;
                    }
                }
                if (cmd == null) continue;
                ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TSEStateMapProcessorImpl.run.doAction");
                try {
                    this.doActionAndNotify(cmd);
                    cmd = null;
                }
                finally {
                    zipiTimer.stopAndClear();
                }
            }
            catch (InterruptedException e) {
                this.exit = true;
                this.idle = true;
                TSE.logException(e);
            }
            catch (Throwable e) {
                this.idle = true;
                TSE.logException(e);
            }
        }
        TSE.trace("tse state map processor has stopped");
    }

    private void doAction(Cmd cmd) {
        try {
            cmd.doAction();
        }
        catch (TSEException e) {
            cmd.setException(new TaskPersistLayerException((Exception)e));
        }
        catch (Exception e) {
            TSE.logException(e);
            cmd.setException(new TaskPersistLayerException(e));
        }
    }

    @Override
    public void processCmd(Cmd cmd) throws TaskPersistLayerException {
        if (this.m_waitAndQueue) {
            this.queueCmdAndWait(cmd);
        } else {
            this.doAction(cmd);
            cmd.rethrowCaughtException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doActionAndNotify(Cmd cmd) {
        this.doAction(cmd);
        if (cmd.getDoNotify()) {
            ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TSEStateMapProcessorImpl.WakeUpThreadIn.queueCmd.WaitToComplete");
            try {
                Cmd cmd2 = cmd;
                synchronized (cmd2) {
                    cmd.notify();
                    cmd.setDoNotify(false);
                }
            }
            finally {
                zipiTimer.stop();
            }
        }
    }
}

