/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.HistoryTopicsEnum;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.Validate;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.impl.state.RecordableException;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEParameter;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.commands.TaskRunFinishedCmd;
import com.cognos.monitor.tse.commands.TaskRunInactiveCmd;
import com.cognos.monitor.tse.commands.TaskRunPausedCmd;
import com.cognos.monitor.tse.commands.TaskRunStartedCmd;
import com.cognos.sds.event.IEventId;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class TaskRunContextBase
implements TaskRunContext {
    TaskStateRecord taskState;
    TaskRecord task;
    TaskStatus currentStatus;
    TaskStatus failStatus;
    TaskID parentID;
    String[] cachedMessages;

    TaskRunContextBase(TaskRecord task, TaskID parentID, TaskStateRecord taskState) {
        this.task = task;
        this.parentID = parentID;
        this.failStatus = taskState.failStatus;
        this.currentStatus = taskState.status;
        this.taskState = taskState;
    }

    @Override
    public IEventId getEventId() {
        return TSE.getInstance().getEventId(this.task.getTaskId());
    }

    @Override
    public TaskID getTaskId() {
        return this.task.getTaskId();
    }

    @Override
    public TaskID getParentTaskId() {
        return this.parentID;
    }

    @Override
    public TaskStatus getStatus() {
        return this.currentStatus;
    }

    @Override
    public void setStatus(TaskStatus status) {
        this.currentStatus = status;
    }

    @Override
    public void setFailStatus(TaskStatus status) {
        this.failStatus = status;
    }

    public String getServiceName() {
        return this.task.getRunSpec().serviceName;
    }

    @Override
    public TaskRecord getTaskRecord() {
        return this.task;
    }

    @Override
    public void onTaskRunStartedCmd() throws TSEException {
    }

    @Override
    public TaskStateRecord getTaskState() {
        return this.taskState;
    }

    public String toString() {
        return this.getClass().getName() + " taskID=" + this.task.getTaskId().getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeTaskStatus(TaskStatus newStatus, I18NMessage message) throws TSEException {
        block24: {
            TSE.trace(this, "update task " + this.getTaskId() + " status called with status " + newStatus.toString());
            try {
                Cmd cmd;
                ZipiTimer zipiTimer;
                if (newStatus == TaskStatus.RUNNING) {
                    if (this.currentStatus == newStatus) {
                        return;
                    }
                    if (this.currentStatus.equals((Object)TaskStatus.READY) && !this.failStatus.isTerminatingStatus()) {
                        zipiTimer = ZipiBridge.startTimer((String)"TaskRunContextBase.changeTaskStatus");
                        zipiTimer.setObjectPath("running");
                        try {
                            this.currentStatus = TaskStatus.RUNNING;
                            TSEStateMapProcessor.getInstance().processCmd(new TaskRunStartedCmd(this));
                        }
                        finally {
                            zipiTimer.stop();
                        }
                    }
                    if (this.failStatus.isTerminatingStatus()) {
                        this.currentStatus = this.failStatus;
                    }
                } else if (newStatus == TaskStatus.PAUSED) {
                    zipiTimer = ZipiBridge.startTimer((String)"TaskRunContextBase.changeTaskStatus");
                    zipiTimer.setObjectPath("paused");
                    try {
                        Validate.stateIsTrue((this.currentStatus != TaskStatus.PAUSED ? 1 : 0) != 0);
                        this.currentStatus = TaskStatus.PAUSED;
                        TSEStateMapProcessor.getInstance().processCmd(new TaskRunPausedCmd(this));
                    }
                    finally {
                        zipiTimer.stop();
                    }
                } else if (newStatus == TaskStatus.INACTIVE) {
                    zipiTimer = ZipiBridge.startTimer((String)"TaskRunContextBase.changeTaskStatus");
                    zipiTimer.setObjectPath("inactive");
                    try {
                        this.currentStatus = TaskStatus.INACTIVE;
                        cmd = new TaskRunInactiveCmd(this);
                        TSEStateMapProcessor.getInstance().processCmd(cmd);
                    }
                    finally {
                        zipiTimer.stop();
                    }
                } else {
                    this.currentStatus = newStatus;
                }
                if (!this.currentStatus.isTerminatingStatus()) break block24;
                zipiTimer = ZipiBridge.startTimer((String)"TaskRunContextBase.changeTaskStatus");
                zipiTimer.setObjectPath("terminating");
                try {
                    cmd = new TaskRunFinishedCmd(this, message);
                    TSEStateMapProcessor.getInstance().processCmd(cmd);
                }
                finally {
                    zipiTimer.stop();
                }
            }
            catch (TaskPersistLayerException e) {
                TSE.throwException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void onReceiveTaskToRun() {
    }

    @Override
    public ParameterValue[] getTseParameters() throws TSEException, RecordableException {
        List topics = HistoryTopicsEnum.getTopics();
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        for (int i = 0; i != topics.size(); ++i) {
            HistoryTopicsEnum topicEnum = (HistoryTopicsEnum)topics.get(i);
            Locale locale = this.getContentLocale();
            String topicName = topicEnum.getTopicName(locale);
            TSEParameter tseParam = this.getTseParameterValue(topicName);
            Validate.notNull((Object)tseParam);
            ParameterValue pv = ObjectModelUtil.makeParameterValue((String)topicEnum.getEscapedTopic(locale), (String)tseParam.getDisplayValue());
            values.add(pv);
        }
        return values.toArray(new ParameterValue[0]);
    }

    @Override
    public TSEParameter getTseParameterValue(String name) throws TSEException, RecordableException {
        BiBusHeader header = ((BiBusRunSpec)this.task.getRunSpec()).header;
        HistoryTopicsEnum historyEnum = HistoryTopicsEnum.getTypeEnum((String)name, (Locale)this.getContentLocale());
        if (historyEnum != null) {
            if (historyEnum.equals((Object)HistoryTopicsEnum.RAN_BY)) {
                return new TSEParameter(this.getFullName(), header);
            }
            if (historyEnum.equals((Object)HistoryTopicsEnum.REQUEST_TIME)) {
                return new TSEParameter(this.task.getTimeStamp(), header);
            }
            if (historyEnum.equals((Object)HistoryTopicsEnum.START_TIME)) {
                return new TSEParameter(this.task.getActualExecutionTime(), header);
            }
            if (historyEnum.equals((Object)HistoryTopicsEnum.STATUS)) {
                return new TSEParameter(EventStatus.FAILED.statusName(), header);
            }
            if (historyEnum.equals((Object)HistoryTopicsEnum.DISPATCHER)) {
                return new TSEParameter(this.task.getDispatcherId(), header);
            }
            if (historyEnum.equals((Object)HistoryTopicsEnum.MESSAGES)) {
                String[] msgs = this.getHistoryMessages();
                String msg = "";
                for (int i = 0; i != msgs.length; ++i) {
                    msg = msg + msgs[i];
                    msg = msg + '\n';
                }
                return new TSEParameter(msg, header);
            }
        }
        return null;
    }

    public String[] getHistoryMessages() throws TSEException, RecordableException {
        if (this.cachedMessages == null) {
            ArrayList<String> msgs = new ArrayList<String>();
            BaseHistoryDetail[] details = this.getHistoryWriter().readParentHistoryDetails();
            if (details == null) {
                this.cachedMessages = new String[0];
            } else {
                for (int i = 0; i != details.length; ++i) {
                    if (details[i].getDetail() == null || details[i].getDetail().getValue() == null) continue;
                    msgs.add(details[i].getDetail().getValue());
                }
                this.cachedMessages = msgs.toArray(new String[0]);
            }
        }
        return this.cachedMessages;
    }

    private Locale getContentLocale() {
        BiBusHeader header = ((BiBusRunSpec)this.task.getRunSpec()).header;
        String localeString = Locale.getDefault().toString();
        try {
            localeString = LocaleUtil.getUserPreference((String)"contentLocale", (BiBusHeader)header);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LocaleUtil.getLocale((String)localeString);
    }
}

