/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.tse.BiBusRequestSpec;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.Validate;
import com.cognos.monitor.tse.BiBusContext;
import com.cognos.monitor.tse.BiBusRequestContext;
import com.cognos.monitor.tse.BiBusRequestRestartContext;
import com.cognos.monitor.tse.BiBusRestartContext;
import com.cognos.monitor.tse.BiBusRunContext;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContext;

public class TaskRunContextFactory {
    public static TaskRunContext createTaskRunContext(TaskID taskID) throws TSEException {
        TaskRecord task = null;
        TaskStateRecord state = new TaskStateRecord();
        boolean found = false;
        try {
            task = NCTaskQueueTable.getInstance().find(taskID, true);
            if (null != task) {
                found = state.find(taskID);
            }
        }
        catch (TaskPersistLayerException e) {
            TSE.throwException((Exception)((Object)e));
        }
        if (null == task) {
            task = new TaskRecord();
        }
        return found ? TaskRunContextFactory.createTaskRunContext(task, state) : null;
    }

    public static TaskRunContext createTaskRunContext(TaskRecord task, TaskStateRecord state) throws TSEException {
        BiBusContext context = null;
        try {
            if (task.getRunSpec() instanceof BiBusRunSpec) {
                if (task.getRestartId() == null) {
                    TaskID parent = null;
                    if (state.parentID != null) {
                        parent = TaskPersistLayer.getInstance().resolveTaskId(state.parentID);
                    }
                    context = new BiBusRunContext(task, parent, state);
                } else {
                    TaskRecord parent = null;
                    if (state.parentID != null) {
                        parent = NCTaskQueueTable.getInstance().find(state.parentID, false);
                    }
                    if (null == parent) {
                        parent = new TaskRecord();
                    }
                    context = new BiBusRestartContext(task, parent.getRestartId(), state, state.countSeq == 0);
                }
            } else if (task.getRunSpec() instanceof BiBusRequestSpec) {
                if (task.getRestartId() == null) {
                    TaskID parent = null;
                    if (state.parentID != null) {
                        parent = TaskPersistLayer.getInstance().resolveTaskId(state.parentID);
                    }
                    context = new BiBusRequestContext(task, parent, state);
                } else {
                    TaskRecord parent = null;
                    if (state.parentID != null) {
                        parent = NCTaskQueueTable.getInstance().find(state.parentID, false);
                    }
                    if (null == parent) {
                        parent = new TaskRecord();
                    }
                    context = new BiBusRequestRestartContext(task, parent.getRestartId(), state, state.countSeq == 0);
                }
            } else {
                Validate.isTrue((boolean)false);
            }
        }
        catch (TaskPersistLayerException e) {
            TSE.throwException((Exception)((Object)e));
        }
        return context;
    }

    public static TaskRunContext getRootParentTaskRunContext(final TaskRecord task) throws TSEException {
        SQLExecute sqlExecute = new SQLExecute(){

            public Object execute() throws TaskPersistLayerException {
                TaskRunContext trc = null;
                try {
                    TaskStateRecord[] parents;
                    TaskStateRecord state = new TaskStateRecord();
                    boolean found = state.find(task.getTaskId());
                    TaskStateRecord root = null;
                    if (found && (parents = state.findAncestors()) != null && parents.length > 0) {
                        root = parents[parents.length - 1];
                    }
                    trc = root != null ? TaskRunContextFactory.createTaskRunContext(root.taskID) : TaskRunContextFactory.createTaskRunContext(task.getTaskId());
                }
                catch (TSEException e) {
                    throw new TaskPersistLayerException((Exception)e);
                }
                return trc;
            }
        };
        TaskRunContext trc = null;
        SQLExecuteHandler handler = new SQLExecuteHandler(JSMCommonCategory.RUNTIME, true);
        try {
            trc = (TaskRunContext)handler.execute(sqlExecute);
        }
        catch (TaskPersistLayerException e) {
            if (e.getNested() != null && e.getNested() instanceof TSEException) {
                throw (TSEException)e.getNested();
            }
            TSE.throwException((Exception)((Object)e));
        }
        return trc;
    }
}

