/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.developer.schemas.bibus._3.HistoryDetailRelatedHistory;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnumProp;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.event.EventStatusUtil;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.CommonHistoryHelper;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.bursting.BurstDistribution;
import com.cognos.monitor.impl.state.HistoryRecord;
import com.cognos.monitor.impl.state.RecordableException;
import com.cognos.monitor.tse.BiBusRunContext;
import com.cognos.monitor.tse.HistoryWriter;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.historyHelp.HistoryAndDetails;
import com.cognos.monitor.tse.historyHelp.HistoryIterator;
import com.cognos.monitor.tse.historyHelp.HistoryListHelper;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class TaskRunHistoryWriter
implements HistoryWriter {
    private static final BurstDistribution burstDistribution = new BurstDistribution();
    private HistoryRecord record;
    private boolean writeAsWeGo = false;
    private BiBusRunContext runContext;

    TaskRunHistoryWriter(BiBusRunContext runContext, String serviceName) {
        this.runContext = runContext;
        this.checkWrite(serviceName);
        String accountPath = runContext.getBiBusRunSpec().getAccountPath();
        Account userAccount = new Account();
        StringProp prop = new StringProp();
        prop.setValue(accountPath);
        userAccount.setSearchPath(prop);
        if (runContext.task.getHistoryStoreId() != null) {
            Guid guid = new Guid();
            guid.set_value(runContext.task.getHistoryStoreId());
            SearchPathSingleObject historyPath = ObjectModelUtil.getSearchPath((Guid)guid);
            History history = CommonHistoryHelper.getHistoryFromCM((String)historyPath.get_value(), (BiBusHeader)runContext.header.getBiBusHeader());
            if (history != null) {
                this.record = new HistoryRecord(history, runContext.header);
            }
        } else {
            SearchPathSingleObject sp = new SearchPathSingleObject();
            sp.set_value(runContext.getBiBusRunSpec().searchPath);
            this.record = new HistoryRecord(sp, runContext.parentID == null ? null : runContext.parentID.toEventId(), runContext.getRestartID(), runContext.header, userAccount);
        }
    }

    @Override
    public void createHistory(TaskStatus status) throws TSEException {
        if (!this.writeAsWeGo) {
            return;
        }
        try {
            if (this.record != null && this.record.getHistory() == null) {
                this.record.create(this.runContext.getEventId(), TaskStatus.mapStatus((TaskStatus)status));
            }
        }
        catch (RecordableException e) {
            TSE.throwException((Exception)((Object)e));
        }
    }

    @Override
    public void addErrorDetail(I18NCode code, Object[] params) throws TSEException {
        if (this.writeAsWeGo) {
            try {
                if (this.record != null) {
                    this.record.addErrorDetail(code, params);
                }
            }
            catch (RecordableException e) {
                TSE.throwException((Exception)((Object)e));
            }
        } else {
            try {
                BaseHistoryDetail detail = HistoryRecord.makeDetail(code, params, SeverityEnum.error, this.runContext.header);
                this.runContext.addErrorDetail(detail);
            }
            catch (TaskPersistLayerException ex) {
                throw new TSEException((Exception)((Object)ex));
            }
        }
    }

    @Override
    public void addInfoDetail(I18NCode code, Object[] params) throws TSEException {
        if (this.writeAsWeGo) {
            try {
                if (this.record != null) {
                    this.record.addInfoDetail(code, params);
                }
            }
            catch (RecordableException e) {
                TSE.throwException((Exception)((Object)e));
            }
        } else {
            try {
                BaseHistoryDetail details = HistoryRecord.makeDetail(code, params, SeverityEnum.info, this.runContext.header);
                TaskPersistLayer.getInstance().addTaskDetails(this.runContext.getTaskId(), new BaseHistoryDetail[]{details});
            }
            catch (TaskPersistLayerException ex) {
                throw new TSEException((Exception)((Object)ex));
            }
        }
    }

    @Override
    public void updateHistoryStatus() throws TSEException {
        this.updateHistoryStatus(this.runContext.getStatus());
    }

    @Override
    public void updateHistoryStatus(TaskStatus status) throws TSEException {
        if (!this.writeAsWeGo) {
            return;
        }
        try {
            this.runContext.setStatus(status);
            if (TaskStatus.PURGED == this.runContext.getStatus() && this.record != null && this.record.getHistory() == null) {
                this.createHistory(TaskStatus.PURGED);
            } else if (this.record != null) {
                this.record.update(TaskStatus.mapStatus((TaskStatus)status));
            }
        }
        catch (RecordableException e) {
            TSE.throwException((Exception)((Object)e));
        }
    }

    public void addRequestArgumentsDetail(Option[] options, ParameterValue[] parameterValues) throws TSEException {
        if (this.writeAsWeGo) {
            try {
                if (this.record != null) {
                    this.record.addRequestArgumentsDetail(options, parameterValues);
                }
            }
            catch (RecordableException e) {
                TSE.throwException((Exception)((Object)e));
            }
        } else {
            try {
                BaseHistoryDetail details = HistoryRecord.makeDetail(options, parameterValues);
                TaskPersistLayer.getInstance().addTaskDetails(this.runContext.getTaskId(), new BaseHistoryDetail[]{details});
            }
            catch (TaskPersistLayerException ex) {
                throw new TSEException((Exception)((Object)ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] writeFinalHistory() throws TSEException {
        String[] taskIDs = new String[]{};
        TSE.trace(this, "write final history called ");
        if (this.writeAsWeGo) {
            return new String[0];
        }
        HistoryListHelper historyList = new HistoryListHelper();
        try {
            TaskRecord taskRecord = NCTaskQueueTable.getInstance().find(this.runContext.getTaskId(), false);
            SeverityEnumProp rootMax = new SeverityEnumProp();
            History me = this.addInfoToList(historyList, taskRecord, null, rootMax);
            this.addChildSteps(historyList, taskRecord, me, rootMax);
            me.setMaximumDetailSeverity(rootMax);
        }
        catch (TaskPersistLayerException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            TSE.trace(ex.getMessage());
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. TaskPersistLayerException: " + (Object)((Object)ex));
        }
        catch (RecordableException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            TSE.trace(ex.getMessage());
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. RecordableException: " + (Object)((Object)ex));
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)ex);
            TSE.trace(ex.getMessage());
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. Exception: " + ex);
        }
        try {
            HistoryIterator historyBundle = historyList.iterator();
            if (historyBundle.hasNext()) {
                HistoryAndDetails rootHistories = historyBundle.next();
                TSE.trace(this.runContext.getTaskId(), "adding parent history ");
                rootHistories.add(this.runContext.header, true);
                TSE.trace(this.runContext.getTaskId(), "adding child histories ");
                while (historyBundle.hasNext()) {
                    HistoryAndDetails childHistories = historyBundle.next();
                    try {
                        childHistories.add(this.runContext.header, true);
                    }
                    catch (LocalizableException loc) {
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, loc);
                        TSE.trace("problem adding child history " + loc.getLocalizedMessage());
                        TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. LocalizableException: " + (Object)((Object)loc));
                    }
                    catch (Throwable t) {
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, t);
                        TSE.trace("fatal error adding child history " + t.getMessage());
                        TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. Throwable: " + t);
                    }
                }
            }
        }
        catch (SDKClientException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            TSE.trace(ex.getMessage());
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. SDKClientException: " + (Object)((Object)ex));
        }
        catch (EMFSecurityException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)ex);
            TSE.trace(ex.getMessage());
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. EMFSecurityException: " + (Object)((Object)ex));
        }
        finally {
            taskIDs = historyList.getTaskIds();
            historyList = null;
        }
        return taskIDs;
    }

    public String[] writeFinalHistoryForRootTask() throws TSEException {
        String[] taskIDs = new String[]{};
        TSE.trace(this, "TSE_WFH: writeFinalHistoryForRootTask called");
        if (this.writeAsWeGo) {
            return new String[0];
        }
        HistoryListHelper historyList = new HistoryListHelper();
        TaskRecord taskRecord = null;
        try {
            taskRecord = NCTaskQueueTable.getInstance().find(this.runContext.getTaskId(), false);
            SeverityEnumProp rootMax = new SeverityEnumProp();
            History me = this.addInfoToList(historyList, taskRecord, null, rootMax);
            HistoryListHelper childHistoryList = this.getChildHistory(taskRecord, me);
            burstDistribution.propagateChildTaskErrorsToRootHistory(historyList, childHistoryList);
            me.setMaximumDetailSeverity(rootMax);
        }
        catch (TaskPersistLayerException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            TSE.trace(ex.getMessage());
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. TaskPersistLayerException: " + (Object)((Object)ex));
        }
        catch (RecordableException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            TSE.trace(ex.getMessage());
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. RecordableException: " + (Object)((Object)ex));
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)ex);
            TSE.trace(ex.getMessage());
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. Exception: " + ex);
        }
        try {
            HistoryIterator historyBundle = historyList.iterator();
            if (historyBundle.hasNext()) {
                HistoryAndDetails rootHistories = historyBundle.next();
                TSE.trace(this.runContext.getTaskId(), "adding parent history ");
                rootHistories.add(this.runContext.header, true);
                taskRecord.setHistoryStoreId(rootHistories.getHistoryStoreId());
                ArrayList<String> updateFields = new ArrayList<String>();
                updateFields.add("HISTORY_STORE_ID");
                try {
                    taskRecord.update(updateFields.toArray(new String[0]));
                }
                catch (TaskPersistLayerException e) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
                    TSE.trace(e.getMessage());
                    TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. TaskPersistLayerException: " + (Object)((Object)e));
                }
            }
        }
        catch (SDKClientException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            TSE.trace(ex.getMessage());
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. SDKClientException: " + (Object)((Object)ex));
            throw new TSEException((Exception)((Object)ex));
        }
        catch (EMFSecurityException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)ex);
            TSE.trace(ex.getMessage());
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. EMFSecurityException: " + (Object)((Object)ex));
            throw new TSEException((Exception)((Object)ex));
        }
        finally {
            taskIDs = historyList.getTaskIds();
            historyList = null;
        }
        return taskIDs;
    }

    private HistoryListHelper getChildHistory(TaskRecord taskRecord, History me) throws TaskPersistLayerException, RecordableException, SDKClientException, EMFSecurityException {
        HistoryListHelper childHistory = new HistoryListHelper();
        this.addChildSteps(childHistory, taskRecord, me, new SeverityEnumProp());
        return childHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] writeFinalHistoryForChildTasks() {
        String[] taskIDs;
        block26: {
            taskIDs = new String[]{};
            TSE.trace(this, "writeFinalHistoryForChildTasks called ");
            if (this.writeAsWeGo) {
                return new String[0];
            }
            HistoryListHelper historyList = new HistoryListHelper();
            History rootHistory = null;
            SeverityEnumProp cachedRootMaxSeverity = new SeverityEnumProp();
            SeverityEnumProp maxSeverity = new SeverityEnumProp();
            ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TaskRunHistoryWriter.writeFinalHistoryForChildTasks.BuildHistoryDetails");
            try {
                TaskRecord taskRecord = NCTaskQueueTable.getInstance().find(this.runContext.getTaskId(), false);
                rootHistory = this.addInfoToList(historyList, taskRecord, null, maxSeverity);
                if (taskRecord.getHistoryStoreId() == null) {
                    HistoryAndDetails thisHistory = new HistoryAndDetails(rootHistory);
                    thisHistory.add(this.runContext.header, true);
                }
                cachedRootMaxSeverity.setValue(maxSeverity.getValue());
                this.addChildSteps(historyList, taskRecord, rootHistory, maxSeverity);
                rootHistory.setMaximumDetailSeverity(maxSeverity);
            }
            catch (TaskPersistLayerException ex) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
                TSE.trace(ex.getMessage());
                TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. TaskPersistLayerException: " + (Object)((Object)ex));
            }
            catch (RecordableException ex) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
                TSE.trace(ex.getMessage());
                TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. RecordableException: " + (Object)((Object)ex));
            }
            catch (Exception ex) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)ex);
                TSE.trace(ex.getMessage());
                TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. Exception: " + ex);
            }
            finally {
                zipiTimer.stop();
            }
            burstDistribution.propagateChildTaskErrorsToNonRootParents(historyList);
            CAM cam = null;
            ContentManagerServiceClientPort port = null;
            ZipiTimer zipiTimer1 = ZipiBridge.startTimer((String)"TaskRunHistoryWriter.writeFinalHistoryForChildTasks.WriteHistoryDetailsToCM");
            try {
                HistoryIterator historyBundle = historyList.iterator();
                if (!historyBundle.hasNext()) break block26;
                port = Client.instance().getContentManagerServiceClient(this.runContext.header);
                port.setLogCategory(MonitorCategory.RUNTIME);
                AddOptions options = new AddOptions();
                options.setIgnoreInvalidObjectReference(true);
                options.setReturnProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.eventID});
                historyBundle.next();
                if (maxSeverity != null && this.pickMax(maxSeverity, cachedRootMaxSeverity) == maxSeverity) {
                    try {
                        cam = port.getBiBusHeader().getCAM();
                        port.getBiBusHeader().setCAM(null);
                        port.signNextRequest("JSM");
                        port.update(new BaseClass[]{rootHistory}, new UpdateOptions());
                    }
                    catch (LocalizableException loc) {
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, loc);
                        TSE.trace("problem updating maxSeverity for root history " + loc.getLocalizedMessage());
                        TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. LocalizableException: " + (Object)((Object)loc));
                    }
                }
                TSE.trace(this.runContext.getTaskId(), "adding child histories ");
                while (historyBundle.hasNext()) {
                    HistoryAndDetails details = historyBundle.next();
                    try {
                        details.addChildHistory(port);
                    }
                    catch (LocalizableException loc) {
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, loc);
                        TSE.trace("problem adding child history " + loc.getLocalizedMessage());
                        TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. LocalizableException: " + (Object)((Object)loc));
                    }
                    catch (Throwable t) {
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, t);
                        TSE.trace("fatal error adding child history " + t.getMessage());
                        TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. Throwable: " + t);
                    }
                }
            }
            catch (Exception ex) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)ex);
                TSE.trace(ex.getMessage());
                TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history for task [" + this.runContext.getTaskId() + "]. Exception: " + ex);
            }
            finally {
                if (cam != null) {
                    port.getBiBusHeader().setCAM(cam);
                }
                taskIDs = historyList.getTaskIds();
                historyList = null;
                if (port != null) {
                    port.close();
                }
                zipiTimer1.stop();
            }
        }
        return taskIDs;
    }

    @Override
    public BaseHistoryDetail[] readParentHistoryDetails() throws TSEException, RecordableException {
        ArrayList<BaseHistoryDetail> historyDetailsList = new ArrayList<BaseHistoryDetail>();
        try {
            BaseHistoryDetail[] parentHistoryDetail = this.getDetails(this.runContext.parentID);
            historyDetailsList.addAll(Arrays.asList(parentHistoryDetail));
            TaskStateTable.StepInfo[] childSteps = TaskStateTable.getChildren((TaskID)this.runContext.parentID, (TaskStatus)TaskStatus.FAILED);
            for (int i = 0; childSteps != null && i < childSteps.length; ++i) {
                BaseHistoryDetail[] historyDetail = this.getDetails(childSteps[i].taskId);
                historyDetailsList.addAll(Arrays.asList(historyDetail));
            }
        }
        catch (TaskPersistLayerException e) {
            TSE.throwException((Exception)((Object)e));
        }
        return historyDetailsList.toArray(new BaseHistoryDetail[0]);
    }

    @Override
    public History getHistory() {
        return this.record == null ? null : this.record.getHistory();
    }

    private BaseHistoryDetail[] getDetails(TaskID id) throws TaskPersistLayerException, RecordableException {
        BaseHistoryDetail[] historyDetails = new BaseHistoryDetail[]{};
        if (this.writeAsWeGo) {
            TaskRecord taskRecord = NCTaskQueueTable.getInstance().find(id, false);
            if (null != taskRecord) {
                historyDetails = this.record.readHistoryDetails(taskRecord.getHistoryStoreId());
            }
        } else {
            TaskHistoryDetailRecord detailsRecord = new TaskHistoryDetailRecord(id);
            historyDetails = detailsRecord.readAll();
        }
        return historyDetails;
    }

    private History addInfoToList(HistoryListHelper historyList, TaskRecord taskRecord, History parent, SeverityEnumProp rootMax) throws TaskPersistLayerException, RecordableException, EMFSecurityException, SDKClientException {
        HistoryDetailRelatedHistory related;
        boolean historyExistsInCM;
        HistoryAndDetails thisHistory = null;
        History me = null;
        boolean bl = historyExistsInCM = taskRecord.getHistoryStoreId() != null;
        if (historyExistsInCM) {
            this.record.setUseTrusted(true);
            me = this.record.readHistory(taskRecord.getHistoryStoreId());
            thisHistory = new HistoryAndDetails(null);
        } else {
            me = HistoryRecord.buildHistory(taskRecord, parent != null ? parent.getEventID() : null);
            thisHistory = new HistoryAndDetails(me);
        }
        if (!EventStatusUtil.validateHistoryContainment((History)parent, (History)me)) {
            TSE.trace("found illegal history status combination parent:  child:" + me.getStatus().getValue());
        }
        BaseHistoryDetail[] details = this.getDetails(taskRecord.getTaskId());
        SeverityEnumProp max = null;
        for (int i = 0; i < details.length; ++i) {
            details[i].setSearchPath(this.getDetailPath(me));
            max = this.pickMax(max, details[i].getSeverity());
            thisHistory.AddDetail(details[i]);
        }
        me.setMaximumDetailSeverity(max);
        SeverityEnumProp tempMax = this.pickMax(rootMax, max);
        rootMax.setValue(tempMax.getValue());
        if (parent != null) {
            SeverityEnumProp parentMax = parent.getMaximumDetailSeverity();
            SeverityEnumProp temp2Max = new SeverityEnumProp();
            temp2Max = this.pickMax(parentMax, max);
            parent.setMaximumDetailSeverity(temp2Max);
            if (temp2Max == null) {
                TSE.trace("found illegal status severity values, null");
            } else if (ObjectModelUtil.compareSeverity((SeverityEnum)temp2Max.getValue(), (SeverityEnum)SeverityEnum.warn) > 0 && EventStatus.SUCCEEDED.statusName().equals(parent.getStatus().getValue())) {
                TSE.trace("found illegal status severity combination");
            }
        }
        if ((related = this.getRelatedHistory(me, parent)) != null) {
            thisHistory.AddDetail((BaseHistoryDetail)related);
        }
        historyList.add(taskRecord.getTaskId().getID(), thisHistory);
        return me;
    }

    private SeverityEnumProp pickMax(SeverityEnumProp first, SeverityEnumProp second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int comparison = ObjectModelUtil.compareSeverity((SeverityEnum)first.getValue(), (SeverityEnum)second.getValue());
        if (comparison <= 0) {
            return second;
        }
        return first;
    }

    private HistoryDetailRelatedHistory getRelatedHistory(History parent, History relatedTo) {
        if (relatedTo == null) {
            return null;
        }
        HistoryDetailRelatedHistory related = new HistoryDetailRelatedHistory();
        Date detailTime = new Date();
        DateTimeProp detailTimeProp = new DateTimeProp();
        detailTimeProp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)detailTime));
        related.setDetailTime(detailTimeProp);
        History pHistory = new History();
        StringProp searchPath = this.getDetailPath(parent);
        pHistory.setSearchPath(searchPath);
        BaseClass[] baseClassArray = new BaseClass[]{pHistory};
        BaseClassArrayProp bcap = new BaseClassArrayProp();
        bcap.setValue(baseClassArray);
        related.setRelated(bcap);
        related.setSearchPath(this.getDetailPath(relatedTo));
        return related;
    }

    private void addChildSteps(HistoryListHelper historyList, TaskRecord taskRecord, History parent, SeverityEnumProp rootMax) throws TaskPersistLayerException, RecordableException, EMFSecurityException, SDKClientException {
        TaskStateTable.StepInfo[] childSteps = TaskStateTable.getChildren((TaskID)taskRecord.getTaskId(), null);
        for (int i = 0; childSteps != null && i < childSteps.length; ++i) {
            TaskRecord childRecord = NCTaskQueueTable.getInstance().find(childSteps[i].taskId, false);
            if (childRecord.getRestartId() != null && childRecord.getRestartId().equals((Object)TaskRecord.RESTART_IGNORE_HISTORY_WRITE) || TaskStatus.PENDING.getId() == childSteps[i].status && 30100 == childSteps[i].seq) continue;
            History me = this.addInfoToList(historyList, childRecord, parent, rootMax);
            this.addChildSteps(historyList, childRecord, me, rootMax);
        }
    }

    private StringProp getDetailPath(History history) {
        if (history.getStoreID() != null && history.getStoreID().getValue() != null) {
            return ObjectModelUtil.makeStringProp((String)ObjectModelUtil.getSearchPath((Guid)history.getStoreID().getValue()).get_value());
        }
        StringProp prop = new StringProp();
        String suffix = "/history[@eventID='" + history.getEventID().getValue() + "']";
        String parentPath = history.getSearchPath().getValue();
        if (parentPath.endsWith(suffix)) {
            prop.setValue(parentPath);
        } else {
            prop.setValue(parentPath + suffix);
        }
        return prop;
    }

    private void checkWrite(String serviceName) {
        try {
            Boolean bDefer;
            String sDefer = CRNProperties.getInstance().getProperty("defer.history.creation");
            Boolean bl = bDefer = sDefer == null ? Boolean.TRUE : Boolean.valueOf(sDefer);
            this.writeAsWeGo = bDefer.booleanValue() ? "contentManagerService".equals(serviceName) || "dataMovementService".equals(serviceName) || "indexUpdateService".equals(serviceName) : true;
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
    }
}

