/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandler;
import com.cognos.jsmcommon.tasks.thread.CommonTimerTasks;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.tse.HistoryConsistencyThread;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TimerTask;

public class TaskStateConsistencyCheckThread {
    private boolean m_done = false;
    private boolean m_exit = false;
    private static long DATE_ENTERED_TIME_GAP = 0L;
    String listOfHungTasksSQL = "SELECT TASK_ID, status, ACTUAL_COMPLETION_TIME, ACTUAL_EXECUTION_TIME, SDS_INSTANCE_ID FROM NC_TASK_QUEUE where STATUS = 11 and TASK_ID in (SELECT TASK_ID FROM NC_TSE_STATE_MAP where STATUS = 10 and EXECUTING = 0 ) and SERVICE_NAME = 'batchReportService' ";
    String cleanHungStatus = "UPDATE NC_TASK_QUEUE set status = 10, ACTUAL_COMPLETION_TIME = 0, ACTUAL_EXECUTION_TIME = 0, SDS_INSTANCE_ID = null where STATUS = 11 and TASK_ID in (SELECT TASK_ID FROM NC_TSE_STATE_MAP where STATUS = 10 and EXECUTING = 0 ) and SERVICE_NAME = 'batchReportService' and DATE_ENTERED < ? ";
    private static final String REQUEST_OPERATION = "TSE.TaskStateConsistencyCheckThread.run";
    private static final int MILLIS_IN_SECOND = 1000;
    private int m_minThreshold = 0;
    private static ThreadLocal<Boolean> initHolder = new ThreadLocal();
    private static TaskStateConsistencyCheckThread instance;
    private int m_PollInterval = 3600;
    private boolean m_isActive = CRNProperties.getProperty((String)"event.state.check.active", (boolean)true);
    private TimerTask m_timer_task = null;

    private TaskStateConsistencyCheckThread() {
        TSE.trace("TSE.TaskStateConsistencyCheckThread isActive = " + this.m_isActive);
        try {
            String pollInterval = CRNProperties.getInstance().getProperty("event.state.check.interval");
            if (pollInterval != null && !"".equals(pollInterval)) {
                int newPollInterval;
                this.m_PollInterval = newPollInterval = Integer.valueOf(pollInterval).intValue();
            }
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_TASK_CONSISTENCY_CHECK_FAILED, new Object[]{e.getLocalizedMessage()});
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_TASK_CONSISTENCY_CHECK_FAILED, new Object[]{e.getLocalizedMessage()});
            TSE.trace("TSE.TaskStateConsistencyCheckThread Error reading poll interval:  " + e.getMessage());
            e.printStackTrace();
        }
        TSE.trace("TSE.TaskStateConsistencyCheckThread polling interval = " + this.m_PollInterval);
    }

    private void setTimeParamForUpdateScript() {
        long now = System.currentTimeMillis();
        int userDefinedConst = CRNProperties.getProperty((String)"autorecover.hungtasks.threshold", (int)10);
        TSE.trace("TSE.TaskStateConsistencyCheckThread : autorecover.hungtasks.threshold=" + userDefinedConst);
        long maxDelay = userDefinedConst * 60 * 1000;
        DATE_ENTERED_TIME_GAP = now - maxDelay;
    }

    public void run() {
        this.m_isActive = CRNProperties.getProperty((String)"event.state.check.active", (boolean)true);
        this.m_PollInterval = CRNProperties.getProperty((String)"event.state.check.interval", (int)this.m_PollInterval);
        this.m_minThreshold = CRNProperties.getProperty((String)"event.state.check.threshold", (int)0);
        this.m_done = false;
        String readyStatus = "TSE.TaskStateConsistencyCheckThread is enabled:" + this.m_isActive;
        TSE.trace(readyStatus);
        TaskStateConsistencyCheckThread.logtoCogserver(readyStatus, null);
        this.setTimeParamForUpdateScript();
        ThreadProperties.setProperty((String)"componentID", (String)"MS");
        ThreadProperties.setProperty((String)"requestOperation", (String)REQUEST_OPERATION);
        TSE.trace("TSE.TaskStateConsistencyCheckThread run()");
        while (!this.m_exit && !this.m_done) {
            if (this.m_isActive) {
                try {
                    if (this.getConsistencyCandidates() >= this.m_minThreshold) {
                        this.fixConflictedItems();
                    }
                }
                catch (Throwable t) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_TASK_CONSISTENCY_CHECK_FAILED, new Object[0]);
                    TSE.trace("TSE.TaskStateConsistencyCheckThread Fatal Error " + t.getMessage());
                    t.printStackTrace();
                }
            }
            long delay = this.m_PollInterval;
            try {
                CommonTimerTasks.getInstance().schedule(this.resetTimerTask(), delay * 1000L);
                this.m_done = true;
            }
            catch (IllegalStateException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_TASK_CONSISTENCY_CHECK_FAILED, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_TASK_CONSISTENCY_CHECK_FAILED, new Object[]{"Error scheduling TaskStateConsistencyCheckThread" + e.getMessage()});
                e.printStackTrace();
            }
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time * 1000L);
        }
        catch (InterruptedException e) {
            this.stop();
        }
    }

    public void start() {
        this.m_PollInterval = CRNProperties.getProperty((String)"event.state.check.interval", (int)this.m_PollInterval);
        this.m_exit = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                TaskStateConsistencyCheckThread.getInstance().sleep(30L);
                TaskStateConsistencyCheckThread.getInstance().run();
            }
        }).start();
    }

    public void stop() {
        this.m_exit = true;
        if (this.m_timer_task != null) {
            this.m_timer_task.cancel();
        }
        this.m_timer_task = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getConsistencyCandidates() throws TSEException, TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute() throws TaskPersistLayerException {
                int count;
                ResultSet rs;
                PreparedStatement ps;
                block5: {
                    ps = null;
                    rs = null;
                    count = 0;
                    try {
                        ps = TaskPersistLayer.prepareStatement((String)TaskStateConsistencyCheckThread.this.listOfHungTasksSQL.toString());
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            String taskId = rs.getString(1);
                            String status = rs.getString(2);
                            String completionTime = rs.getString(3);
                            String execTime = rs.getString(4);
                            String sdsInstId = rs.getString(5);
                            TaskStateConsistencyCheckThread.logtoCogserver("TSE.TaskStateConsistencyCheckThread conflicted tasks found- TaskId:" + taskId + ", status:" + status + ", completionTime:" + completionTime + ", execTime:" + execTime + ", sdsInstId:" + sdsInstId, null);
                            ++count;
                        }
                        if (count <= 0) break block5;
                        TaskStateConsistencyCheckThread.logtoCogserver("TSE.TaskStateConsistencyCheckThread total conflicted tasks found:" + count, null);
                    }
                    catch (Exception e) {
                        try {
                            TSE.getRTLogger().log(SDSLevel.WARN, MonitorI18NCode.MSG_TSE_GENERAL_ERROR, new Object[]{"TSE.TaskStateConsistencyCheckThread " + e.getMessage()});
                        }
                        catch (Throwable throwable) {
                            TaskPersistLayer.closeStatement(ps, rs);
                            throw throwable;
                        }
                        TaskPersistLayer.closeStatement((PreparedStatement)ps, (ResultSet)rs);
                    }
                }
                TaskPersistLayer.closeStatement((PreparedStatement)ps, (ResultSet)rs);
                return count;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TSE.TaskStateConsistencyCheckThread.logConflictedItems");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(MonitorCategory.RUNTIME, true);
            int n = (Integer)handler.execute(sqlExecute);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fixConflictedItems() throws TaskPersistLayerException {
        SQLExecute sqlExecute = new SQLExecute(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute() throws TaskPersistLayerException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                int count = 0;
                try {
                    ps = TaskPersistLayer.prepareStatement((String)TaskStateConsistencyCheckThread.this.cleanHungStatus.toString());
                    ps.setLong(1, DATE_ENTERED_TIME_GAP);
                    String dbg = "TSE.TaskStateConsistencyCheckThread.fixConflictedItems " + TaskStateConsistencyCheckThread.this.cleanHungStatus.toString() + DATE_ENTERED_TIME_GAP;
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug(dbg);
                    TaskStateConsistencyCheckThread.logtoCogserver(dbg, null);
                    count = ps.executeUpdate();
                }
                catch (Exception e) {
                    try {
                        TSE.getRTLogger().log(SDSLevel.WARN, MonitorI18NCode.MSG_TSE_GENERAL_ERROR, new Object[]{e.getMessage()});
                    }
                    catch (Throwable throwable) {
                        TaskPersistLayer.closeStatement(ps, rs);
                        throw throwable;
                    }
                    TaskPersistLayer.closeStatement((PreparedStatement)ps, rs);
                }
                TaskPersistLayer.closeStatement((PreparedStatement)ps, rs);
                if (count > 0) {
                    TaskStateConsistencyCheckThread.logtoCogserver("TSE.TaskStateConsistencyCheckThread.fixConflictedItems total fixed tasks:" + count, null);
                }
                return count;
            }
        };
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TSE.TaskStateConsistencyCheckThread.fixConflictedItems");
        try {
            SQLExecuteHandler handler = new SQLExecuteHandler(MonitorCategory.RUNTIME, true);
            int n = (Integer)handler.execute(sqlExecute);
            return n;
        }
        finally {
            zipiTimer.stop();
        }
    }

    private TimerTask resetTimerTask() {
        if (this.m_timer_task != null) {
            this.m_timer_task.cancel();
            this.m_timer_task = null;
        }
        return this.getTimerTask();
    }

    private TimerTask getTimerTask() {
        if (this.m_timer_task == null) {
            this.m_timer_task = new TimerTask(){

                @Override
                public void run() {
                    TaskStateConsistencyCheckThread.getInstance().run();
                }
            };
        }
        return this.m_timer_task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskStateConsistencyCheckThread getInstance() {
        if (initHolder.get() != null) return instance;
        Class<HistoryConsistencyThread> clazz = HistoryConsistencyThread.class;
        synchronized (HistoryConsistencyThread.class) {
            if (instance == null) {
                instance = new TaskStateConsistencyCheckThread();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            initHolder.set(Boolean.TRUE);
            return instance;
        }
    }

    private static void logtoCogserver(String msg, Exception e) {
        try {
            AuditProperties props = new AuditProperties("Run", msg, "", "Run");
            if (e != null) {
                props = new AuditProperties("Run", msg, e.getMessage(), "Run");
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, (Map)props);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

