/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.tse.FinalHistoryQueue;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.WriteFinalHistoryObject;
import com.cognos.monitor.tse.WriteFinalHistoryService;
import com.cognos.monitor.tse.WriteFinalHistoryTask;
import com.ibm.cognos.pogo.zipi.ZipiTimer;

public class WriteFinalHistoryParentWorker
implements Runnable {
    private static final String REQUEST_OPERATION = "WriteFinalHistoryParentWorker.run";
    private FinalHistoryQueue parentFinalHistoryQueue = null;
    private FinalHistoryQueue childFinalHistoryQueue = null;

    public WriteFinalHistoryParentWorker(FinalHistoryQueue parentFinalHistoryQueue, FinalHistoryQueue childFinalHistoryQueue) {
        this.parentFinalHistoryQueue = parentFinalHistoryQueue;
        this.childFinalHistoryQueue = childFinalHistoryQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        ThreadProperties.setProperty((String)"componentID", (String)"MS");
        ThreadProperties.setProperty((String)"requestOperation", (String)REQUEST_OPERATION);
        WriteFinalHistoryObject wfho = null;
        while (WriteFinalHistoryService.getInstance().getStopThreads() == 0 || WriteFinalHistoryService.getInstance().getStopThreads() == 1 && !this.parentFinalHistoryQueue.isEmpty()) {
            PerfLog perf = null;
            try {
                FinalHistoryQueue finalHistoryQueue = this.parentFinalHistoryQueue;
                synchronized (finalHistoryQueue) {
                    wfho = this.parentFinalHistoryQueue.get();
                    if (wfho == null) {
                        this.parentFinalHistoryQueue.wait(60000L);
                    }
                    if (wfho == null || wfho.getTaskId() == null) continue;
                }
                perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(this.getClass(), SDSLevel.ERROR, "BEGIN", wfho.getTaskId().getID());
                ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"JSM Parent Task History");
                try {
                    this.processTask(wfho);
                }
                finally {
                    zipiTimer.stopAndClear();
                }
                this.childFinalHistoryQueue.put(wfho);
            }
            catch (InterruptedException zipiTimer) {
            }
            catch (Exception ex) {
                TSE.trace(this, "TSE_WFH ERROR: There was an error writing final history. EXCEPTION: " + ex);
            }
            finally {
                if (perf == null) continue;
                perf.stop();
            }
        }
    }

    private void processTask(WriteFinalHistoryObject wfho) throws TSEException {
        try {
            WriteFinalHistoryTask wfht = new WriteFinalHistoryTask();
            wfht.writeFinalHistoryForRootTask(wfho);
        }
        catch (TSEException ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error Occurred while Writing Final History for task [" + wfho.getTaskId() + "]. TSEException: " + ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing the final history for task with id [" + wfho.getTaskId() + "]. EXCEPTION:" + ex.getMessage());
            throw new TSEException(ex);
        }
    }
}

