/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.monitor.tse.FinalHistoryQueue;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.WriteFinalHistoryChildWorker;
import com.cognos.monitor.tse.WriteFinalHistoryObject;
import com.cognos.monitor.tse.WriteFinalHistoryParentWorker;
import java.util.ArrayList;

public class WriteFinalHistoryService {
    private static final int NUMBER_OF_PARENT_WORKER_THREADS = WriteFinalHistoryService.getAdvancedFinalHistoryParentThreads();
    private static final int NUMBER_OF_CHILD_WORKER_THREADS = WriteFinalHistoryService.getAdvancedFinalHistoryChildThreads();
    private static WriteFinalHistoryService writeFinalHistoryService = new WriteFinalHistoryService();
    private static ArrayList workerThreadsList = new ArrayList();
    private static boolean workerThreadsStarted = false;
    private static int stopThreads = 0;
    public static final boolean useWriteFinalHistoryService = WriteFinalHistoryService.getAdvancedFinalHistoryWrite();
    public static final boolean WRITE_HISTORIES_AS_WE_GO = false;

    private WriteFinalHistoryService() {
    }

    public static WriteFinalHistoryService getInstance() {
        return writeFinalHistoryService;
    }

    private synchronized void startWorkerThreads() throws TSEException {
        WriteFinalHistoryParentWorker wfhpw = null;
        WriteFinalHistoryChildWorker wfhcw = null;
        FinalHistoryQueue parentFinalHistoryQueue = FinalHistoryQueue.getParentQueue();
        FinalHistoryQueue childFinalHistoryQueue = FinalHistoryQueue.getChildQueue();
        String workerThreadName = null;
        try {
            Thread newThread;
            int i;
            for (i = 0; i < NUMBER_OF_PARENT_WORKER_THREADS; ++i) {
                workerThreadName = "WriteFinalHistoryParentWorker-" + (i + 1);
                wfhpw = new WriteFinalHistoryParentWorker(parentFinalHistoryQueue, childFinalHistoryQueue);
                newThread = new Thread((Runnable)wfhpw, workerThreadName);
                newThread.setDaemon(true);
                newThread.start();
                workerThreadsList.add(newThread);
                TSE.trace(this, "TSE_WFH: Started Final History Parent Worker Thread: " + workerThreadName);
            }
            for (i = 0; i < NUMBER_OF_CHILD_WORKER_THREADS; ++i) {
                workerThreadName = "WriteFinalHistoryChildWorker-" + (i + 1);
                wfhcw = new WriteFinalHistoryChildWorker(childFinalHistoryQueue);
                newThread = new Thread((Runnable)wfhcw, workerThreadName);
                newThread.setDaemon(true);
                newThread.start();
                workerThreadsList.add(newThread);
                TSE.trace(this, "TSE_WFH: Started Final History Child Worker Thread: " + workerThreadName);
            }
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: There was an error starting the Final History Worker Threads. Fatal Error. EXCEPTION: " + ex);
            throw new TSEException(ex);
        }
    }

    public synchronized void writeFinalHistory(WriteFinalHistoryObject wfho) throws TSEException {
        try {
            if (wfho == null || wfho.getTaskId() == null) {
                TSE.trace(this, "TSE_WFH ERROR: There was an ERROR writing the final history. The TaskID is null.");
                throw new TSEException("There was an ERROR writing the final history. The TaskID is null.");
            }
            if (stopThreads != 0) {
                TSE.trace(this, "TSE_WFH ERROR: Final History Service Shutting down, cannot write final history for task : [" + wfho.getTaskId() + "]");
                throw new TSEException("Final History Service shutting down");
            }
            FinalHistoryQueue fhq = FinalHistoryQueue.getParentQueue();
            fhq.put(wfho);
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: There was an error writing the final history. Exception: " + ex);
            throw new TSEException(ex);
        }
    }

    public synchronized void start() {
        try {
            if (!workerThreadsStarted && stopThreads == 0) {
                this.startWorkerThreads();
                workerThreadsStarted = true;
            }
        }
        catch (TSEException ex) {
            TSE.trace(this, "TSE_WFH ERROR: There was an error starting the Final History Worker Threads. Fatal Error. TSEEXCEPTION: " + ex);
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: There was an error starting the Final History Worker Threads. Fatal Error. TSEEXCEPTION: " + ex);
        }
    }

    public synchronized void stop(boolean immediately) {
        Thread workerThread = null;
        try {
            stopThreads = immediately ? 2 : 1;
            if (workerThreadsList != null) {
                for (int i = 0; i < workerThreadsList.size(); ++i) {
                    workerThread = (Thread)workerThreadsList.get(i);
                    if (!workerThread.isAlive()) continue;
                    TSE.trace(this, "TSE_WFH: Attempting to stop the Final History Worker Thread: " + workerThread.getName());
                    workerThread.interrupt();
                }
            }
            TSE.trace(this, "TSE_WFH: All Final History Worker Threads have been marked for STOP");
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: There was an error stopping the Final History Worker Threads. EXCEPTION: " + ex);
        }
    }

    public void testReset(boolean immediately) {
        Thread workerThread = null;
        try {
            this.stop(immediately);
            if (workerThreadsList != null) {
                for (int i = 0; i < workerThreadsList.size(); ++i) {
                    workerThread = (Thread)workerThreadsList.get(i);
                    if (!workerThread.isAlive()) continue;
                    try {
                        workerThread.join();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            workerThreadsList = new ArrayList();
            stopThreads = 0;
            workerThreadsStarted = false;
        }
        catch (Exception ex) {
            TSE.trace("TSE_WFH ERROR: Error while resetting WriteFinalHistoryService ");
        }
    }

    public synchronized int getStopThreads() {
        return stopThreads;
    }

    private static boolean getAdvancedFinalHistoryWrite() {
        boolean flag = true;
        try {
            String advancedFinalHistoryWrite = CRNProperties.getInstance().getProperty("advanced.history.write");
            if (advancedFinalHistoryWrite != null && advancedFinalHistoryWrite.trim().equalsIgnoreCase("FALSE")) {
                flag = false;
            }
        }
        catch (Exception ex) {
            TSE.trace("TSE_WFH ERROR: Unable to load the value of the property ADVANCED_FINAL_HISTORY_WRITE");
        }
        return flag;
    }

    private static int getAdvancedFinalHistoryParentThreads() {
        int numberOfThreads = 2;
        try {
            String strNumberOfThreads = CRNProperties.getInstance().getProperty("advanced.parent.history.threads");
            if (strNumberOfThreads != null && !strNumberOfThreads.trim().equalsIgnoreCase("")) {
                numberOfThreads = Integer.parseInt(strNumberOfThreads);
            }
            if (numberOfThreads < 1) {
                numberOfThreads = 2;
            }
        }
        catch (Exception ex) {
            TSE.trace("TSE_WFH ERROR: Unable to load the value of the property ADVANCED_PARENT_FINAL_HISTORY_THREADS");
        }
        return numberOfThreads;
    }

    private static int getAdvancedFinalHistoryChildThreads() {
        int numberOfThreads = 5;
        try {
            String strNumberOfThreads = CRNProperties.getInstance().getProperty("advanced.child.history.threads");
            if (strNumberOfThreads != null && !strNumberOfThreads.trim().equalsIgnoreCase("")) {
                numberOfThreads = Integer.parseInt(strNumberOfThreads);
            }
            if (numberOfThreads < 1) {
                numberOfThreads = 5;
            }
        }
        catch (Exception ex) {
            TSE.trace("TSE_WFH ERROR: Unable to load the value of the property ADVANCED_CHILD_FINAL_HISTORY_THREADS");
        }
        return numberOfThreads;
    }
}

