/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.AgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.JobDefinition;
import com.cognos.developer.schemas.bibus._3.MonitorOptionBoolean;
import com.cognos.developer.schemas.bibus._3.MonitorOptionEnum;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.impl.state.HistoryRecord;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.cognos.monitor.tse.TaskRunHistoryWriter;
import com.cognos.monitor.tse.WriteFinalHistoryObject;
import com.cognos.monitor.tse.commands.LogoffCmd;
import com.cognos.monitor.util.HistoryHelper;
import com.cognos.sds.event.IEventId;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;

public class WriteFinalHistoryTask {
    public void writeFinalHistory(TaskID taskId) throws TSEException, TaskPersistLayerException {
        TaskRunContext taskRunContext = null;
        try {
            if (taskId != null) {
                taskRunContext = TaskRunContextFactory.createTaskRunContext(taskId);
                String[] taskIDs = taskRunContext.getHistoryWriter().writeFinalHistory();
                TaskHistoryDetailRecord.deleteAll((String[])taskIDs);
                this.purgeTasks(taskRunContext);
            } else {
                TSE.trace(this, "TSE_WFH ERROR: TaskID is null. TaskID should not be null, cannot write final history.");
            }
        }
        catch (TSEException ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error Occurred while Writing Final History for task [" + taskId + "]. TSEException: " + ex.getMessage());
            throw ex;
        }
        catch (TaskPersistLayerException ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error Occurred while Writing Final History for task [" + taskId + "]. TaskPersistLayerException: " + ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error Occurred while Writing Final History for task [" + taskId + "]. Exception: " + ex.getMessage());
            throw new TSEException(ex);
        }
        finally {
            if (taskRunContext.logOffRequired()) {
                LogoffCmd logoffCmd = new LogoffCmd(taskRunContext);
                TSEStateMapProcessor.getInstance().queueCmd(logoffCmd);
            }
        }
    }

    public void writeFinalHistoryForRootTask(WriteFinalHistoryObject wfho) throws TSEException {
        TaskRunContext taskRunContext = null;
        TaskRunHistoryWriter taskRunHistoryWriter = null;
        IEventId eventId = null;
        try {
            if (wfho != null && wfho.getTaskId() != null) {
                HistoryRecord historyRecord;
                taskRunContext = TaskRunContextFactory.createTaskRunContext(wfho.getTaskId());
                taskRunHistoryWriter = (TaskRunHistoryWriter)taskRunContext.getHistoryWriter();
                taskRunHistoryWriter.writeFinalHistoryForRootTask();
                if (wfho.getHistoryWriteAfterFailover() && (historyRecord = HistoryHelper.getHistoryRecord(eventId = TSE.getInstance().getEventId(wfho.getTaskId()))) != null) {
                    historyRecord.addErrorDetail(MonitorI18NCode.MSG_MS_HISTORY_RECOVERED, new Object[0]);
                }
            } else {
                TSE.trace(this, "TSE_WFH ERROR: TaskID is null. TaskID should not be null, cannot write (root) final history.");
            }
        }
        catch (TSEException ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error Occurred while Writing Final History for (root) task [" + wfho.getTaskId() + "]. TSEException: " + ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error Occurred while Writing Final History for (root) task [" + wfho.getTaskId() + "]. Exception: " + ex.getMessage());
            throw new TSEException(ex);
        }
    }

    public void writeFinalHistoryForChildTasks(WriteFinalHistoryObject wfho) throws TSEException, TaskPersistLayerException {
        TaskRunContext taskRunContext = null;
        TaskRunHistoryWriter taskRunHistoryWriter = null;
        IEventId eventId = null;
        HistoryRecord historyRecord = null;
        String strWriteChildHistoriesOption = null;
        I18NCode messageCode = null;
        int writeChildHistories = 0;
        try {
            if (wfho != null && wfho.getTaskId() != null) {
                taskRunContext = TaskRunContextFactory.createTaskRunContext(wfho.getTaskId());
                strWriteChildHistoriesOption = this.getWriteHistoryOption(taskRunContext);
                writeChildHistories = this.checkChildHistoryWrite(wfho.getWriteChildHistories(), wfho.getWriteChildHistoriesDuringFailover(), strWriteChildHistoriesOption, wfho.getHistoryWriteAfterFailover());
                if (writeChildHistories == 0 || taskRunContext.getStatus().equals((Object)TaskStatus.FAILED)) {
                    if (TaskStateTable.hasChildTasks((TaskID)wfho.getTaskId())) {
                        taskRunHistoryWriter = (TaskRunHistoryWriter)taskRunContext.getHistoryWriter();
                        taskRunHistoryWriter.writeFinalHistoryForChildTasks();
                    }
                } else if (TaskStateTable.hasChildTasks((TaskID)wfho.getTaskId())) {
                    TaskRecord tr = taskRunContext.getTaskRecord();
                    BiBusRunSpec spec = (BiBusRunSpec)tr.getRunSpec();
                    BiBusHeader header = spec.header;
                    eventId = TSE.getInstance().getEventId(wfho.getTaskId());
                    historyRecord = HistoryHelper.getHistoryRecord(eventId, header);
                    if (writeChildHistories == 1) {
                        messageCode = MonitorI18NCode.MSG_MS_CHILD_HISTORY_WRITE_DISABLED;
                    } else if (writeChildHistories == 2) {
                        messageCode = MonitorI18NCode.MSG_MS_CHILD_HISTORY_WRITE_DURING_FAILOVER_DISABLED;
                    } else if (writeChildHistories == 3) {
                        messageCode = MonitorI18NCode.MSG_MS_WRITE_COMPLETE_HISTORY_OPTION_DISABLED;
                    }
                    if (historyRecord != null) {
                        historyRecord.addInfoDetail(messageCode, new Object[0]);
                    }
                }
                if (taskRunContext.logOffRequired()) {
                    LogoffCmd logoffCmd = new LogoffCmd(taskRunContext);
                    TSEStateMapProcessor.getInstance().queueCmd(logoffCmd);
                }
                this.purgeTasks(taskRunContext);
            } else {
                TSE.trace(this, "TSE_WFH ERROR: TaskID is null. TaskID should not be null, cannot write (child) final history.");
            }
        }
        catch (TSEException ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error Occurred while Writing Final History for (child) task [" + wfho.getTaskId() + "]. TSEException: " + ex.getMessage());
            throw ex;
        }
        catch (TaskPersistLayerException ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error Occurred while Writing Final History for (child) task [" + wfho.getTaskId() + "]. TaskPersistLayerException: " + ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error Occurred while Writing Final History for (child) task [" + wfho.getTaskId() + "]. Exception: " + ex.getMessage());
            throw new TSEException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeTasks(final TaskRunContext taskRunContext) throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"WriteFinalHistoryTask.purgeTasks");
        try {
            TaskStatus taskStatus = null;
            final TaskStateTable.StepInfo[] steps = TaskStateTable.getChildren((TaskID)taskRunContext.getTaskId(), null);
            try {
                taskStatus = taskRunContext.getStatus();
                if (TaskStatus.checkPurge((TaskStatus)taskStatus)) {
                    TaskPersistLayer.getInstance().deleteRecordsIncludingChildren(new TaskID[]{taskRunContext.getTaskId()});
                } else {
                    SQLExecute sqlExec = new SQLExecute(){

                        public Object execute() throws TaskPersistLayerException {
                            WriteFinalHistoryTask.this.clearSDSInstanceIdOfChildren(steps);
                            NCTaskQueueTable.getInstance().clearSdsInstance(taskRunContext.getTaskId());
                            ArrayList<String> taskIDs = new ArrayList<String>();
                            for (int i = 0; i < steps.length; ++i) {
                                taskIDs.add(steps[i].taskId.getID());
                            }
                            taskIDs.add(taskRunContext.getTaskId().getID());
                            TaskHistoryDetailRecord.deleteAll((String[])taskIDs.toArray(new String[0]));
                            return null;
                        }
                    };
                    SQLTransactionExecuteHandler handler = new SQLTransactionExecuteHandler(MonitorCategory.RUNTIME);
                    handler.execute(sqlExec);
                }
            }
            catch (Exception e) {
                TaskPersistLayer.rollbackTransaction();
                TSE.trace(this, "TSE_WFH ERROR: Error Occurred in Purging Tasks while Writing Final History. Exception: " + e.getMessage());
                throw new TaskPersistLayerException(e);
            }
        }
        finally {
            zipiTimer.stop();
        }
    }

    private void clearSDSInstanceIdOfChildren(TaskStateTable.StepInfo[] steps) throws TaskPersistLayerException {
        try {
            for (int i = 0; i < steps.length; ++i) {
                TaskStateTable.StepInfo[] childSteps = TaskStateTable.getChildren((TaskID)steps[i].taskId, null);
                if (childSteps != null && childSteps.length > 0) {
                    this.clearSDSInstanceIdOfChildren(childSteps);
                }
                NCTaskQueueTable.getInstance().clearSdsInstance(steps[i].taskId);
            }
        }
        catch (TaskPersistLayerException ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error Occurred in clearing the SDS instance id for children. TaskPersistLayerException: " + ex.getMessage());
            throw ex;
        }
    }

    public int checkChildHistoryWrite(String advWriteChildHistories, String advWriteChildHistoriesDuringFailover, String runtimeWriteChildHistories, boolean isHistoryWriteAfterFailover) {
        int writeChildHistory = 0;
        try {
            advWriteChildHistories = this.validateAndCleanUp(advWriteChildHistories);
            advWriteChildHistoriesDuringFailover = this.validateAndCleanUp(advWriteChildHistoriesDuringFailover);
            runtimeWriteChildHistories = this.validateAndCleanUp(runtimeWriteChildHistories);
            if (advWriteChildHistories.equals("")) {
                if (isHistoryWriteAfterFailover) {
                    if (advWriteChildHistoriesDuringFailover.equals("")) {
                        writeChildHistory = runtimeWriteChildHistories.equalsIgnoreCase("FALSE") ? 3 : 0;
                    } else if (advWriteChildHistoriesDuringFailover.equalsIgnoreCase("TRUE")) {
                        writeChildHistory = 0;
                    } else if (advWriteChildHistoriesDuringFailover.equalsIgnoreCase("FALSE")) {
                        writeChildHistory = 2;
                    }
                } else {
                    writeChildHistory = runtimeWriteChildHistories.equalsIgnoreCase("FALSE") ? 3 : 0;
                }
            } else if (advWriteChildHistories.equalsIgnoreCase("TRUE")) {
                if (isHistoryWriteAfterFailover) {
                    if (advWriteChildHistoriesDuringFailover.equals("")) {
                        writeChildHistory = 0;
                    } else if (advWriteChildHistoriesDuringFailover.equalsIgnoreCase("TRUE")) {
                        writeChildHistory = 0;
                    } else if (advWriteChildHistoriesDuringFailover.equalsIgnoreCase("FALSE")) {
                        writeChildHistory = 2;
                    }
                } else {
                    writeChildHistory = 0;
                }
            } else if (advWriteChildHistories.equalsIgnoreCase("FALSE")) {
                writeChildHistory = 1;
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, (Throwable)ex);
        }
        return writeChildHistory;
    }

    private String validateAndCleanUp(String param) {
        String result = "";
        try {
            if (param != null && (param.trim().equalsIgnoreCase("TRUE") || param.trim().equalsIgnoreCase("FALSE"))) {
                result = param.trim();
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, (Throwable)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option[] getSavedOptions(BiBusRunSpec biBusRunSpec) {
        BaseClass[] objs = null;
        ContentManagerServiceClientPort cmPort = null;
        OptionArrayProp optionsArrayProp = null;
        Option[] savedOptions = null;
        JobBiBusHeaders jobBiBusHeaders = null;
        SearchPathMultipleObject sp = null;
        try {
            jobBiBusHeaders = new JobBiBusHeaders(biBusRunSpec.header);
            if (!BiBusUtilities.hasCredentialPath((BiBusHeader)biBusRunSpec.header)) {
                jobBiBusHeaders.setCamCredential(biBusRunSpec.getCredentialPath());
            }
            cmPort = Client.instance().getContentManagerServiceClient(jobBiBusHeaders);
            cmPort.setLogCategory(MonitorCategory.RUNTIME);
            cmPort.signNextRequest("JSM");
            sp = new SearchPathMultipleObject("storeID(\"" + biBusRunSpec.taskStoreID + "\")");
            objs = cmPort.query(sp, new PropEnum[]{PropEnum.searchPath, PropEnum.options, PropEnum.runOptions}, new Sort[0], new QueryOptions());
            if (objs != null && objs.length >= 1) {
                if (objs[0] instanceof JobDefinition) {
                    optionsArrayProp = ((JobDefinition)objs[0]).getOptions();
                    savedOptions = optionsArrayProp.getValue();
                } else if (objs[0] instanceof AgentDefinition) {
                    optionsArrayProp = ((AgentDefinition)objs[0]).getOptions();
                    savedOptions = optionsArrayProp.getValue();
                }
            }
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, (Throwable)e);
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, (Throwable)ex);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return savedOptions;
    }

    private String getWriteHistoryOption(TaskRunContext taskRunContext) {
        BiBusRunSpec biBusRunSpec = null;
        Option[] options = null;
        MonitorOptionBoolean boolOpt = null;
        String writeChildHistoriesOption = "";
        boolean isRuntimeOptionSpecified = false;
        Option[] savedOptions = null;
        try {
            int counter;
            biBusRunSpec = (BiBusRunSpec)taskRunContext.getTaskRecord().getRunSpec();
            options = biBusRunSpec.options;
            if (options != null) {
                for (counter = 0; counter < options.length; ++counter) {
                    if (options[counter] == null || !(options[counter] instanceof MonitorOptionBoolean) || (boolOpt = (MonitorOptionBoolean)options[counter]) == null || !MonitorOptionEnum.writeCompleteHistory.equals((Object)boolOpt.getName())) continue;
                    writeChildHistoriesOption = boolOpt.isValue() ? "TRUE" : "FALSE";
                    isRuntimeOptionSpecified = true;
                }
            }
            if (!isRuntimeOptionSpecified && (savedOptions = this.getSavedOptions(biBusRunSpec)) != null) {
                for (counter = 0; counter < savedOptions.length; ++counter) {
                    if (savedOptions[counter] == null || !(savedOptions[counter] instanceof MonitorOptionBoolean) || (boolOpt = (MonitorOptionBoolean)savedOptions[counter]) == null || !MonitorOptionEnum.writeCompleteHistory.equals((Object)boolOpt.getName())) continue;
                    writeChildHistoriesOption = boolOpt.isValue() ? "TRUE" : "FALSE";
                }
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, (Throwable)ex);
        }
        return writeChildHistoriesOption;
    }
}

