/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.api;

import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.tse.BiBusRequestSpec;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.Headers;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.cognos.monitor.tse.api.TSERequestHandler;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.tse.ChildTasksDocument;
import com.ibm.cognos.internal.tse.CompoundTaskDocument;
import com.ibm.cognos.internal.tse.CreateTSERequestDocument;
import com.ibm.cognos.internal.tse.CreateTSEResponseDocument;
import com.ibm.cognos.internal.tse.OnRunDocument;
import com.ibm.cognos.internal.tse.TaskDocument;
import com.ibm.cognos.internal.tse.TaskGroupDocument;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class CreateTSERequestHandler
extends TSERequestHandler {
    private String rootId;

    public CreateTSERequestHandler(MessageContext mc) {
        super(mc);
    }

    public Element process() throws Exception {
        BIBusEnvelope request_envelope = (BIBusEnvelope)this.mc.getProperty("request.envelope");
        this.header = BiBusUtilities.retrieveHeader((BIBusEnvelope)request_envelope);
        Element body = request_envelope.getBody();
        Element operationElement = (Element)body.selectSingleNode("./*");
        return this.processContent(operationElement.asXML());
    }

    public Element processContent(String operationElementString) throws Exception {
        XmlObject xobj = null;
        try {
            StringReader reader = new StringReader(operationElementString);
            xobj = XmlObject.Factory.parse((Reader)reader);
        }
        catch (Exception reader) {
            // empty catch block
        }
        CreateTSERequestDocument createTSEDocument = (CreateTSERequestDocument)xobj;
        CreateTSERequestDocument.CreateTSERequest createTSERequest = createTSEDocument.getCreateTSERequest();
        SequenceSpec[] rootSequenceSpecs = null;
        if (createTSERequest.isSetTask()) {
            rootSequenceSpecs = this.buildTask(createTSERequest.getTask());
        }
        if (createTSERequest.isSetCompoundTask()) {
            rootSequenceSpecs = this.buildCompoundTask(createTSERequest.getCompoundTask());
        }
        TaskPersistLayer.TaskRecords[] taskRecords = TaskPersistLayer.getInstance().addTasksAndReturnAll(null, rootSequenceSpecs, true, true);
        TaskRecord taskRecord = taskRecords[0].taskRecord;
        TaskStateRecord taskStateRecord = taskRecords[0].taskStateRecord;
        TaskRunContext context = TaskRunContextFactory.createTaskRunContext(taskRecord, taskStateRecord);
        TSE.getInstance().setTaskAsReady(context);
        CreateTSEResponseDocument responseDoc = CreateTSEResponseDocument.Factory.newInstance();
        CreateTSEResponseDocument.CreateTSEResponse response = responseDoc.addNewCreateTSEResponse();
        if (taskRecords != null && taskRecords.length > 0 && taskRecords[0].taskStateRecord.rootID != null) {
            response.setHeirachyID(taskRecords[0].taskStateRecord.rootID.getID());
            this.rootId = taskRecords[0].taskStateRecord.rootID.getID();
        }
        for (int i = 0; i < taskRecords.length; ++i) {
            response.addEventID(taskRecords[i].taskRecord.getTaskId().toEventId());
        }
        String responseText = responseDoc.toString();
        Element result = null;
        if (responseText != null && responseText.length() > 0) {
            try {
                Document document = DocumentHelper.parseText((String)responseText);
                result = (Element)document.getRootElement().detach();
            }
            catch (DocumentException e) {
                throw new Exception("Error parsing result.", e);
            }
        }
        return result;
    }

    private SequenceSpec[] buildTask(TaskDocument.Task task) {
        SequenceSpec sequenceSpec = null;
        OnRunDocument.OnRun onRun = task.getOnRun();
        XmlCursor cursor = onRun.newCursor();
        cursor.toFirstChild();
        QName firstChildName = cursor.getName();
        if (firstChildName.equals(INVOKE_BUS_QNAME)) {
            sequenceSpec = this.buildHTSInvoke(cursor);
        } else if (firstChildName.equals(INVOKE_XTS_QNAME)) {
            sequenceSpec = this.buildXTSInvoke(cursor);
        } else if (firstChildName.equals(INVOKE_JAVA_QNAME)) {
            sequenceSpec = this.buildJAVAInvoke(cursor);
        } else if (firstChildName.equals(INVOKE_MS_QNAME)) {
            sequenceSpec = this.buildMSInvoke(cursor);
        }
        SequenceSpec[] sequenceSpecArray = new SequenceSpec[]{sequenceSpec};
        ChildTasksDocument.ChildTasks childTasks = task.getChildTasks();
        if (childTasks != null) {
            if (childTasks.isSetTask()) {
                sequenceSpecArray[0].setChildren(Arrays.asList(this.buildTask(childTasks.getTask())));
            }
            if (childTasks.isSetCompoundTask()) {
                sequenceSpecArray[0].setChildren(Arrays.asList(this.buildCompoundTask(childTasks.getCompoundTask())));
            }
        }
        return sequenceSpecArray;
    }

    private SequenceSpec[] buildCompoundTask(CompoundTaskDocument.CompoundTask compoundTask) {
        ArrayList<SequenceSpec> sequenceSpecArray = new ArrayList<SequenceSpec>();
        TaskGroupDocument.TaskGroup[] taskGroupArray = compoundTask.getTaskGroupArray();
        for (int i = 0; i < taskGroupArray.length; ++i) {
            TaskGroupDocument.TaskGroup taskGroup = taskGroupArray[i];
            TaskGroupDocument.TaskGroup.Mode.Enum mode = taskGroup.getMode();
            TaskDocument.Task[] taskArray = taskGroup.getTaskArray();
            for (int j = 0; j < taskArray.length; ++j) {
                TaskDocument.Task task = taskArray[j];
                SequenceSpec[] taskElementSpecs = this.buildTask(task);
                SequenceSpec.SeqType sequenceType = SequenceSpec.SEQ_NEW;
                if (j > 0 && ((Object)((Object)mode)).equals((Object)TaskGroupDocument.TaskGroup.Mode.PARALLEL)) {
                    sequenceType = SequenceSpec.SEQ_SAME;
                }
                taskElementSpecs[0].setSeqType(sequenceType);
                sequenceSpecArray.add(taskElementSpecs[0]);
            }
        }
        return sequenceSpecArray.toArray(new SequenceSpec[0]);
    }

    private SequenceSpec buildMSInvoke(XmlCursor cursor) {
        BiBusRunSpec taskRunSpec = new BiBusRunSpec(this.header);
        taskRunSpec.options = null;
        taskRunSpec.parameters = null;
        taskRunSpec.searchPath = null;
        SequenceSpec spec = new SequenceSpec(SequenceSpec.SEQ_NEW, (TaskRunSpec)taskRunSpec);
        return spec;
    }

    private SequenceSpec buildHTSInvoke(XmlCursor cursor) {
        Headers headers = new Headers(this.header);
        String wsAddressingHeader = null;
        try {
            wsAddressingHeader = this.generateWSAddressingHeader(null, null);
            Document doc = DocumentHelper.parseText((String)wsAddressingHeader);
            Node replyToNode = doc.selectSingleNode("//*[local-name()='ReplyTo']");
            ArrayList<Element> elementList = new ArrayList<Element>();
            elementList.add((Element)replyToNode);
            headers.setExtraHeaders(elementList);
        }
        catch (Exception doc) {
            // empty catch block
        }
        BiBusRequestSpec taskRequestSpec = new BiBusRequestSpec(headers);
        taskRequestSpec.soapAction = "http://www.ibm.com/xmlns/prod/cognos/internal/hts/201101";
        taskRequestSpec.serviceName = "HumanTaskService";
        cursor.toFirstChild();
        taskRequestSpec.requestBody = cursor.xmlText();
        SequenceSpec spec = new SequenceSpec(SequenceSpec.SEQ_NEW, (TaskRunSpec)taskRequestSpec);
        spec.setStatus(TaskQueueStatus.QUEUED);
        return spec;
    }

    private String generateWSAddressingHeader(String eventId, String agentEventId) throws PropertiesException {
        String urlString = CRNProperties.getInstance().getProperty("internalDispatcher");
        String responseAction = "http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1";
        String addressingHeader = "<wsa:ReplyTo xmlns:ext='http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext' xmlns:wsa='http://www.w3.org/2005/08/addressing' xmlns:ns1='" + responseAction + "'>" + "<wsa:Address>" + urlString + "</wsa:Address>" + "<wsa:ReferenceParameters>" + "<ns1:eventId>" + eventId + "</ns1:eventId>" + "<ns1:parentEventId>" + agentEventId + "</ns1:parentEventId>" + "</wsa:ReferenceParameters>" + "<wsa:Metadata>" + " <ext:responseAction>" + responseAction + "</ext:responseAction>" + "</wsa:Metadata>" + "</wsa:ReplyTo>";
        return addressingHeader;
    }

    private SequenceSpec buildXTSInvoke(XmlCursor cursor) {
        return null;
    }

    private SequenceSpec buildJAVAInvoke(XmlCursor cursor) {
        return null;
    }

    public String getRootId() {
        return this.rootId;
    }

    public void setRootId(String rootId) {
        this.rootId = rootId;
    }
}

