/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.api;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.internet.InternetHeaders;
import javax.xml.namespace.QName;
import org.dom4j.Element;
import org.dom4j.Namespace;

public abstract class TSERequestHandler {
    protected static final String RESPONSE_NAME = "response";
    public static final Namespace NS_XTS = Namespace.get((String)"xts", (String)"http://www.ibm.com/xmlns/prod/cognos/internal/tse/xts");
    public static final Namespace NS_BUS = Namespace.get((String)"hts", (String)"http://www.ibm.com/xmlns/prod/cognos/internal/tse/bus");
    public static final Namespace NS_JAVA = Namespace.get((String)"java", (String)"http://www.ibm.com/xmlns/prod/cognos/internal/tse/java");
    public static final Namespace NS_MS = Namespace.get((String)"ms", (String)"http://www.ibm.com/xmlns/prod/cognos/internal/tse/ms");
    public static final QName INVOKE_XTS_QNAME = new QName(NS_XTS.getURI(), "invokeXts", NS_XTS.getPrefix());
    public static final QName INVOKE_BUS_QNAME = new QName(NS_BUS.getURI(), "invokeBus", NS_BUS.getPrefix());
    public static final QName INVOKE_JAVA_QNAME = new QName(NS_JAVA.getURI(), "invokeJava", NS_JAVA.getPrefix());
    public static final QName INVOKE_MS_QNAME = new QName(NS_MS.getURI(), "invokeMs", NS_MS.getPrefix());
    protected MessageContext mc;
    protected BiBusHeader header;

    public TSERequestHandler(MessageContext mc) {
        this.mc = mc;
    }

    public void buildResponse(MessageContext mc, Element response) throws Exception {
        if (response == null) {
            throw new Exception("Null response from service.");
        }
        BIBusEnvelope env = BiBusUtilities.getHeadedEnvelope((BiBusHeader)this.header);
        Element bodyResponse = env.getBody();
        bodyResponse.add(response);
        this.setEnvelope(mc, env);
    }

    protected void setEnvelope(MessageContext mc, BIBusEnvelope envelope) {
        try {
            this.outputBIBusEnvelope(envelope, I18NCode.MSG_SOAP_ENVELOPE_RESPONSE);
            this.fillMessageContext(mc, envelope);
            mc.respond(RESPONSE_NAME);
        }
        catch (IOException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_BALTIC_HANDLER_FAILED_TO_RESPOND, (Object[])new String[]{"" + e.getMessage()});
        }
    }

    private void fillMessageContext(MessageContext messageContext, BIBusEnvelope responseEnvelope) {
        Element bigFault = responseEnvelope.getBody().element("Fault");
        Element littleFault = responseEnvelope.getBody().element("fault");
        messageContext.setResponseName(RESPONSE_NAME);
        messageContext.setProperty("response.envelope", (Object)responseEnvelope);
        if (bigFault != null || littleFault != null) {
            messageContext.setProperty("responsestatus_code", (Object)"500");
            messageContext.setProperty("responsestatus_msg", (Object)"Internal Server error");
        } else {
            messageContext.setProperty("response.status_code", (Object)"200");
            messageContext.setProperty("response.status_msg", (Object)"OK");
        }
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Type", "text/xml");
        messageContext.setProperty("responseheaders", (Object)headers);
        messageContext.setProperty("responseboundary", null);
        messageContext.setProperty("responseattachments", null);
    }

    private void outputBIBusEnvelope(BIBusEnvelope envelope, I18NCode code) {
        if (SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT_REQUEST).isLoggingAt(SDSLevel.INFO)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                envelope.writeAsXML((OutputStream)baos);
                String requestString = baos.toString("UTF-8");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT_REQUEST).log(SDSLevel.INFO, code, (Object[])new String[]{requestString});
            }
            catch (IOException ex) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug("Exception logging debug " + ex.getMessage());
            }
        }
    }

    public BiBusHeader getHeader() {
        return this.header;
    }

    public void setHeader(BiBusHeader header) {
        this.header = header;
    }
}

