/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.api;

import com.cognos.jsmcommon.tse.BiBusRequestSpec;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.util.HashList;
import com.ibm.cognos.internal.tse.ChildTasksDocument;
import com.ibm.cognos.internal.tse.CompoundTaskDocument;
import com.ibm.cognos.internal.tse.OnRunDocument;
import com.ibm.cognos.internal.tse.TaskDocument;
import com.ibm.cognos.internal.tse.TaskGroupDocument;
import com.ibm.cognos.internal.tse.ms.InvokeMsDocument;
import com.ibm.xmlns.prod.cognos.internal.tse.bus.InvokeBusDocument;
import com.ibm.xmlns.prod.cognos.internal.tse.bus.TExtensibleElements;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Element;

public class TseResponseDocumentBuilder {
    private TaskStateTable.StepInfo[] steps;
    private TaskDocument.Task task;
    private CompoundTaskDocument.CompoundTask compoundTask;

    public TseResponseDocumentBuilder(TaskStateTable.StepInfo[] steps) throws TaskPersistLayerException {
        this.steps = steps;
        this.process();
    }

    private void process() throws TaskPersistLayerException {
        HashMap<TaskID, StepInfoNode> idMap = new HashMap<TaskID, StepInfoNode>();
        HashList childMap = new HashList();
        ArrayList<StepInfoNode> roots = new ArrayList<StepInfoNode>();
        for (TaskStateTable.StepInfo info : this.steps) {
            StepInfoNode node = new StepInfoNode(info);
            idMap.put(info.taskId, node);
            if (info.parentId == null) {
                roots.add(node);
                continue;
            }
            childMap.put((Object)info.parentId, (Object)info.taskId);
        }
        for (StepInfoNode infoNode : idMap.values()) {
            if (infoNode.info.parentId != null) {
                StepInfoNode parent;
                infoNode.parent = parent = (StepInfoNode)idMap.get(infoNode.info.parentId);
            }
            List childIds = null;
            childIds = childMap.get((Object)infoNode.info.taskId);
            if (childIds == null) continue;
            for (Object childId : childIds) {
                StepInfoNode child = (StepInfoNode)idMap.get((TaskID)childId);
                infoNode.children.add(child);
            }
        }
        if (roots.size() > 1) {
            CompoundTaskDocument compoundTaskDoc = CompoundTaskDocument.Factory.newInstance();
            this.compoundTask = compoundTaskDoc.addNewCompoundTask();
            this.populateCompoundTask(this.compoundTask, roots);
        } else if (roots.size() == 1) {
            this.task = this.makeTask((StepInfoNode)roots.get(0));
        }
    }

    private TaskDocument.Task makeTask(StepInfoNode node) throws TaskPersistLayerException {
        TaskDocument taskDoc = TaskDocument.Factory.newInstance();
        TaskDocument.Task task = taskDoc.addNewTask();
        this.populateTask(task, node);
        return task;
    }

    private CompoundTaskDocument.CompoundTask populateCompoundTask(CompoundTaskDocument.CompoundTask compoundTask, List<StepInfoNode> nodes) throws TaskPersistLayerException {
        HashList sequences = new HashList();
        for (StepInfoNode stepInfoNode : nodes) {
            sequences.put((Object)stepInfoNode.info.seq, (Object)stepInfoNode);
        }
        short seq = 1;
        List stepInfoNodes = sequences.getList((Object)seq);
        ArrayList<StepInfoNode> serialSteps = new ArrayList<StepInfoNode>();
        while (stepInfoNodes != null && stepInfoNodes.size() > 0) {
            if (stepInfoNodes.size() == 1) {
                serialSteps.add((StepInfoNode)stepInfoNodes.get(0));
                continue;
            }
            if (serialSteps.size() > 0) {
                this.makeTaskGroup(compoundTask, serialSteps, true);
                serialSteps.clear();
            }
            this.makeTaskGroup(compoundTask, stepInfoNodes, false);
            seq = (short)(seq + 1);
            stepInfoNodes = sequences.getList((Object)seq);
        }
        return compoundTask;
    }

    private void makeTaskGroup(CompoundTaskDocument.CompoundTask compoundTask, List<StepInfoNode> nodes, boolean serial) throws TaskPersistLayerException {
        TaskGroupDocument.TaskGroup group = compoundTask.addNewTaskGroup();
        group.setMode(serial ? TaskGroupDocument.TaskGroup.Mode.SERIAL : TaskGroupDocument.TaskGroup.Mode.PARALLEL);
        this.addTasks(group, nodes);
    }

    private void addTasks(TaskGroupDocument.TaskGroup taskGroup, List<StepInfoNode> nodes) throws TaskPersistLayerException {
        for (StepInfoNode stepInfoNode : nodes) {
            TaskDocument.Task task = taskGroup.addNewTask();
            this.populateTask(task, stepInfoNode);
        }
    }

    private void populateTask(TaskDocument.Task task, StepInfoNode node) throws TaskPersistLayerException {
        task.setId(node.info.taskId.getID());
        task.setStatus(TaskStatus.fromId((byte)node.info.status).toString());
        TaskRecord record = NCTaskQueueTable.getInstance().find(node.info.taskId, true);
        TaskRunSpec runSpec = record.getRunSpec();
        OnRunDocument onRunDoc = OnRunDocument.Factory.newInstance();
        OnRunDocument.OnRun onRun = onRunDoc.addNewOnRun();
        try {
            if (runSpec instanceof BiBusRunSpec) {
                InvokeMsDocument.InvokeMs invokeMs = onRun.addNewInvokeMs();
            } else if (runSpec instanceof BiBusRequestSpec) {
                InvokeBusDocument.InvokeBus busInvoke = onRun.addNewInvokeBus();
                BiBusRequestSpec requestSpec = (BiBusRequestSpec)runSpec;
                TExtensibleElements body = busInvoke.addNewBody();
                XmlObject bodyObj = XmlObject.Factory.parse((String)requestSpec.requestBody);
                body.set(bodyObj);
                List headers = requestSpec.headers.getExtraHeaders();
                for (Element header : headers) {
                    XmlObject headerObj = XmlObject.Factory.parse((String)header.asXML());
                    TExtensibleElements h = busInvoke.addNewHeaders();
                    h.set(headerObj);
                }
            }
        }
        catch (XmlException e) {
            throw new TaskPersistLayerException((Exception)((Object)e));
        }
        task.setOnRun(onRun);
        CmdSpec[] specs = runSpec.runCommands;
        for (int i = 0; specs != null && i < specs.length; ++i) {
        }
        if (node.children != null && node.children.size() > 0) {
            this.populateChildTasks(task, node.children);
        }
    }

    private void populateChildTasks(TaskDocument.Task task, List<StepInfoNode> nodes) throws TaskPersistLayerException {
        ChildTasksDocument.ChildTasks childTasks = task.addNewChildTasks();
        if (nodes.size() == 1) {
            TaskDocument.Task child = childTasks.addNewTask();
            this.populateTask(child, nodes.get(0));
        } else {
            CompoundTaskDocument.CompoundTask compuntTask = childTasks.addNewCompoundTask();
            this.populateCompoundTask(compuntTask, nodes);
        }
    }

    public TaskDocument.Task getTask() {
        return this.task;
    }

    public CompoundTaskDocument.CompoundTask getCompoundTask() {
        return this.compoundTask;
    }

    private class StepInfoNode {
        TaskStateTable.StepInfo info;
        StepInfoNode parent;
        List<StepInfoNode> children = new ArrayList<StepInfoNode>();

        StepInfoNode(TaskStateTable.StepInfo me) {
            this.info = me;
        }
    }
}

