/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.bclean;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.util.JDBCUtils;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.sql.util.BatchPreparedStatement;
import com.cognos.jsmcommon.tasks.thread.CommonTimerTasks;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.util.Validate;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.bclean.BulkCleanStmtsObjectFactory;
import com.cognos.monitor.tse.bclean.IBulkCleanStmtsObject;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TimerTask;

public class BulkFinishedTaskCleanerThread {
    private boolean m_done = false;
    private boolean m_exit = false;
    private static ThreadLocal<JDBCConnection> trancon = new ThreadLocal();
    private static final String REQUEST_OPERATION = "TSE.BulkFinishedTaskCleanerThread.run";
    private static final int MILLIS_IN_SECOND = 1000;
    private static ThreadLocal<Boolean> initHolder = new ThreadLocal();
    private static BulkFinishedTaskCleanerThread instance;
    private int m_PollInterval = 86400;
    private boolean m_isActive = CRNProperties.getProperty((String)"event.state.check.active", (boolean)true);
    private TimerTask m_timer_task = null;

    private BulkFinishedTaskCleanerThread() {
        TSE.trace("TSE.BulkFinishedTaskCleanerThread isActive = " + this.m_isActive);
        try {
            String pollInterval = CRNProperties.getInstance().getProperty("event.state.check.interval");
            if (pollInterval != null && !"".equals(pollInterval)) {
                int newPollInterval;
                this.m_PollInterval = newPollInterval = Integer.valueOf(pollInterval).intValue();
            }
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_TASK_CONSISTENCY_CHECK_FAILED, new Object[]{e.getLocalizedMessage()});
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_TASK_CONSISTENCY_CHECK_FAILED, new Object[]{e.getLocalizedMessage()});
            TSE.trace("TSE.BulkFinishedTaskCleanerThread Error reading poll interval:  " + e.getMessage());
            e.printStackTrace();
        }
        TSE.trace("TSE.BulkFinishedTaskCleanerThread polling interval = " + this.m_PollInterval);
    }

    public void run() {
        this.m_isActive = CRNProperties.getProperty((String)"event.finished.check.active", (boolean)true);
        this.m_PollInterval = CRNProperties.getProperty((String)"event.finished.check.interval", (int)this.m_PollInterval);
        this.m_done = false;
        String readyStatus = "TSE.BulkFinishedTaskCleanerThread RUN enabled:" + this.m_isActive;
        TSE.trace(readyStatus);
        BulkFinishedTaskCleanerThread.logtoCogserver(readyStatus, null);
        ThreadProperties.setProperty((String)"componentID", (String)"MS");
        ThreadProperties.setProperty((String)"requestOperation", (String)REQUEST_OPERATION);
        TSE.trace("TSE.BulkFinishedTaskCleanerThread run()");
        while (!this.m_exit && !this.m_done) {
            if (this.m_isActive) {
                try {
                    this.deleteOldFinishedRecords();
                }
                catch (Throwable t) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_TASK_CONSISTENCY_CHECK_FAILED, new Object[0]);
                    TSE.trace("TSE.BulkFinishedTaskCleanerThread Fatal Error " + t.getMessage());
                    t.printStackTrace();
                }
            }
            long delay = this.m_PollInterval;
            try {
                CommonTimerTasks.getInstance().schedule(this.resetTimerTask(), delay * 1000L);
                this.m_done = true;
            }
            catch (IllegalStateException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_TASK_CONSISTENCY_CHECK_FAILED, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_TASK_CONSISTENCY_CHECK_FAILED, new Object[]{"Error scheduling BulkFinishedTaskCleanerThread" + e.getMessage()});
                e.printStackTrace();
            }
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time * 1000L);
        }
        catch (InterruptedException e) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int logCandidateDetails(IBulkCleanStmtsObject stmtObj) {
        int result = 0;
        String sql = stmtObj.getCandidateSQL();
        JDBCConnection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            connection = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            statement = connection.createStatement();
            rs = statement.executeQuery(sql);
            StringBuffer sb = new StringBuffer();
            if (rs.next()) {
                ++result;
                String taskId = rs.getString(1);
                sb.append(taskId).append(" ");
            }
            TSE.trace(result + " candidate for cleanup found " + sb.toString());
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, statement);
                if (connection != null) {
                    SqlResourceCloser.releaseConnection((JDBCConnection)connection);
                }
                throw throwable;
            }
            SqlResourceCloser.closeResources(rs, (Statement)statement);
            if (connection != null) {
                SqlResourceCloser.releaseConnection((JDBCConnection)connection);
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)statement);
        if (connection != null) {
            SqlResourceCloser.releaseConnection((JDBCConnection)connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteOldFinishedRecords() throws SQLException, TaskPersistLayerException {
        JDBCConnection conn = null;
        boolean allOK = true;
        boolean newTransaction = false;
        BatchPreparedStatement[] bps = null;
        String cleanStart = "TSE.BulkFinishedTaskCleanerThread delete records checking ...";
        TSE.trace(cleanStart);
        BulkFinishedTaskCleanerThread.logtoCogserver(cleanStart, null);
        TSE.trace(JDBCConnectionProperties.instance((String)"SDS").getUrlStr());
        DatabaseType sdsdbtype = JDBCConnectionProperties.instance((String)"SDS").getDBType();
        IBulkCleanStmtsObject iBulkCleanStmtsObject = BulkCleanStmtsObjectFactory.getInstance().makeObject(sdsdbtype);
        if (null != iBulkCleanStmtsObject) {
            int candidateCount = this.logCandidateDetails(iBulkCleanStmtsObject);
            if (candidateCount > 0) {
                block21: {
                    int i;
                    String[] stmts = iBulkCleanStmtsObject.getSQLstmts();
                    ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"BulkFinishedTaskCleanerThread.deleteRecords(TaskID[])");
                    try {
                        if (!BulkFinishedTaskCleanerThread.inTransaction()) {
                            newTransaction = true;
                            BulkFinishedTaskCleanerThread.startTransaction();
                        }
                        conn = BulkFinishedTaskCleanerThread.getTransactionConnection();
                        bps = new BatchPreparedStatement[stmts.length];
                        for (i = 0; i < stmts.length; ++i) {
                            bps[i] = new BatchPreparedStatement((Connection)conn, stmts[i]);
                        }
                        for (i = 0; i < bps.length; ++i) {
                            allOK = bps[i].execute();
                        }
                        if (!newTransaction) break block21;
                        try {
                            BulkFinishedTaskCleanerThread.commitTransaction();
                            newTransaction = false;
                        }
                        finally {
                            BulkFinishedTaskCleanerThread.closeTransactionConnection();
                        }
                    }
                    finally {
                        if (newTransaction) {
                            try {
                                BulkFinishedTaskCleanerThread.rollbackTransaction();
                                TSE.trace("TSE.BulkFinishedTaskCleanerThread failed so Rolled back.");
                            }
                            finally {
                                BulkFinishedTaskCleanerThread.closeTransactionConnection();
                            }
                        }
                        if (null != bps) {
                            for (i = 0; i < bps.length; ++i) {
                                if (null == bps[i]) continue;
                                bps[i].close();
                            }
                        }
                        zipiTimer.stop();
                    }
                }
                TSE.trace("TSE.BulkFinishedTaskCleanerThread delete records finished.");
            } else {
                TSE.trace("TSE.BulkFinishedTaskCleanerThread no cleanup needed");
            }
        } else {
            TSE.trace("TSE.BulkFinishedTaskCleanerThread no cleanup statements found for DB type " + sdsdbtype.toString());
        }
        return allOK;
    }

    private static JDBCConnection createTransactionConnection() throws TaskPersistLayerException {
        JDBCConnection con = null;
        con = trancon.get();
        if (con != null) {
            throw new TaskPersistLayerException(I18NCode.IO_DB_CONNECTION_ERROR);
        }
        try {
            con = NCConnection.instance().getOpenCloseFactory().createConnection();
            trancon.set(con);
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("BulkFinishedTaskCleanerThread.createTransactionConnection: " + e.getLocalizedMessage());
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)e, true);
            BulkFinishedTaskCleanerThread.logtoCogserver("", e);
            BulkFinishedTaskCleanerThread.throwException(e);
        }
        return con;
    }

    public static void throwException(Exception e) throws TaskPersistLayerException {
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)e);
        if (e instanceof TaskPersistLayerException) {
            throw (TaskPersistLayerException)((Object)e);
        }
        throw new TaskPersistLayerException(e);
    }

    public static void closeTransactionConnection() {
        JDBCConnection con = null;
        con = trancon.get();
        if (con != null) {
            try {
                try {
                    con.setAutoCommit(true);
                }
                finally {
                    NCConnection.instance().getConnectionFactory().releaseConnection(trancon.get());
                }
            }
            catch (SQLException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("BulkFinishedTaskCleanerThread.closeTransactionConnection: " + e.getLocalizedMessage());
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)e, true);
            }
            finally {
                trancon.set(null);
            }
        }
    }

    public static void startTransaction() throws TaskPersistLayerException {
        BulkFinishedTaskCleanerThread.createTransactionConnection();
    }

    public static void startTransaction(int isolationLevel) throws TaskPersistLayerException, SQLException {
        BulkFinishedTaskCleanerThread.createTransactionConnection();
        BulkFinishedTaskCleanerThread.getTransactionConnection().setAutoCommit(false);
    }

    private static JDBCConnection getTransactionConnection() {
        Validate.stateIsTrue((trancon.get() != null ? 1 : 0) != 0);
        return trancon.get();
    }

    public static void commitTransaction() throws TaskPersistLayerException, SQLException {
        JDBCUtils.comitTransaction((Connection)BulkFinishedTaskCleanerThread.getTransactionConnection());
    }

    public static void rollbackTransaction() {
        try {
            JDBCConnection conn = BulkFinishedTaskCleanerThread.getTransactionConnection();
            if (conn != null) {
                conn.rollback();
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("BulkFinishedTaskCleanerThread.rollbackTransaction: " + e.getLocalizedMessage());
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)e, true);
        }
    }

    public static boolean inTransaction() {
        return trancon.get() != null;
    }

    public void start() {
        this.m_PollInterval = CRNProperties.getProperty((String)"event.state.check.interval", (int)this.m_PollInterval);
        this.m_exit = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                BulkFinishedTaskCleanerThread.getInstance().sleep(30L);
                BulkFinishedTaskCleanerThread.getInstance().run();
            }
        }).start();
    }

    public void stop() {
        this.m_exit = true;
        if (this.m_timer_task != null) {
            this.m_timer_task.cancel();
        }
        this.m_timer_task = null;
    }

    private TimerTask resetTimerTask() {
        if (this.m_timer_task != null) {
            this.m_timer_task.cancel();
            this.m_timer_task = null;
        }
        return this.getTimerTask();
    }

    private TimerTask getTimerTask() {
        if (this.m_timer_task == null) {
            this.m_timer_task = new TimerTask(){

                @Override
                public void run() {
                    BulkFinishedTaskCleanerThread.getInstance().run();
                }
            };
        }
        return this.m_timer_task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BulkFinishedTaskCleanerThread getInstance() {
        if (initHolder.get() != null) return instance;
        Class<BulkFinishedTaskCleanerThread> clazz = BulkFinishedTaskCleanerThread.class;
        synchronized (BulkFinishedTaskCleanerThread.class) {
            if (instance == null) {
                instance = new BulkFinishedTaskCleanerThread();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            initHolder.set(Boolean.TRUE);
            return instance;
        }
    }

    private static void logtoCogserver(String msg, Exception e) {
        try {
            AuditProperties props = new AuditProperties("Run", msg, "", "Run");
            if (e != null) {
                props = new AuditProperties("Run", msg, e.getMessage(), "Run");
            }
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, (Map)props);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

