/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.tse.LowPriorityCmd;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;

public final class AbortStepsCmd
extends LowPriorityCmd {
    final TaskStateRecord state;
    TaskStatus abortStatus;
    TaskID[] steps;
    int nextStep;

    public AbortStepsCmd(TaskStateRecord state, TaskStatus abortStatus) {
        this.state = state;
        this.abortStatus = abortStatus;
        this.setCleanup(true);
    }

    @Override
    public void doAction() throws TaskPersistLayerException, TSEException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"AbortStepsCmd.doAction");
        try {
            TSE.trace(this, "doAction");
            this.abortSteps();
        }
        finally {
            zipiTimer.stop();
        }
    }

    public void abortSteps() throws TaskPersistLayerException, TSEException {
        if (this.steps == null) {
            this.nextStep = 0;
            this.steps = TaskStateRecord.getSeqSteps((TaskID)this.state.taskID, (int)this.state.curSeq, (TaskStatus)TaskStatus.READY);
            TSE.trace(this, "Abort Ready " + this.steps.length + " rows");
        }
        if (this.nextStep != this.steps.length) {
            TaskStateRecord.updateStatus((TaskID)this.steps[this.nextStep], (TaskStatus)this.abortStatus, (TaskStatus)TaskStatus.READY);
            if (NCTaskQueueTable.getInstance().stampSdsInstance(this.steps[this.nextStep], TaskQueueStatus.ALLOCATED, TaskQueueStatus.READY)) {
                this.completeTask(this.steps[this.nextStep]);
            }
            ++this.nextStep;
            if (this.nextStep != this.steps.length) {
                TSEStateMapProcessor.getInstance().queueCmd(this);
            }
        }
    }

    void completeTask(TaskID taskID) throws TSEException {
        TaskRunContext context = TaskRunContextFactory.createTaskRunContext(taskID);
        context.updateTaskStatus(TaskStatus.mapStatus((TaskStatus)this.abortStatus), null);
    }
}

