/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.ibm.cognos.pogo.zipi.ZipiTimer;

public class CleanTaskTableCmd
extends Cmd {
    I18NCode message;

    public CleanTaskTableCmd(I18NCode message) {
        this.message = message;
        this.setCleanup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws TSEException, TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"CleanTaskTableCmd.doAction");
        try {
            TSE.trace(this, "doAction");
            String previousId = SDSInstanceManager.getInstance().getRecoveredFromCrash();
            if (previousId != null) {
                TSE.trace(this, "Cleanup recovery");
                TSE.getInstance().cleanupInstance(previousId, this.message);
            }
            String[] sdsInstanceGuids = new String[]{};
            try {
                sdsInstanceGuids = NCTaskQueueTable.getInstance().getSdsInstanceGuids();
                for (int i = 0; i < sdsInstanceGuids.length; ++i) {
                    if (SDSInstanceManager.getInstance().getSDSInstance(sdsInstanceGuids[i]) != null) continue;
                    TSE.trace(this, "Cleanup instance");
                    TSE.getInstance().cleanupInstance(sdsInstanceGuids[i], this.message);
                }
            }
            catch (TaskPersistLayerException e) {
                TSE.getRTLogger().log(SDSLevel.WARN, MonitorI18NCode.MSG_TSE_GENERAL_ERROR, new Object[]{e.getMessage()});
            }
        }
        finally {
            zipiTimer.stop();
        }
    }
}

