/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.tse.LowPriorityCmd;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.ibm.cognos.pogo.zipi.ZipiTimer;

public final class PurgeTasksCmd
extends LowPriorityCmd {
    public PurgeTasksCmd() {
        this.setCleanup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws TSEException, TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"PurgeTasksCmd.doAction");
        try {
            TSE.trace(this, "doAction");
            TaskStateTable.StepInfo[] tasks = TaskStateTable.getTasksForPurge(null, (int)100);
            boolean moreToPurge = false;
            try {
                for (int i = 0; i != tasks.length; ++i) {
                    final TaskStateTable.StepInfo task = tasks[i];
                    moreToPurge = true;
                    SQLExecute sqlExecute = new SQLExecute(){

                        public Object execute() throws TaskPersistLayerException {
                            TSE.trace(this, "Purging " + task.taskId.toString() + ", status: " + task.getStatus());
                            if (task.hasChildren()) {
                                int rows = TaskStateTable.setParentToNullOnChildren((TaskID)task.taskId, (TaskStatus)TaskStatus.TERMINATED);
                                TSE.trace(this, "Purged " + rows + " rows");
                            }
                            TaskPersistLayer.getInstance().deleteRecords(task.taskId);
                            return null;
                        }
                    };
                    SQLTransactionExecuteHandler transHandler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
                    try {
                        transHandler.execute(sqlExecute);
                        continue;
                    }
                    catch (Exception e) {
                        TSE.throwException(e);
                    }
                }
                if (moreToPurge) {
                    TSEStateMapProcessor.getInstance().queueCmd(this);
                }
            }
            catch (Exception e) {
                TSE.throwException(e);
            }
        }
        finally {
            zipiTimer.stop();
        }
    }
}

