/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.BiBusSpec;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskDependencies;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskIDFilter;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.Filter;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class RestartTasksCmd
extends Cmd {
    private static String LOGONAS = "logonAs";
    private TaskStateRecord restartRecord;
    private TaskID[] skippies;
    private TaskID newEventId;
    private BiBusHeader userHeader;
    private BiBusRunSpec topRunSpec = null;

    public RestartTasksCmd(TaskStateRecord record, TaskID[] skippies, TaskID newEventId, BiBusHeader userHeader) {
        this.restartRecord = record;
        this.skippies = skippies;
        this.newEventId = newEventId;
        this.userHeader = userHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws TSEException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"RestartTasksCmd.doAction");
        try {
            TSE.trace(this, "do restart " + this.restartRecord.taskID.getID());
            SQLExecute sqlExecute = new SQLExecute(){

                public Object execute() throws TaskPersistLayerException {
                    TaskStateRecord[] parents = RestartTasksCmd.this.restartRecord.findAncestors();
                    TaskIDFilter skipSet = new TaskIDFilter(RestartTasksCmd.this.skippies, true);
                    boolean runThisTask = true;
                    try {
                        if (parents.length > 0) {
                            RestartTasksCmd.this.resetParentsState(parents, RestartTasksCmd.this.restartRecord);
                            runThisTask = false;
                        }
                        RestartTasksCmd.this.resetTaskStateRecursively(RestartTasksCmd.this.restartRecord, (Filter)skipSet, false, runThisTask);
                        NCTaskQueueTable.getInstance().setRestartId(((RestartTasksCmd)RestartTasksCmd.this).restartRecord.taskID, RestartTasksCmd.this.newEventId);
                    }
                    catch (Exception e) {
                        throw new TaskPersistLayerException(e);
                    }
                    return null;
                }
            };
            SQLTransactionExecuteHandler transHandler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
            try {
                transHandler.execute(sqlExecute);
            }
            catch (TaskPersistLayerException e) {
                TSE.throwException((Exception)((Object)e));
            }
            MonitorService.instance().getJobQueueReceiver().notifyNewQueueEntries();
        }
        finally {
            zipiTimer.stop();
        }
    }

    private void resetParentsState(TaskStateRecord[] parents, TaskStateRecord record) throws Exception {
        for (int i = parents.length - 1; i >= 0; --i) {
            boolean run = i == parents.length - 1;
            TaskStateTable.StepInfo[] childers = TaskStateTable.getChildren((TaskID)parents[i].taskID, null);
            TaskID nextAncestorId = i > 0 ? parents[i - 1].taskID : record.taskID;
            for (int j = 0; j < childers.length; ++j) {
                if (childers[j].taskId.equals((Object)nextAncestorId)) continue;
                TaskRecord taskRecord = NCTaskQueueTable.getInstance().find(childers[j].taskId, false);
                taskRecord.setRestartId(TaskRecord.RESTART_IGNORE_HISTORY_WRITE);
                taskRecord.update(new String[]{"RESTART_ID"});
            }
            TaskIDFilter filter = new TaskIDFilter(new TaskID[]{nextAncestorId}, false);
            RestartSequenceData rsd = this.getRestartSequenceData(run, childers, (Filter)filter);
            parents[i].resetForRestart(rsd.restartSequence, rsd.countSeq, (short)0, run ? TaskStatus.READY : TaskStatus.PENDING, run);
            TaskRecord parentRecord = NCTaskQueueTable.getInstance().find(parents[i].taskID, true);
            parentRecord.setStatus(run ? TaskQueueStatus.READY : TaskQueueStatus.QUEUED);
            parentRecord.setRestartId(run ? this.newEventId : TaskID.create());
            parentRecord.setHistoryStoreId(null);
            if (run) {
                this.authenticateTopRecord(parentRecord, true);
                continue;
            }
            this.authenticateChildRecord(parentRecord, true);
        }
    }

    private void authenticateChildRecord(TaskRecord record, boolean update) throws LocalizableException, EMFSecurityException, RemoteException {
        BiBusRunSpec runSpec = (BiBusRunSpec)record.getRunSpec();
        runSpec.header = this.topRunSpec.header;
        runSpec.authenticated = true;
        record.setTimeStamp(new Date().getTime());
        record.setActualCompletionTime(0L);
        record.setActualExecutionTime(0L);
        if (update) {
            record.update(new String[]{"TASK", "DATE_ENTERED", "ACTUAL_COMPLETION_TIME", "ACTUAL_EXECUTION_TIME"});
        }
    }

    private BiBusRunSpec authenticateTopRecord(TaskRecord record, boolean update) throws LocalizableException, EMFSecurityException, RemoteException {
        BiBusRunSpec runSpec = (BiBusRunSpec)record.getRunSpec();
        if (this.userHeader != null) {
            JobBiBusHeaders jobHdr = new JobBiBusHeaders(this.userHeader);
            AuthenticatorFactory.getInstance().clonePassport(jobHdr);
            runSpec.header = this.userHeader = jobHdr.getBiBusHeader();
            runSpec.authenticated = true;
        } else {
            try {
                runSpec.header.setCAM(new CAM());
                String credentialPath = runSpec.getCredentialPath();
                runSpec.header.getCAM().setCAMCredentialPath(credentialPath);
                runSpec.header.getCAM().setAction(LOGONAS);
                TSE.getInstance().authenticateHeader((BiBusSpec)runSpec, true);
                runSpec.authenticated = true;
            }
            catch (Exception ex) {
                TSE.logException(ex);
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_USER_AUTHENTICATION_FAILED_DURING_TASK_EXECUTION);
            }
        }
        record.setTimeStamp(new Date().getTime());
        record.setActualCompletionTime(0L);
        record.setActualExecutionTime(0L);
        this.topRunSpec = runSpec;
        if (update) {
            record.update(new String[]{"TASK", "DATE_ENTERED", "ACTUAL_COMPLETION_TIME", "ACTUAL_EXECUTION_TIME", "RESTART_ID", "STATUS", "HISTORY_STORE_ID"});
        }
        return runSpec;
    }

    private TaskStateRecord resetTaskStateRecursively(TaskStateRecord restartRecord, Filter skippies, boolean isDependentTask, boolean run) throws Exception {
        if (!skippies.accept((Object)restartRecord.taskID) || !this.canRestart(restartRecord, run) && !isDependentTask) {
            if (run) {
                throw new TaskPersistLayerException(MonitorI18NCode.MSG_MS_RESTART_TASK_FAILED, new Object[]{restartRecord.taskID.getID()});
            }
            if (restartRecord.status == TaskStatus.COMPLETED || !skippies.accept((Object)restartRecord.taskID)) {
                TaskRecord taskRecord = NCTaskQueueTable.getInstance().find(restartRecord.taskID, false);
                taskRecord.setRestartId(TaskRecord.RESTART_IGNORE_HISTORY_WRITE);
                taskRecord.update(new String[]{"RESTART_ID"});
            }
            return null;
        }
        TaskStateTable.StepInfo[] childers = TaskStateTable.getChildren((TaskID)restartRecord.taskID, null);
        TaskRecord record = NCTaskQueueTable.getInstance().find(restartRecord.taskID, true);
        if (run) {
            this.authenticateTopRecord(record, false);
        } else {
            this.authenticateChildRecord(record, false);
        }
        if (record.getRunSpec().loadFailed()) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_RERUN_NOT_POSSIBLE);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, record.getRunSpec().loadFault.getFaultyLoadErrorCode());
            I18NMessage msg = new I18NMessage(MonitorI18NCode.MSG_MS_RERUN_NOT_POSSIBLE, null, SeverityEnum.warn);
            String infoMSG = msg.getMessage(Locale.getDefault());
            record.getRunSpec().loadFault.setFaultyLoadErrorParams(new Object[]{infoMSG});
        }
        if (childers.length == 1 && TaskStatus.FAILED.equals((Object)restartRecord.status) && record.getServiceName() != null && record.getServiceName().indexOf("agent") != -1) {
            TSE.trace(this, "restart cmd removing failed agent condition record" + childers[0].taskId.toString());
            TaskPersistLayer.getInstance().deleteRecords(childers[0].taskId);
            childers = new TaskStateTable.StepInfo[]{};
        }
        RestartSequenceData rsd = this.getRestartSequenceData(run, childers, skippies);
        TaskID restartHistoryId = null;
        if (restartRecord.status.hasWrittenHistory()) {
            restartHistoryId = run ? this.newEventId : TaskID.create();
        }
        TaskStatus restartStatus = run ? TaskStatus.READY : TaskStatus.PENDING;
        restartRecord.resetForRestart(rsd.restartSequence, rsd.countSeq, (short)0, restartStatus, run);
        record.setStatus(restartStatus == TaskStatus.READY ? TaskQueueStatus.READY : TaskQueueStatus.QUEUED);
        record.setRestartId(restartHistoryId);
        record.setHistoryStoreId(null);
        String[] updateFields = new String[]{"TASK", "DATE_ENTERED", "ACTUAL_COMPLETION_TIME", "ACTUAL_EXECUTION_TIME", "RESTART_ID", "STATUS", "HISTORY_STORE_ID"};
        record.update(updateFields);
        Set dependencySet = this.getDependencySet(childers);
        for (int i = 0; i < childers.length; ++i) {
            this.resetTaskStateRecursively(TaskStateRecord.findRecord((TaskID)childers[i].taskId), skippies, dependencySet.contains(childers[i].taskId), false);
        }
        return restartRecord;
    }

    private boolean canRestart(TaskStateRecord record, boolean topLevel) {
        return record.status.canRestart(topLevel) || record.seq >= 30100;
    }

    private boolean canRestart(TaskStateTable.StepInfo info, boolean topLevel) {
        return info.getStatus().canRestart(topLevel) || info.seq >= 30100;
    }

    private Set getDependencySet(TaskStateTable.StepInfo[] childers) throws TaskPersistLayerException {
        HashSet<TaskID> dependencySet = new HashSet<TaskID>();
        for (int i = 0; i < childers.length; ++i) {
            if (!this.canRestart(childers[i], false)) continue;
            TaskID[] dependents = TaskDependencies.retrieveDependencies((TaskID)childers[i].taskId);
            dependencySet.addAll(Arrays.asList(dependents));
        }
        return dependencySet;
    }

    private RestartSequenceData getRestartSequenceData(boolean run, TaskStateTable.StepInfo[] childers, Filter skippies) {
        RestartSequenceData rsd = new RestartSequenceData();
        HashSet<Short> countSeq = new HashSet<Short>();
        TaskStateTable.StepInfo lowestRestartable = null;
        for (int i = 0; i < childers.length; ++i) {
            int lowest;
            int n = lowest = lowestRestartable == null ? childers.length + 1 : lowestRestartable.seq;
            if (childers[i].seq <= lowest && this.canRestart(childers[i], run) && skippies.accept((Object)childers[i].taskId)) {
                lowestRestartable = childers[i];
            }
            countSeq.add(new Short(childers[i].seq));
        }
        rsd.countSeq = (short)countSeq.size();
        short s = rsd.restartSequence = lowestRestartable == null ? (short)0 : lowestRestartable.seq;
        if (lowestRestartable != null && skippies.accept((Object)lowestRestartable.taskId)) {
            rsd.restartSequence = (short)(rsd.restartSequence - 1);
        }
        if (rsd.restartSequence == Short.MAX_VALUE) {
            rsd.restartSequence = 0;
        }
        return rsd;
    }

    private class RestartSequenceData {
        short restartSequence = Short.MAX_VALUE;
        short countSeq = 1;

        private RestartSequenceData() {
        }
    }
}

