/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.WriteFinalHistoryObject;
import com.cognos.monitor.tse.WriteFinalHistoryService;
import com.cognos.monitor.tse.commands.LogoffCmd;
import com.cognos.monitor.tse.commands.PurgeTasksCmd;
import com.ibm.cognos.pogo.zipi.ZipiTimer;

public final class RunCompleteCmd
extends Cmd {
    final TaskRunContext task;
    boolean calledFromFailover = false;

    public RunCompleteCmd(TaskRunContext task) {
        this.task = task;
    }

    public RunCompleteCmd(TaskRunContext task, boolean calledFromFailover) {
        this.task = task;
        this.calledFromFailover = calledFromFailover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws TaskPersistLayerException {
        block9: {
            ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"RunCompleteCmd.doAction");
            try {
                this.debug(this, "doAction", this.task.getTaskId().getID(), "RunCompleteCmd called");
                if (!WriteFinalHistoryService.useWriteFinalHistoryService) {
                    this.debug(this, "doAction", this.task.getTaskId().getID(), "TSE_WFH: RunCompleteCmd : writing final history without using WriteFinalHistoryService");
                    try {
                        String[] taskIDs = this.task.getHistoryWriter().writeFinalHistory();
                        TaskHistoryDetailRecord.deleteAll((String[])taskIDs);
                    }
                    catch (TSEException ex) {
                        throw new TaskPersistLayerException((Exception)ex);
                    }
                    if (this.task.logOffRequired()) {
                        TSEStateMapProcessor.getInstance().queueCmd(new LogoffCmd(this.task));
                    }
                    TSEStateMapProcessor.getInstance().queueCmd(new PurgeTasksCmd());
                    break block9;
                }
                this.debug(this, "doAction", this.task.getTaskId().getID(), "TSE_WFH: RunCompleteCmd : writing final history using WriteFinalHistoryService");
                try {
                    WriteFinalHistoryObject wfho = new WriteFinalHistoryObject();
                    wfho.setTaskId(this.task.getTaskId());
                    wfho.setHistoryWriteAfterFailover(this.calledFromFailover);
                    WriteFinalHistoryService wfhs = WriteFinalHistoryService.getInstance();
                    wfhs.writeFinalHistory(wfho);
                }
                catch (Exception ex) {
                    this.debug(this, "doAction", this.task.getTaskId().getID(), "TSE_WFH: Error Occurred while Writing Final History, EXCEPTION: " + ex.getLocalizedMessage());
                    throw new TaskPersistLayerException(ex);
                }
            }
            finally {
                zipiTimer.stop();
            }
        }
    }
}

