/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.Date;

public final class RunNewTaskCmd
extends Cmd {
    final TaskRunContext task;

    public RunNewTaskCmd(TaskRunContext task) {
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws TSEException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"RunNewTaskCmd.doAction");
        try {
            this.debug(this, "doAction", this.task.getTaskId().getID(), "RunNewTaskCmd called");
            try {
                ArrayList updateFields = new ArrayList();
                try {
                    this.task.onRunNewTaskCmd(updateFields);
                }
                catch (TSEException ex) {
                    Throwable cause = ex.getCause();
                    I18NMessage message = null;
                    message = cause != null && cause instanceof EMFSecurityException ? new I18NMessage(I18NCode.MSG_USER_AUTHENTICATION_FAILED_DURING_TASK_EXECUTION, new Object[0], SeverityEnum.error) : new I18NMessage(I18NCode.MSG_TASK_EXECUTION_FAILED, new Object[0], SeverityEnum.error);
                    TaskRecord taskRecord = NCTaskQueueTable.getInstance().find(this.task.getTaskId(), false);
                    if (taskRecord.getActualExecutionTime() == 0L) {
                        TaskRecord taskRec = this.task.getTaskRecord();
                        taskRec.setActualExecutionTime(new Date().getTime());
                        taskRec.update(new String[]{"ACTUAL_EXECUTION_TIME"});
                    }
                    TaskStateRecord.setStatus((TaskID)this.task.getTaskId(), (TaskStatus)TaskStatus.FAILED);
                    this.task.updateTaskStatus(EventStatus.FAILED, message);
                    throw ex;
                }
                this.debug(this, "doAction", this.task.getTaskId().getID(), "Enabled Task");
                NewRunSQLExecute sqlExec = new NewRunSQLExecute(updateFields);
                SQLTransactionExecuteHandler handler = new SQLTransactionExecuteHandler(MonitorCategory.RUNTIME);
                int result = (Integer)handler.execute((SQLExecute)sqlExec);
                if (result > 0) {
                    NCTaskQueueTable.getInstance().addTaskToQueue(this.task.getTaskRecord());
                }
                MonitorService.instance().getJobQueueReceiver().notifyNewQueueEntries();
            }
            catch (Exception e) {
                TSE.throwException(e);
            }
        }
        finally {
            zipiTimer.stop();
        }
    }

    private class NewRunSQLExecute
    implements SQLExecute {
        ArrayList updateFields;

        public NewRunSQLExecute(ArrayList updateFields) {
            this.updateFields = updateFields;
            updateFields.add("STATUS");
            updateFields.add("SDS_INSTANCE_ID");
        }

        public Object execute() throws TaskPersistLayerException {
            int result = 0;
            if (TaskStateRecord.updateStatus((TaskID)RunNewTaskCmd.this.task.getTaskId(), (TaskStatus)TaskStatus.READY, (TaskStatus)TaskStatus.PENDING) != 0) {
                RunNewTaskCmd.this.debug(this, "execute", RunNewTaskCmd.this.task.getTaskId().getID(), "Update state status: pending -> ready succeeded, updating task to ready");
                TaskRecord taskRec = RunNewTaskCmd.this.task.getTaskRecord();
                taskRec.setStatus(TaskQueueStatus.READY);
                taskRec.setSdsInstanceId(null);
                result = taskRec.update(this.updateFields.toArray(new String[0]));
            } else {
                RunNewTaskCmd.this.debug(this, "execute", RunNewTaskCmd.this.task.getTaskId().getID(), "Update state status failed: pending -> ready !!!");
            }
            return result;
        }
    }
}

