/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.cognos.monitor.tse.commands.TerminateSequenceCmd;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.sql.SQLException;
import java.util.ArrayList;

public final class RunNextStepCmd
extends Cmd {
    final TaskStateRecord state;
    final TaskRunContext task;
    final I18NMessage message;

    public RunNextStepCmd(TaskRunContext task, TaskStateRecord state, I18NMessage message) {
        this.state = state;
        this.task = task;
        this.message = message;
        this.setCleanup(true);
    }

    @Override
    public void doAction() throws TSEException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"RunNextStepCmd.doAction");
        try {
            if (this.state.curSeq >= this.state.countSeq) {
                // empty if block
            }
            try {
                this.enableNextStep();
            }
            catch (Exception e) {
                TSE.throwException(e);
            }
        }
        finally {
            zipiTimer.stop();
        }
    }

    void enableNextStep() throws TaskPersistLayerException, SQLException, TSEException {
        SQLTransactionExecuteHandler handler = new SQLTransactionExecuteHandler(MonitorCategory.RUNTIME);
        RunNextStepSqlExecute sqlExecute = new RunNextStepSqlExecute();
        handler.execute((SQLExecute)sqlExecute);
        int count = sqlExecute.getCount();
        TaskStatus newStatus = sqlExecute.getTaskStatus();
        this.debug(this, "enableNextStep", this.task.getTaskId().getID(), "Next Step: " + this.state.curSeq + " Child steps: " + count);
        if (count == 0) {
            this.completeTask(this.state.taskID);
        } else if (newStatus.isTerminatingStatus()) {
            this.terminateSteps(newStatus);
        } else {
            MonitorService.instance().getJobQueueReceiver().notifyNewQueueEntries();
        }
    }

    void completeTask(TaskID taskID) throws TSEException {
        this.debug(this, "completeTask", this.task.getTaskId().getID(), "completing Task");
        TaskRunContext context = TaskRunContextFactory.createTaskRunContext(taskID);
        context.updateTaskStatus(TaskStatus.mapStatus((TaskStatus)TaskStatus.COMPLETED), this.message);
    }

    void terminateSteps(TaskStatus newStatus) {
        this.debug(this, "terminateSteps", this.task.getTaskId().getID(), "terminate steps");
        TSEStateMapProcessor.getInstance().queueCmd(new TerminateSequenceCmd(this.state, newStatus, this.message));
    }

    private class RunNextStepSqlExecute
    implements SQLExecute {
        private int count = 0;
        TaskStatus newStatus = TaskStatus.READY;
        short cachedCurSeq;

        private RunNextStepSqlExecute() {
            this.cachedCurSeq = RunNextStepCmd.this.state.curSeq;
        }

        public Object execute() throws TaskPersistLayerException {
            this.count = 0;
            this.newStatus = TaskStatus.READY;
            RunNextStepCmd.this.state.curSeq = this.cachedCurSeq;
            int loopCount = 0;
            while (this.count == 0 && this.nextSeq()) {
                RunNextStepCmd.this.debug(this, "RunNextStepSqlExecute.execute()", RunNextStepCmd.this.task.getTaskId().getID(), "setting task state steps - loopCount=" + ++loopCount + " state.status=" + RunNextStepCmd.this.state.status.toString() + " state.curSeq=" + RunNextStepCmd.this.state.curSeq);
                this.newStatus = RunNextStepCmd.this.state.status == TaskStatus.CANCELLED ? TaskStatus.CANCELLED : (RunNextStepCmd.this.state.stepFailed == 1 && RunNextStepCmd.this.state.curSeq <= RunNextStepCmd.this.state.countSeq ? (RunNextStepCmd.this.state.writeAllHistories ? TaskStatus.PURGED : TaskStatus.CANCELLED) : TaskStatus.READY);
                this.count = TaskStateRecord.setStepsAsReady((TaskID)RunNextStepCmd.this.state.taskID, (int)RunNextStepCmd.this.state.curSeq, (TaskStatus)this.newStatus);
                RunNextStepCmd.this.debug(this, "RunNextStepSqlExecute.execute()", RunNextStepCmd.this.task.getTaskId().getID(), "setting task state steps to ready (: setStepsAsReady) [" + this.count + "], state.curSeq=" + RunNextStepCmd.this.state.curSeq + " newStatus=" + this.newStatus.toString());
            }
            int updated = TaskStateRecord.nextStep((TaskID)RunNextStepCmd.this.state.taskID, (int)RunNextStepCmd.this.state.curSeq, (int)this.count);
            RunNextStepCmd.this.debug(this, "RunNextStepSqlExecute.execute()", RunNextStepCmd.this.task.getTaskId().getID(), "setting task state curSeq and count (: nextStep) [" + this.count + "], state.curSeq=" + RunNextStepCmd.this.state.curSeq + " newStatus=" + this.newStatus.toString() + " count=" + this.count + " updated=" + updated);
            if (this.count != 0 && !this.newStatus.isTerminatingStatus()) {
                TaskID[] steps = TaskStateRecord.getSeqSteps((TaskID)RunNextStepCmd.this.state.taskID, (int)RunNextStepCmd.this.state.curSeq, (TaskStatus)this.newStatus);
                RunNextStepCmd.this.debug(this, "RunNextStepSqlExecute.execute()", RunNextStepCmd.this.task.getTaskId().getID(), "setting task steps to ready (: getSeqSteps) [" + steps.length + "], state.curSeq=" + RunNextStepCmd.this.state.curSeq + " newStatus=" + this.newStatus.toString());
                ArrayList<String> stepTaskIDList = new ArrayList<String>();
                for (int i = 0; i != steps.length; ++i) {
                    int result = NCTaskQueueTable.getInstance().setReady(steps[i], RunNextStepCmd.this.task.getTaskRecord().getPriority());
                    if (result <= 0) continue;
                    stepTaskIDList.add(steps[i].getID());
                }
                if (!stepTaskIDList.isEmpty()) {
                    String[] stepTaskIDs = stepTaskIDList.toArray(new String[stepTaskIDList.size()]);
                    TaskRecord[] taskRecords = NCTaskQueueTable.getInstance().findTasks(stepTaskIDs);
                    if (taskRecords != null) {
                        for (int i = 0; i < taskRecords.length; ++i) {
                            NCTaskQueueTable.getInstance().addTaskToQueue(taskRecords[i]);
                        }
                    }
                }
            } else {
                RunNextStepCmd.this.debug(this, "RunNextStepSqlExecute.execute()", RunNextStepCmd.this.task.getTaskId().getID(), "skip setting task steps to ready count=" + this.count + " newStatus=" + this.newStatus.toString());
            }
            return null;
        }

        boolean nextSeq() {
            short curSeq = RunNextStepCmd.this.state.curSeq;
            if (curSeq < RunNextStepCmd.this.state.countSeq) {
                curSeq = (short)(curSeq + 1);
            } else if (curSeq == RunNextStepCmd.this.state.countSeq) {
                curSeq = RunNextStepCmd.this.state.stepFailed == 0 ? (short)30200 : 30100;
            } else if (curSeq == 30100 || curSeq == 30200) {
                curSeq = 30300;
            }
            if (curSeq != RunNextStepCmd.this.state.curSeq) {
                RunNextStepCmd.this.state.curSeq = curSeq;
                return true;
            }
            return false;
        }

        public int getCount() {
            return this.count;
        }

        public TaskStatus getTaskStatus() {
            return this.newStatus;
        }
    }
}

