/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.impl.EventResultType;
import com.cognos.monitor.impl.EventsResult;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.EventCanceler;
import com.cognos.monitor.tse.HTSEventCanceler;
import com.cognos.monitor.tse.HistoryWriter;
import com.cognos.monitor.tse.StandardEventCanceler;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.cognos.monitor.tse.WriteFinalHistoryObject;
import com.cognos.monitor.tse.WriteFinalHistoryService;
import com.cognos.sds.event.EventTransition;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.Date;

public class TaskRunCancelledCmd
extends Cmd {
    private TaskRunContext m_taskRunContext;
    private String m_userName;
    private boolean m_cancelled = false;
    private BiBusHeader m_biBusHeader = null;

    public TaskRunCancelledCmd(TaskRunContext taskRunContext) {
        this.m_taskRunContext = taskRunContext;
        this.m_userName = this.m_taskRunContext.getTaskRecord().getRunSpec().cancelledBy;
        try {
            this.m_biBusHeader = BiBusUtilities.extractBiBusHeader();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doAction() throws TSEException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TaskRunCancelledCmd.doAction");
        try {
            TaskStateRecord state;
            block10: {
                block9: {
                    TaskID task = this.m_taskRunContext.getTaskId();
                    state = new TaskStateRecord();
                    if (state.find(task)) break block9;
                    EventTransition.validate(null, null);
                    zipiTimer.stop();
                    return;
                }
                if (state.status != TaskStatus.CANCELLED && state.status != TaskStatus.TERMINATED) break block10;
                zipiTimer.stop();
                return;
            }
            try {
                TSE.validateTransition(state.status, TaskStatus.CANCELLED);
                this.m_cancelled = this.cancelTask(state, this.m_userName);
                return;
            }
            catch (TaskPersistLayerException e) {
                TSE.throwException((Exception)((Object)e));
                return;
            }
            catch (Exception e) {
                TSE.throwException(e);
                return;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            zipiTimer.stop();
        }
    }

    boolean cancelTask(TaskStateRecord state, String userName) throws TaskPersistLayerException, TSEException, MonitorServiceException {
        String id;
        TaskID task = state.taskID;
        boolean result = false;
        boolean background = !state.runViaMS;
        TaskRecord record = null;
        if (state.parentID == null) {
            record = this.m_taskRunContext.getTaskRecord();
        } else {
            record = NCTaskQueueTable.getInstance().find(task, false);
            if (null == record) {
                EventTransition.validate(null, null);
                return false;
            }
        }
        while (!TaskQueueStatus.FINISHED.equals(record.getStatus()) && !TaskQueueStatus.ALLOCATED.equals(record.getStatus())) {
            if (NCTaskQueueTable.getInstance().updateStatus(task, TaskQueueStatus.FINISHED, record.getStatus()) != 0) {
                record.setStatus(TaskQueueStatus.FINISHED);
                if (TaskStateRecord.updateStatus((TaskID)task, (TaskStatus)TaskStatus.PURGED, (TaskStatus)state.status) != 0) {
                    if (state.parentID != null) {
                        TaskStateRecord.decStepCount((TaskID)state.parentID);
                    }
                    result = true;
                } else {
                    record = NCTaskQueueTable.getInstance().find(task, false);
                    if (null == record) {
                        return false;
                    }
                }
                this.writeCancelHistory(state, TaskStatus.PURGED, userName);
                if (state.countSeq <= 0) continue;
                this.cancelChildTasks(state.taskID, userName);
                continue;
            }
            record = NCTaskQueueTable.getInstance().find(task, false);
            if (null != record) continue;
            return false;
        }
        if (TaskQueueStatus.ALLOCATED.equals(record.getStatus()) && (id = NCTaskQueueTable.getInstance().getSdsInstance(state.taskID)) != null) {
            String eventID = state.taskID.toEventId();
            EventsResult eventsResult = this.getEventCanceler(state, record).cancel(id, eventID, userName, background);
            EventResultType resultType = eventsResult.getEventResultType(eventID);
            boolean continueChildCancel = false;
            if (resultType != null && resultType.equals(EventResultType.CANCEL_SUCCEEDED)) {
                continueChildCancel = true;
            } else {
                record = NCTaskQueueTable.getInstance().find(task, false);
                if (null != record && record.getStatus().equals(TaskQueueStatus.ALLOCATED)) {
                    continueChildCancel = true;
                }
            }
            if (continueChildCancel) {
                if (TaskStateRecord.updateStatus((TaskID)task, (TaskStatus)TaskStatus.TERMINATED, (TaskStatus)state.status) != 0) {
                    result = true;
                } else {
                    record = NCTaskQueueTable.getInstance().find(task, false);
                    if (null == record) {
                        return false;
                    }
                }
                record.setActualCompletionTime(new Date().getTime());
                record.update(new String[]{"ACTUAL_COMPLETION_TIME"});
                if (state.countSeq > 0) {
                    this.cancelChildTasks(state.taskID, userName);
                }
                this.writeCancelHistory(state, TaskStatus.TERMINATED, userName);
                result = true;
            }
        }
        if (result && state.parentID == null) {
            this.writeFinalHistory(this.m_taskRunContext);
            if (!WriteFinalHistoryService.useWriteFinalHistoryService) {
                TaskPersistLayer.getInstance().deleteRecordsIncludingChildren(new TaskID[]{task});
            }
        }
        return result;
    }

    private EventCanceler getEventCanceler(TaskStateRecord state, TaskRecord record) {
        EventCanceler canceler = null;
        canceler = TaskStatus.INACTIVE.equals((Object)state.status) && "humanTask".equals(record.getObjectClass()) ? new HTSEventCanceler(this.m_taskRunContext, state) : new StandardEventCanceler(this.m_taskRunContext, this.m_biBusHeader);
        return canceler;
    }

    void cancelChildTasks(TaskID taskID, String userName) throws TaskPersistLayerException, TSEException, MonitorServiceException {
        TaskStateTable.StepInfo[] steps = TaskStateTable.getChildren((TaskID)taskID, null);
        TaskStateRecord state = new TaskStateRecord();
        int pending_count = 0;
        int ready_count = 0;
        int running_count = 0;
        for (int i = 0; i != steps.length; ++i) {
            TaskStatus status = steps[i].getStatus();
            if (status != TaskStatus.PENDING && status != TaskStatus.READY && status != TaskStatus.RUNNING && status != TaskStatus.INACTIVE || !state.find(steps[i].taskId)) continue;
            this.cancelTask(state, userName);
            if (status == TaskStatus.PENDING) {
                ++pending_count;
                continue;
            }
            if (status == TaskStatus.READY) {
                ++ready_count;
                continue;
            }
            if (status != TaskStatus.RUNNING) continue;
            ++running_count;
        }
        TSE.trace(this, "Cancelled " + pending_count + " PENDING, " + ready_count + " READY, " + running_count + " RUNNING");
    }

    private void writeCancelHistory(TaskStateRecord state, TaskStatus status, String userName) throws TSEException, TaskPersistLayerException {
        TaskRunContext parentContext = TaskRunContextFactory.createTaskRunContext(state.taskID);
        HistoryWriter writer = parentContext.getHistoryWriter();
        if (writer != null) {
            writer.createHistory(status);
            if (state.parentID == null) {
                writer.addInfoDetail(MonitorI18NCode.MSG_MS_CANCELLED_BY_USER_X, new Object[]{userName});
            }
            TaskHistoryDetailRecord detail = new TaskHistoryDetailRecord(state.taskID);
            int inactiveCount = detail.countByStatus(TaskStatus.INACTIVE.getId());
            if ((TaskStatus.RUNNING.equals((Object)state.status) || TaskStatus.INACTIVE.equals((Object)state.status)) && inactiveCount > 0) {
                writer.addInfoDetail(MonitorI18NCode.MSG_MS_UNABLE_CANCEL_DEPENDENT, new Object[0]);
            }
            writer.updateHistoryStatus(status);
        }
    }

    private void writeFinalHistory(TaskRunContext context) throws TaskPersistLayerException {
        if (!WriteFinalHistoryService.useWriteFinalHistoryService) {
            TSE.trace(this, "TSE_WFH: TaskRunCancelledCmd : writing final history without using WriteFinalHistoryService");
            try {
                String[] taskIDs = context.getHistoryWriter().writeFinalHistory();
                TaskHistoryDetailRecord.deleteAll((String[])taskIDs);
            }
            catch (TSEException ex) {
                throw new TaskPersistLayerException((Exception)ex);
            }
        }
        TSE.trace(this, "TSE_WFH: TaskRunCancelledCmd : writing final history using WriteFinalHistoryService");
        try {
            WriteFinalHistoryObject wfho = new WriteFinalHistoryObject();
            wfho.setTaskId(context.getTaskId());
            WriteFinalHistoryService wfhs = WriteFinalHistoryService.getInstance();
            wfhs.writeFinalHistory(wfho);
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH: Error Occurred while Writing Final History, EXCEPTION: " + ex);
            throw new TaskPersistLayerException(ex);
        }
    }

    public boolean cancelled() {
        return this.m_cancelled;
    }
}

