/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.sql.util.ISQLExecuteHandler;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLExecuteHandlerFactory;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TSEObjectFactory;
import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.Validate;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.HistoryWriter;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.cognos.monitor.tse.commands.AbortStepsCmd;
import com.cognos.monitor.tse.commands.RunCompleteCmd;
import com.cognos.monitor.tse.commands.RunNextStepCmd;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.Date;

public class TaskRunFinishedCmd
extends Cmd {
    private static final byte STEP_FAILED_NOT_SET = 0;
    private final TaskRunContext task;
    private TaskStatus status;
    private boolean updateParent;
    private I18NMessage[] overrideHistoryDetail;
    private I18NMessage overrideHistoryMessage;
    private boolean doPostProcessing;

    public TaskRunFinishedCmd(TaskRunContext task, I18NMessage msg) {
        this(task, msg, true);
    }

    public TaskRunFinishedCmd(TaskRunContext task, I18NMessage msg, boolean doPostProcessing) {
        this.task = task;
        this.status = task.getStatus();
        this.overrideHistoryDetail = new I18NMessage[]{msg};
        this.setCleanup(true);
        this.doPostProcessing = doPostProcessing;
        this.overrideHistoryMessage = msg != null && (msg.getCode() == MonitorI18NCode.MSG_MS_FAIL_RECOVERED || msg.getCode() == I18NCode.MSG_TASK_EXECUTION_FAILED || msg.getCode() == I18NCode.MSG_USER_AUTHENTICATION_FAILED_DURING_TASK_EXECUTION) ? msg : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws TaskPersistLayerException, TSEException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TaskRunFinishedCmd.doAction");
        try {
            this.debug(this, "doAction", this.task.getTaskId().getID(), "start executing RunFinishedCmd [status is " + this.status.toString());
            TaskStateRecord state = TSEObjectFactory.getInstance().createTaskStateRecord();
            boolean found = state.find(this.task.getTaskId());
            Validate.stateIsTrue((boolean)found);
            this.taskFinished(state);
        }
        finally {
            zipiTimer.stop();
        }
    }

    void taskFinished(TaskStateRecord state) throws TaskPersistLayerException, TSEException {
        if (this.status == TaskStatus.COMPLETED && state.stepFailed != 0) {
            this.debug(this, "taskFinished", this.task.getTaskId().getID(), "Mapping COMPLETED -> FAILED");
            this.status = TaskStatus.FAILED;
            this.task.setStatus(this.status);
        }
        TaskHistoryDetailRecord historyDetails = TSEObjectFactory.getInstance().createTaskRunHistoryDetail(this.task.getTaskId());
        int inactiveChildren = historyDetails.countByStatus(TaskStatus.INACTIVE.getId());
        if ((this.status == TaskStatus.COMPLETED || this.status == TaskStatus.FAILED) && state.seqOnEnd) {
            this.debug(this, "taskFinished", this.task.getTaskId().getID(), "Task status: " + this.status + " , and 'sequence on end'");
            if (state.curSeq != 30300) {
                this.debug(this, "taskFinished", this.task.getTaskId().getID(), "Task status: " + this.status + " , and run on sequence end step");
                if (this.status == TaskStatus.FAILED) {
                    if (state.stepFailed == 0) {
                        state.stepFailed = (byte)2;
                        TaskStateRecord.updateStepFailed((TaskID)state.taskID, (byte)2);
                    }
                    if (this.overrideHistoryDetail != null) {
                        this.addHistoryDetail(this.task, this.overrideHistoryDetail);
                    }
                }
                this.debug(this, "taskFinished", this.task.getTaskId().getID(), "Task status: " + this.status + ", Queing RunNextStepCmd [the current sequence is not the 'on finished' sequence]");
                TSEStateMapProcessor.getInstance().processCmd(new RunNextStepCmd(this.task, state, this.overrideHistoryMessage));
                return;
            }
        }
        boolean restartPendingChildren = false;
        if (this.task.getTaskRecord().getRestartId() != null) {
            try {
                if (this.status == TaskStatus.COMPLETED) {
                    int failed_child_count = TaskPersistLayer.getInstance().getCountFailedTasks(this.task.getTaskId());
                    if (failed_child_count > 0) {
                        restartPendingChildren = TaskPersistLayer.getInstance().getCountPendingTasks(this.task.getTaskId()) > 0;
                        this.status = TaskStatus.FAILED;
                        this.task.setStatus(this.status);
                        this.addMessage(new I18NMessage(MonitorI18NCode.MSG_MS_SKIPPED_HISTORY, null, SeverityEnum.error));
                    } else {
                        this.addMessage(new I18NMessage(MonitorI18NCode.MSG_MS_SKIPPED_HISTORY_SUCCESS, null, SeverityEnum.error));
                    }
                } else if (this.status == TaskStatus.FAILED) {
                    this.addMessage(new I18NMessage(MonitorI18NCode.MSG_MS_SKIPPED_HISTORY_FAIL, null, SeverityEnum.error));
                }
                int completed_child_count = TaskPersistLayer.getInstance().getCountCompletedTasks(this.task.getTaskId());
                if (completed_child_count > 0) {
                    this.addMessage(new I18NMessage(MonitorI18NCode.MSG_MS_COMPLETED_RESTART_HISTORY, null, SeverityEnum.info));
                }
            }
            catch (TaskPersistLayerException e) {
                TSE.throwException((Exception)((Object)e));
            }
        }
        if (this.doPostProcessing && state.curSeq == state.countSeq) {
            this.task.onTaskRunFinishedCmd();
        }
        while (inactiveChildren != 0) {
            if (state.updateStatus(TaskStatus.INACTIVE, state.status, state.modCount) > 0) {
                this.debug(this, "taskFinished", this.task.getTaskId().getID(), "Task state status updated to inactive");
                TaskStateRecord[] ancestors = state.findAncestors(this.task.getParentTaskId());
                for (int i = 0; i < ancestors.length; ++i) {
                    if (ancestors[i].status.equals((Object)TaskStatus.COMPLETED)) {
                        ancestors[i].updateStatus(TaskStatus.INACTIVE, TaskStatus.COMPLETED);
                        continue;
                    }
                    ancestors[i].updateStatus(TaskStatus.INACTIVE, TaskStatus.RUNNING);
                }
                this.debug(this, "taskFinished", this.task.getTaskId().getID(), "Task state status updated to inactive - returning");
                return;
            }
            if (!state.find(this.task.getTaskId())) {
                this.debug(this, "taskFinished", this.task.getTaskId().getID(), "Lost the task state [not found in the db]!");
                return;
            }
            if (state.status.isTerminatingStatus()) {
                this.debug(this, "taskFinished", this.task.getTaskId().getID(), "The task state status is terminating status - return");
                return;
            }
            inactiveChildren = historyDetails.countByStatus(TaskStatus.INACTIVE.getId());
        }
        if ((this.status == TaskStatus.COMPLETED || restartPendingChildren) && state.curSeq < state.countSeq && inactiveChildren == 0) {
            this.debug(this, "taskFinished", this.task.getTaskId().getID(), "Task status: " + this.status + ", Queing RunNextStepCmd");
            TSEStateMapProcessor.getInstance().processCmd(new RunNextStepCmd(this.task, state, this.overrideHistoryMessage));
            return;
        }
        this.task.getTaskRecord().setActualCompletionTime(new Date().getTime());
        this.task.getTaskRecord().setSdsInstanceId(TaskPersistLayer.getSdsInstance());
        this.task.getTaskRecord().update(new String[]{"ACTUAL_COMPLETION_TIME", "SDS_INSTANCE_ID"});
        this.stepFinished(state);
        if (state.parentID == null) {
            if (this.isLoggingAt(SDSLevel.DEBUG)) {
                this.debug(this, "taskFinished", this.task.getTaskId().getID(), "Queue RunCompleteCmd - parent id is null. Task id: " + this.task.getTaskId() + " , name: " + this.task.getFullName());
            }
            TSEStateMapProcessor.getInstance().processCmd(new RunCompleteCmd(this.task));
        } else if (this.updateParent) {
            this.debug(this, "taskFinished", this.task.getTaskId().getID(), "calling nextParentStep() - parent id: " + state.parentID);
            this.nextParentStep(state.parentID);
        }
    }

    void stepFinished(TaskStateRecord state) throws TaskPersistLayerException, TSEException {
        this.debug(this, "stepFinished", this.task.getTaskId().getID(), "entered stepFinished");
        Validate.stateIsTrue((this.status.isTerminatingStatus() && state.count == 0 ? 1 : 0) != 0);
        StepFinishedSQLExecute stepFinishedSqlExec = new StepFinishedSQLExecute(state);
        ISQLExecuteHandler handler = SQLExecuteHandlerFactory.getFactory().getTransactionExecuteHandler(MonitorCategory.RUNTIME);
        handler.execute((SQLExecute)stepFinishedSqlExec);
        boolean updateHistory = stepFinishedSqlExec.getUpdateHistory();
        boolean abortParentSteps = stepFinishedSqlExec.getAbortParentSteps();
        if (updateHistory) {
            if (state.stepFailed != 0 && this.overrideHistoryDetail == null) {
                this.overrideHistoryDetail = new I18NMessage[]{new I18NMessage(I18NCode.JS_EXECUTE_ERROR, null, SeverityEnum.error)};
            }
            try {
                this.debug(this, "stepFinished", this.task.getTaskId().getID(), "Writting History status : " + this.status + " , for task id : " + this.task.getTaskId().getID());
                HistoryWriter writer = this.task.getHistoryWriter();
                if (writer != null) {
                    writer.createHistory(this.status);
                }
                this.addPriorityHistoryMsgIfRequired(this.task);
                this.updateHistory(this.task, this.overrideHistoryDetail, state.parentID);
            }
            catch (Exception e) {
                this.debug(this, "stepFinished", this.task.getTaskId().getID(), "Exception updating history: " + e.getLocalizedMessage());
                TSE.logException(e);
            }
        }
        if (abortParentSteps) {
            this.debug(this, "stepFinished", this.task.getTaskId().getID(), "aborting parent steps");
            this.abortParentSteps(state.parentID);
        }
    }

    private void addPriorityHistoryMsgIfRequired(TaskRunContext taskRunContext) {
        TaskRecord taskRecord = taskRunContext.getTaskRecord();
        BiBusRunSpec runSpec = (BiBusRunSpec)taskRecord.getRunSpec();
        if (runSpec.isDefaultSchedulePriorityEnforced()) {
            this.addMessage(new I18NMessage(MonitorI18NCode.MSG_MS_SCHEDULE_PRIORITY_CAPABILITY_MISSING, new Object[]{"" + runSpec.priority}, SeverityEnum.info));
        }
    }

    void nextParentStep(TaskID parentID) throws TaskPersistLayerException, TSEException {
        TaskStateRecord parent = new TaskStateRecord();
        Validate.stateIsTrue((boolean)parent.find(parentID));
        Validate.stateIsTrue((parent.count == 0 ? 1 : 0) != 0);
        this.debug(this, "stepFinished", this.task.getTaskId().getID(), "nextParentStep sf=" + parent.stepFailed + " seqs=" + (parent.countSeq - parent.curSeq));
        if (parent.curSeq < parent.countSeq) {
            this.debug(this, "nextParentStep", this.task.getTaskId().getID(), "Queuing RunNextStepCmd");
            TSEStateMapProcessor.getInstance().queueCmd(new RunNextStepCmd(this.task, parent, this.overrideHistoryMessage));
        } else {
            this.completeParent(parent);
        }
    }

    void completeParent(TaskStateRecord parentState) throws TaskPersistLayerException, TSEException {
        this.debug(this, "completeParent", this.task.getTaskId().getID(), "completeParent() called. Parent Id: " + parentState.taskID.getID());
        TaskRecord parentTask = NCTaskQueueTable.getInstance().find(parentState.taskID, true);
        TaskRunContext parentContext = TaskRunContextFactory.createTaskRunContext(parentTask, parentState);
        parentContext.updateTaskStatus(TaskStatus.mapStatus((TaskStatus)TaskStatus.COMPLETED), this.overrideHistoryMessage);
    }

    void abortParentSteps(TaskID parentID) throws TaskPersistLayerException {
        this.debug(this, "abortParentSteps", this.task.getTaskId().getID(), "abortParentSteps() called. Parent Id: " + parentID.getID());
        TaskStateRecord parent = new TaskStateRecord();
        Validate.stateIsTrue((boolean)parent.find(parentID));
        TSEStateMapProcessor.getInstance().processCmd(new AbortStepsCmd(parent, TaskStatus.PURGED));
    }

    private void addMessage(I18NMessage message) {
        I18NMessage[] newDetail = new I18NMessage[this.overrideHistoryDetail.length + 1];
        System.arraycopy(this.overrideHistoryDetail, 0, newDetail, 0, this.overrideHistoryDetail.length);
        newDetail[this.overrideHistoryDetail.length] = message;
        this.overrideHistoryDetail = newDetail;
    }

    private class StepFinishedSQLExecute
    implements SQLExecute {
        private TaskStateRecord state;
        boolean updateHistory = false;
        boolean abortParentSteps = false;

        public StepFinishedSQLExecute(TaskStateRecord state) {
            this.state = state;
        }

        public Object execute() throws TaskPersistLayerException {
            TaskStatus locallyCachedStatus = this.state.status;
            try {
                boolean statusUpdated = false;
                while (this.state.status == TaskStatus.RUNNING || this.state.status == TaskStatus.INACTIVE) {
                    if (this.state.updateStatus(TaskRunFinishedCmd.this.status, TaskStatus.RUNNING) == 1) {
                        statusUpdated = true;
                        TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), "updating status from running to " + this.state.status);
                        continue;
                    }
                    if (this.state.updateStatus(TaskRunFinishedCmd.this.status, TaskStatus.INACTIVE) == 1) {
                        statusUpdated = true;
                        TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), "updating status from inactive to " + this.state.status);
                        continue;
                    }
                    TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), "unable to update status, checking state in db");
                    this.state.find(this.state.taskID);
                }
                if (statusUpdated) {
                    this.updateHistory = true;
                    TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), "running || inactive: updateHistory = true");
                } else {
                    this.state.find(this.state.taskID);
                    if (this.state.status == TaskStatus.CANCELLED) {
                        TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), "Resetting status => TERMINATED");
                        this.state.setStatus(TaskStatus.TERMINATED);
                    } else {
                        this.updateHistory = true;
                        TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), "!cancelled: updateHistory = true");
                    }
                }
                if (this.state.parentID != null) {
                    TaskStateRecord parentState = new TaskStateRecord();
                    parentState.taskID = this.state.parentID;
                    if (!this.state.runViaMS) {
                        if (TaskRunFinishedCmd.this.status == TaskStatus.TERMINATED || TaskRunFinishedCmd.this.status == TaskStatus.PURGED || TaskRunFinishedCmd.this.status == TaskStatus.FAILED) {
                            if (TaskRunFinishedCmd.this.status == TaskStatus.FAILED && !this.state.stopOnError) {
                                if (parentState.updateStepFailed((byte)2) == 1) {
                                    TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), "updated stepFailed STEP_FAILED_CONTINUE");
                                }
                            } else if (parentState.updateStepFailed((byte)1) == 1) {
                                TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), "updated stepFailed STEP_FAILED_ABORT");
                                this.abortParentSteps = true;
                            } else {
                                TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), "updateStepFailed - failed to update");
                            }
                        }
                        TaskRunFinishedCmd.this.updateParent = parentState.decStepCount();
                        TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), (TaskRunFinishedCmd.this.updateParent ? " LAST " : "") + " step finished ");
                        if (TaskRunFinishedCmd.this.updateParent) {
                            NCTaskQueueTable.getInstance().setSdsInstance(this.state.parentID);
                        }
                    } else {
                        TaskRunFinishedCmd.this.debug(this, "execute()", TaskRunFinishedCmd.this.task.getTaskId().getID(), "finished runvia MS child step, update parent is " + TaskRunFinishedCmd.this.updateParent);
                        parentState.decStepCount();
                    }
                }
            }
            catch (TaskPersistLayerException e) {
                this.state.status = locallyCachedStatus;
                throw e;
            }
            catch (RuntimeException e) {
                this.state.status = locallyCachedStatus;
                throw e;
            }
            return null;
        }

        public boolean getUpdateHistory() {
            return this.updateHistory;
        }

        public boolean getAbortParentSteps() {
            return this.abortParentSteps;
        }
    }
}

