/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.HistoryDetail;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.event.EventStatusInfo;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.cognos.monitor.tse.commands.TaskRunCancelledCmd;
import com.cognos.monitor.tse.commands.TaskRunFinishedCmd;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.Date;
import java.util.Locale;

public class TaskRunNotifyInactiveCmd
extends Cmd {
    private final TaskRunContext task;
    private final TaskStatus taskStatus;
    private final EventStatusInfo statusInfo;
    private final Locale locale;

    public TaskRunNotifyInactiveCmd(EventStatusInfo statusInfo, TaskRunContext task, Locale locale) {
        this.task = task;
        this.statusInfo = statusInfo;
        this.locale = locale;
        this.taskStatus = statusInfo.getEventStatus() != null && statusInfo.getEventStatus().equals((Object)EventStatus.SUCCEEDED) ? TaskStatus.COMPLETED : (statusInfo.getEventStatus() != null && statusInfo.getEventStatus().equals((Object)EventStatus.TERMINATED) ? TaskStatus.TERMINATED : TaskStatus.FAILED);
        this.debug(this, "constructor", task.getTaskId().getID(), "TaskRunNotifyInactiveCmd created - task status set to: " + this.taskStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws TaskPersistLayerException {
        block14: {
            ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TaskRunNotifyInactiveCmd.doAction");
            try {
                final TaskID taskID = this.task.getTaskId();
                TSE.trace(this, "doAction " + taskID.getID());
                if (this.statusInfo.getInfo() != null && this.statusInfo.getInfo().length > 0) {
                    TaskStateTable.StepInfo[] steps = TaskStateTable.getStatusChildren((TaskID)this.task.getTaskId(), (TaskStatus)TaskStatus.PENDING);
                    this.debug(this, "doAction", this.task.getTaskId().getID(), "Child step count:" + steps.length);
                    int skipStepCount = 0;
                    for (int i = 0; i < steps.length; ++i) {
                        TaskID t = steps[i].taskId;
                        if (!this.statusInfo.isToBeRun(t.toEventId())) {
                            this.debug(this, "doAction", this.task.getTaskId().getID(), "Child step taskID:" + t.getID() + "marked to skip run");
                            TaskHistoryDetailRecord t1 = new TaskHistoryDetailRecord(t);
                            HistoryDetail infoMessage = new HistoryDetail();
                            StringProp stringProp = new StringProp();
                            stringProp.setValue(I18NUtil.getMessage((I18NCode)MonitorI18NCode.MSG_MS_TASK_SKIPPED, (Locale)this.locale));
                            infoMessage.setDetail(stringProp);
                            Date detailTime = new Date();
                            DateTimeProp detailTimeProp = new DateTimeProp();
                            detailTimeProp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)detailTime));
                            infoMessage.setDetailTime(detailTimeProp);
                            t1.store((BaseHistoryDetail[])new HistoryDetail[]{infoMessage});
                            TaskStateRecord.setStatus((TaskID)t, (TaskStatus)TaskStatus.PURGED);
                            NCTaskQueueTable.getInstance().setStatus(t, TaskQueueStatus.FINISHED);
                            ++skipStepCount;
                            if (i != steps.length - 1) continue;
                            steps = TaskStateTable.getStatusChildren((TaskID)t, (TaskStatus)TaskStatus.PENDING);
                            i = -1;
                            continue;
                        }
                        this.debug(this, "doAction", this.task.getTaskId().getID(), "Child step taskID:" + t.getID() + "to be run");
                    }
                    TaskStateTable.StepInfo[] inactiveSiblings = TaskStateTable.getStatusSeqChildren((TaskID)this.task.getParentTaskId(), (short)this.task.getTaskState().seq, (TaskStatus)TaskStatus.INACTIVE);
                    if (inactiveSiblings.length == 0) {
                        try {
                            this.debug(this, "doAction", this.task.getTaskId().getID(), " inactiveSiblings.length == 0, so queueing TaskRunFinishedCmd");
                            TaskRunContext trc = TaskRunContextFactory.createTaskRunContext(this.task.getParentTaskId());
                            TSEStateMapProcessor.getInstance().queueCmd(new TaskRunFinishedCmd(trc, null));
                        }
                        catch (TSEException e) {
                            TaskPersistLayer.throwException((Exception)e);
                        }
                    } else {
                        this.debug(this, "doAction", this.task.getTaskId().getID(), " inactiveSiblings.length != 0, not queueing TaskRunFinishedCmd");
                    }
                } else {
                    this.debug(this, "doAction", this.task.getTaskId().getID(), "Status info not set");
                }
                SQLExecute sqlExecute = new SQLExecute(){

                    public Object execute() throws TaskPersistLayerException {
                        TaskStateRecord.setStatus((TaskID)taskID, (TaskStatus)TaskRunNotifyInactiveCmd.this.taskStatus);
                        NCTaskQueueTable.getInstance().setStatus(taskID, TaskQueueStatus.FINISHED);
                        return null;
                    }
                };
                SQLTransactionExecuteHandler transHandler = new SQLTransactionExecuteHandler(JSMCommonCategory.RUNTIME);
                transHandler.execute(sqlExecute);
                try {
                    TaskRunContext trc = TaskRunContextFactory.createTaskRunContext(taskID);
                    if (this.taskStatus.equals((Object)TaskStatus.TERMINATED)) {
                        TSEStateMapProcessor.getInstance().queueCmd(new TaskRunCancelledCmd(trc));
                        break block14;
                    }
                    TSEStateMapProcessor.getInstance().queueCmd(new TaskRunFinishedCmd(trc, null, false));
                }
                catch (TSEException e) {
                    TaskPersistLayer.throwException((Exception)e);
                }
            }
            finally {
                zipiTimer.stop();
            }
        }
    }
}

