/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.jsmcommon.sql.util.SQLExecute;
import com.cognos.jsmcommon.sql.util.SQLTransactionExecuteHandler;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.HistoryWriter;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.Date;

public final class TaskRunStartedCmd
extends Cmd {
    final TaskRunContext task;

    public TaskRunStartedCmd(TaskRunContext task) {
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws TSEException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TaskRunStartedCmd.doAction");
        try {
            TSE.trace(this, "doAction - " + this.task.getEventId().getGuid());
            try {
                final TaskRecord taskRec = this.task.getTaskRecord();
                class RunStartedSQLExecute
                implements SQLExecute {
                    boolean writeHistory = false;

                    RunStartedSQLExecute() {
                    }

                    public boolean getWriteHistory() {
                        return this.writeHistory;
                    }

                    public Object execute() throws TaskPersistLayerException {
                        if (TaskStateRecord.updateStatus((TaskID)TaskRunStartedCmd.this.task.getTaskId(), (TaskStatus)TaskStatus.RUNNING, (TaskStatus)TaskStatus.READY) == 1) {
                            if (!taskRec.getObjectClass().equals("jobDefinition")) {
                                TaskID taskId = TaskRunStartedCmd.this.task.getTaskId();
                                taskId = TaskPersistLayer.resolveRestartId((TaskID)taskId);
                                TaskStateRecord.updateExecutingCount((int)1, (TaskID)taskId);
                                TaskID parent = TaskRunStartedCmd.this.task.getParentTaskId();
                                while (parent != null) {
                                    parent = TaskPersistLayer.resolveRestartId((TaskID)parent);
                                    TaskStateRecord parentState = TaskStateRecord.findRecord((TaskID)parent);
                                    if (parentState.executing == 0) {
                                        TaskStateRecord.updateExecutingCount((int)1, (TaskID)parent);
                                        parent = parentState.parentID;
                                        continue;
                                    }
                                    parent = null;
                                }
                            }
                            taskRec.setActualExecutionTime(new Date().getTime());
                            taskRec.update(new String[]{"ACTUAL_EXECUTION_TIME", "STATUS"});
                            this.writeHistory = true;
                        } else {
                            TaskStateRecord state = new TaskStateRecord();
                            if (state.find(TaskRunStartedCmd.this.task.getTaskId()) && state.status.isTerminatingStatus()) {
                                TaskRunStartedCmd.this.task.setStatus(state.status);
                            } else {
                                TaskRunStartedCmd.this.task.setStatus(TaskStatus.FAILED);
                            }
                            TSE.trace(this, "status=>RUNNING failed, status set to " + TaskRunStartedCmd.this.task.getStatus());
                        }
                        return null;
                    }
                }
                RunStartedSQLExecute sqlExec = new RunStartedSQLExecute();
                SQLTransactionExecuteHandler handler = new SQLTransactionExecuteHandler(MonitorCategory.RUNTIME);
                handler.execute((SQLExecute)sqlExec);
                if (sqlExec.getWriteHistory()) {
                    try {
                        HistoryWriter writer = this.task.getHistoryWriter();
                        if (writer != null) {
                            writer.createHistory(TaskStatus.RUNNING);
                        }
                        this.task.onTaskRunStartedCmd();
                    }
                    catch (Exception e) {
                        TSE.trace(this, "doAction - " + this.task.getEventId().getGuid() + " " + e.getLocalizedMessage());
                        this.task.setStatus(TaskStatus.FAILED);
                        taskRec.update(new String[]{"STATUS"});
                    }
                }
                taskRec.setHistoryStoreId(this.task.getHistoryStoreID());
                taskRec.update(new String[]{"HISTORY_STORE_ID"});
            }
            catch (Exception e) {
                this.task.setFailStatus(TaskStatus.FAILED);
                TSE.throwException(e);
            }
        }
        finally {
            zipiTimer.stop();
        }
    }
}

