/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.tse.Cmd;
import com.cognos.monitor.tse.TaskRunContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;

public final class TaskStatusChangedCmd
extends Cmd {
    private final TaskRunContext task;
    private final I18NCode detail;
    private final Object[] params;
    private boolean writeMsg = true;

    public TaskStatusChangedCmd(TaskRunContext task, I18NCode detail, Object[] params) {
        this.task = task;
        this.detail = detail;
        this.params = params;
    }

    public TaskStatusChangedCmd(TaskRunContext task) {
        this(task, null, null);
        this.writeMsg = false;
    }

    @Override
    public void doAction() throws TaskPersistLayerException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TaskStatusChangedCmd.doAction");
        try {
            this.debug(this, "doAction", this.task.getTaskId().getID(), "TaskStatusChangedCmd doAction");
            try {
                if (this.task.getHistoryWriter() != null && this.writeMsg) {
                    if (this.detail == null) {
                        this.task.getHistoryWriter().updateHistoryStatus();
                    } else if (this.detail != null && this.task.getStatus() == TaskStatus.FAILED) {
                        this.task.getHistoryWriter().addErrorDetail(this.detail, this.params);
                    } else if (this.detail != null) {
                        this.task.getHistoryWriter().addInfoDetail(this.detail, this.params);
                    }
                }
                TaskStateRecord.setStatus((TaskID)this.task.getTaskId(), (TaskStatus)this.task.getStatus());
            }
            catch (Exception e) {
                TaskPersistLayer.throwException((Exception)e);
            }
        }
        finally {
            zipiTimer.stop();
        }
    }
}

