/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.commands;

import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.tse.LowPriorityCmd;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;

public final class TerminateSequenceCmd
extends LowPriorityCmd {
    final TaskStateRecord state;
    TaskStatus terminationStatus;
    I18NMessage message;
    TaskID[] steps;
    int nextStep;

    public TerminateSequenceCmd(TaskStateRecord state, TaskStatus terminationStatus, I18NMessage message) {
        this.state = state;
        this.terminationStatus = terminationStatus;
        this.message = message;
        this.nextStep = 0;
        this.setCleanup(true);
    }

    @Override
    public void doAction() throws TaskPersistLayerException, TSEException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TerminateSequenceCmd.doAction");
        try {
            TSE.trace(this, "doAction");
            if (this.steps == null) {
                this.steps = TaskStateRecord.getSeqSteps((TaskID)this.state.taskID, (int)this.state.curSeq, (TaskStatus)this.terminationStatus);
                TSE.trace(this, "Terminating " + this.steps.length + " tasks");
            }
            if (this.nextStep != this.steps.length) {
                NCTaskQueueTable.getInstance().stampSdsInstance(this.steps[this.nextStep], TaskQueueStatus.ALLOCATED, TaskQueueStatus.QUEUED);
                this.completeTask(this.steps[this.nextStep]);
                ++this.nextStep;
                if (this.nextStep != this.steps.length) {
                    TSEStateMapProcessor.getInstance().queueCmd(this);
                }
            }
        }
        finally {
            zipiTimer.stop();
        }
    }

    void completeTask(TaskID taskID) throws TSEException {
        TaskRunContext context = TaskRunContextFactory.createTaskRunContext(taskID);
        context.updateTaskStatus(TaskStatus.mapStatus((TaskStatus)this.terminationStatus), this.message);
    }
}

