/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.historyHelp;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.developer.schemas.bibus._3.HistoryDetailRelatedHistory;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.database.SdsInstanceAwareResourceLockManager;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.bursting.BurstDistribution;
import com.cognos.monitor.tse.TSE;
import java.util.ArrayList;

public class HistoryAndDetails {
    private static final AddOptions ADD_OPTIONS = new AddOptions();
    private static final BurstDistribution burstDistribution = new BurstDistribution();
    private History history;
    private ArrayList historyDetails = new ArrayList();

    public HistoryAndDetails(History history) {
        this.history = history;
    }

    public void AddDetail(BaseHistoryDetail detail) {
        this.historyDetails.add(detail);
    }

    public History getHistory() {
        return this.history;
    }

    public BaseHistoryDetail[] getHistoryDetails() {
        return this.historyDetails.toArray(new BaseHistoryDetail[this.historyDetails.size()]);
    }

    public String getHistoryStoreId() {
        return this.history == null ? null : this.history.getStoreID().getValue().get_value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(JobBiBusHeaders headers, boolean signRequests) throws SDKClientException, EMFSecurityException {
        ContentManagerServiceClientPort port = null;
        try {
            port = Client.instance().getContentManagerServiceClient(headers);
            port.setLogCategory(MonitorCategory.RUNTIME);
            this.add(port, signRequests);
        }
        finally {
            if (port != null) {
                port.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockedAddHistory(ContentManagerServiceClientPort port, boolean signRequests) throws SDKClientException, EMFSecurityException {
        ResourceLock historyLock = null;
        String resource = this.getHistoryWriteLockResourceKey();
        if (resource != null) {
            while (historyLock == null || !historyLock.isLocked()) {
                try {
                    SdsInstanceAwareResourceLockManager instanceLockManager = SdsInstanceAwareResourceLockManager.instance();
                    historyLock = instanceLockManager.getResourceLock(resource);
                    historyLock.lock();
                }
                catch (ResourceLockException e) {
                    TSE.trace("failed to lock for history write: " + e.getLocalizedMessage());
                }
            }
        }
        try {
            this.history.setDefaultName(null);
            if (signRequests) {
                port.getBiBusHeader().setCAM(null);
                port.signNextRequest("JSM");
            }
            BaseClass[] bases = port.add(null, new BaseClass[]{this.history}, ADD_OPTIONS);
            this.traceHistoryCreation(bases);
            History createdHistory = (History)ObjectModelUtil.getBaseClass((BaseClass[])bases, (int)0);
            if (createdHistory != null) {
                this.history = createdHistory;
            }
        }
        finally {
            if (historyLock != null) {
                try {
                    historyLock.unlock();
                }
                catch (ResourceLockException e) {
                    TSE.trace("failed to lock for history write: " + e.getLocalizedMessage());
                }
            }
        }
    }

    private String getHistoryWriteLockResourceKey() {
        boolean doLock = false;
        String resourceLock = null;
        try {
            doLock = Boolean.valueOf(CRNProperties.getInstance().getProperty("advanced.history.write.lock"));
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        if (doLock && this.history != null) {
            String string = resourceLock = this.history.getSearchPath() != null ? this.history.getSearchPath().getValue() : null;
            if (resourceLock == null || resourceLock.length() == 0) {
                String string2 = resourceLock = this.history.getOwnerEventID() != null ? this.history.getOwnerEventID().getValue() : null;
            }
            if (resourceLock != null && resourceLock.length() == 0) {
                resourceLock = null;
            }
        }
        return resourceLock;
    }

    public void add(ContentManagerServiceClientPort port, boolean signRequests) throws SDKClientException, EMFSecurityException {
        BaseHistoryDetail[] details = this.getHistoryDetails();
        CAM cam = null;
        boolean setCam = false;
        BiBusHeader header = port.getBiBusHeader();
        if (header != null) {
            cam = header.getCAM();
            setCam = true;
        }
        if (this.history != null) {
            this.lockedAddHistory(port, signRequests);
            StringProp historyPath = ObjectModelUtil.makeStringProp((String)ObjectModelUtil.getSearchPath((Guid)this.history.getStoreID().getValue()).get_value());
            for (int i = 0; i < details.length; ++i) {
                details[i].setDefaultName(null);
                if (details[i] instanceof HistoryDetailRelatedHistory) continue;
                details[i].setSearchPath(historyPath);
            }
        }
        if (signRequests) {
            port.getBiBusHeader().setCAM(null);
            port.signNextRequest("JSM");
        }
        port.add(null, (BaseClass[])details, ADD_OPTIONS);
        if (setCam && (header = port.getBiBusHeader()) != null) {
            header.setCAM(cam);
        }
    }

    private void traceHistoryCreation(BaseClass[] bases) {
        if (!TSE.isTrace()) {
            return;
        }
        for (int i = 0; i < bases.length; ++i) {
            if (!(bases[i] instanceof History)) continue;
            TSE.trace(bases[i].getSearchPath().getValue() + "-->" + ((History)bases[i]).getEventID().getValue());
        }
    }

    public void addChildHistory(ContentManagerServiceClientPort port) throws SDKClientException, EMFSecurityException {
        if (!burstDistribution.canDiscardChildHistoryDetails(this.getHistoryDetails())) {
            this.add(port, true);
        }
    }

    static {
        ADD_OPTIONS.setIgnoreInvalidObjectReference(true);
        ADD_OPTIONS.setReturnProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.storeID, PropEnum.eventID});
    }
}

