/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.run;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.http.HTTPRequest;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.Headers;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.tse.run.BusCaller;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class BusCallerImpl
implements BusCaller {
    private HTTPRequest request;

    public HTTPRequest getRequest() {
        return this.request;
    }

    @Override
    public Node callServerMethod(Headers headers, String soapAction, String body) throws Exception {
        this.request = new HTTPRequest(soapAction);
        Element bodyNode = null;
        try {
            BIBusEnvelope biBusEnvelope = this.getHeadedEnvelope(headers.getBiBusHeader(), headers.getExtraHeaders());
            if (body != null && body.length() > 0) {
                try {
                    Document document = DocumentHelper.parseText((String)body);
                    biBusEnvelope.getHeader().add(headers.getReplyToElement().detach());
                    biBusEnvelope.getBody().add(document.getRootElement().detach());
                }
                catch (DocumentException e) {
                    throw new Exception("Error parsing result.", e);
                }
            }
            StringWriter aWriter = new StringWriter();
            OutputFormat format = new OutputFormat();
            format.setNewLineAfterDeclaration(false);
            XMLWriter xmlWriter = new XMLWriter((Writer)aWriter, format);
            xmlWriter.write(biBusEnvelope.getAsDocument());
            xmlWriter.flush();
            this.request.setRequestBody(aWriter.toString());
            String response = this.request.retrieveContent();
            BIBusEnvelope responseEnvelope = null;
            responseEnvelope = new BIBusEnvelope((Reader)new StringReader(response));
            if (responseEnvelope.getFaultString() != null) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug(responseEnvelope.toString());
                throw new MonitorServiceException(MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{responseEnvelope});
            }
            bodyNode = responseEnvelope.getBody();
            if (bodyNode != null) {
                bodyNode = bodyNode.selectSingleNode("./*[1]");
            }
        }
        catch (Throwable e) {
            throw new Exception("bus caller failed with URL " + this.request.getURL(), e);
        }
        return bodyNode;
    }

    public BIBusEnvelope getHeadedEnvelope(BiBusHeader header, List<Element> extraHeaders) {
        BIBusEnvelope envelope = BiBusUtilities.getHeadedEnvelope((BiBusHeader)header);
        Document headerDoc = envelope.getHeader().getDocument();
        for (Element element : extraHeaders) {
            element.setDocument(headerDoc);
            envelope.getHeader().add(element);
        }
        return envelope;
    }
}

