/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.run.commands;

import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.IJobLogger;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.tse.run.commands.LogJobCmdSpec;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.monitor.impl.state.RecordableException;
import com.cognos.monitor.tse.BiBusRunContext;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.run.commands.RunCommand;
import java.util.Locale;

public class LogJobCommand
extends RunCommand {
    public static final String JOB_SERVICE_STRING = "jobService";
    private IJobLogger _logger;

    public LogJobCommand(IJobLogger logger) {
        super(LogJobCmdSpec.class);
        this._logger = logger;
    }

    @Override
    public void postRun(TaskRunContext task, CmdSpec cmd) throws SDKClientException, TSEException, TaskPersistLayerException {
        super.postRun(task, cmd);
        if (task instanceof BiBusRunContext) {
            BiBusRunContext context = (BiBusRunContext)task;
            String error = null;
            if (TaskStatus.FAILED.equals((Object)context.getStatus()) && (error = context.getFault()) == null) {
                Locale locale = context.getHeader().getProductLocale();
                error = I18NUtil.getMessage((I18NCode)I18NCode.MSG_STEP_ERROR, null, (Locale)LocaleUtil.createProductLocale((String)locale.toString()));
            }
            if (context.getParentTaskId() != null) {
                this._logger.logStepEnd(context.getTaskId(), context.getParentTaskId(), context.getBiBusRunSpec().searchPath, context.getHeader().getBiBusHeader(), context.getStatus(), error);
            }
            if (JOB_SERVICE_STRING.equals(context.getServiceName())) {
                this._logger.logJobEnd(context.getTaskId(), context.getBiBusRunSpec().searchPath, context.getHeader().getBiBusHeader(), context.getStatus(), error);
            }
        }
    }

    @Override
    public void preRun(TaskRunContext task, CmdSpec cmd) throws SDKClientException, TSEException, TaskPersistLayerException, RecordableException {
        super.preRun(task, cmd);
        if (task instanceof BiBusRunContext) {
            BiBusRunContext context = (BiBusRunContext)task;
            ParameterValue[] params = context.getBiBusRunSpec().parameters;
            Option[] options = context.getBiBusRunSpec().options;
            if (context.getParentTaskId() != null) {
                this._logger.logStepStart(context.getTaskId(), context.getParentTaskId(), context.getBiBusRunSpec().searchPath, context.getHeader().getBiBusHeader(), params, options);
            }
            if (JOB_SERVICE_STRING.equals(context.getServiceName())) {
                this._logger.logJobSubmit(context.getTaskId(), context.getBiBusRunSpec().searchPath, context.getHeader().getBiBusHeader(), params, options);
            }
        }
    }
}

