/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.run.commands;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportOutput;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.ReportVersion;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskPropertyRecord;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.tse.run.commands.SaveReportPathCmdSpec;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.run.commands.RunCommand;

public final class SaveReportPathCommand
extends RunCommand {
    SaveReportPathCommand() {
        super(SaveReportPathCmdSpec.class);
    }

    @Override
    public void postConversation(TaskRunContext task, CmdSpec arg, AsynchReply asynchReply) throws SDKClientException, TaskPersistLayerException {
        if (asynchReply != null) {
            SaveReportPathCmdSpec cmd = (SaveReportPathCmdSpec)arg;
            ReportVersion version = this.getReportVersion(asynchReply);
            if (version != null && cmd.reportVar != null) {
                SearchPathSingleObject storeID = ObjectModelUtil.getSearchPath((Guid)version.getStoreID().getValue());
                TaskPropertyRecord.setProperty((TaskID)new TaskID(cmd.taskID), (String)cmd.reportVar, (Object)storeID.get_value());
            } else {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("SaveReportPathCommand: ReportVersion is null");
            }
        }
    }

    private ReportVersion getReportVersion(AsynchReply reply) {
        BaseClass baseClass = null;
        if (null != reply.getDetails() && reply.getDetails().length > 0) {
            for (int i = 0; i < reply.getDetails().length; ++i) {
                AsynchDetail detail = reply.getDetails()[i];
                if (!(detail instanceof AsynchDetailReportOutput)) continue;
                BaseClass[] bc = ((AsynchDetailReportOutput)detail).getOutputObjects();
                for (int j = 0; !(j >= bc.length || (baseClass = bc[i]) instanceof ReportVersion && baseClass.getSearchPath() != null); ++j) {
                }
            }
        }
        return (ReportVersion)baseClass;
    }
}

