/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse.run.commands;

import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.tse.run.commands.SetHistoryParametersCmdSpec;
import com.cognos.monitor.impl.state.RecordableException;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEParameter;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.run.commands.RunCommand;

public final class SetHistoryParametersCommand
extends RunCommand {
    SetHistoryParametersCommand() {
        super(SetHistoryParametersCmdSpec.class);
    }

    @Override
    public void preRun(TaskRunContext task, CmdSpec arg) throws TSEException, TaskPersistLayerException, RecordableException {
        if (task.getHistoryWriter() != null) {
            BiBusRunSpec runSpec = (BiBusRunSpec)task.getTaskRecord().getRunSpec();
            for (int i = 0; i != runSpec.parameters.length; ++i) {
                this.doParam(task, runSpec.parameters[i]);
            }
        }
    }

    public void doParam(TaskRunContext task, ParameterValue param) throws TSEException, RecordableException {
        if (param.getValue() != null && param.getValue().length > 0) {
            ParmValueItem[] paramValues = param.getValue();
            String displayHistoryTopic = ((SimpleParmValueItem)paramValues[0]).getDisplay();
            TSEParameter tseParam = task.getTseParameterValue(displayHistoryTopic);
            this.doSetValues(task, param.getValue(), tseParam);
        }
    }

    public void doSetValues(TaskRunContext task, ParmValueItem[] items, TSEParameter tseParam) throws TSEException, RecordableException {
        for (int i = 0; i != items.length; ++i) {
            if (!(items[i] instanceof SimpleParmValueItem)) continue;
            SimpleParmValueItem simpleVal = (SimpleParmValueItem)items[i];
            if (tseParam == null) {
                tseParam = task.getTseParameterValue(simpleVal.getDisplay());
            }
            if (tseParam == null) break;
            simpleVal.setDisplay(tseParam.getDisplayValue());
            simpleVal.setUse(tseParam.getUseValue());
        }
    }
}

