/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.util;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.CommonHistoryHelper;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.impl.state.HistoryRecord;
import com.cognos.sds.event.IEventId;
import noticecast.services.soap.cm.CMSearchPathGenerator;

public class HistoryHelper {
    public static HistoryRecord getHistoryRecord(IEventId id) {
        BiBusHeader header = new BiBusHeader();
        return HistoryHelper.getHistoryRecord(id, header);
    }

    public static HistoryRecord getHistoryRecord(IEventId id, BiBusHeader biBusHeader) {
        String path = CMSearchPathGenerator.historyPath(id);
        HistoryRecord historyRecord = null;
        biBusHeader.setTracking(new Tracking());
        History history = CommonHistoryHelper.getHistoryFromCM((String)path, (BiBusHeader)biBusHeader);
        if (history != null) {
            historyRecord = new HistoryRecord(history, new JobBiBusHeaders(biBusHeader));
            historyRecord.setUseTrusted(true);
        }
        return historyRecord;
    }

    public static boolean markFailed(IEventId id, I18NCode reason) {
        return HistoryHelper.markFailed(id, reason, new Object[0]);
    }

    public static boolean markFailed(IEventId id, I18NCode reason, Object[] reasonParams) {
        boolean updated = true;
        HistoryRecord historyRecord = HistoryHelper.getHistoryRecord(id);
        try {
            if (historyRecord != null) {
                EventStatus eventStatus = historyRecord.getStatus();
                if (eventStatus.equals((Object)EventStatus.EXECUTING)) {
                    historyRecord.addErrorDetail(reason, reasonParams);
                    historyRecord.update(EventStatus.FAILED);
                } else if (eventStatus.equals((Object)EventStatus.PENDING) || eventStatus.equals((Object)EventStatus.SUSPENDED) || eventStatus.equals((Object)EventStatus.INACTIVE)) {
                    historyRecord.addErrorDetail(reason, reasonParams);
                    historyRecord.update(EventStatus.PURGED);
                } else {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Cannot update a history status to failed or purged [history.eventID:" + id.toString() + "], current status is " + eventStatus.toString() + ". Deleting associated persistedRecord");
                }
            } else {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[HistoryHelper.markFailed()] No history found with event id [" + id.toXMLString() + "] in CM. Unable to clean up failed history in CM.");
                updated = false;
            }
        }
        catch (Throwable ex) {
            updated = false;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug(ex);
        }
        return updated;
    }

    public static EventStatus getHistoryStatus(IEventId event) {
        String path = CMSearchPathGenerator.historyPath(event);
        History history = CommonHistoryHelper.getHistoryFromCM((String)path, (BiBusHeader)new BiBusHeader());
        return history == null ? null : EventStatus.valueOf((String)history.getStatus().getValue());
    }
}

