/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.adapter;

public class Duration {
    int m_years = 0;
    int m_months = 0;
    int m_weeks = 0;
    int m_days = 0;
    int m_hours = 0;
    int m_minutes = 0;
    int m_seconds = 0;

    public Duration(String durationString) throws IllegalStateException {
        this.parse(durationString);
    }

    private void parse(String durationString) throws IllegalStateException {
        int currentIndex = 0;
        int digitCount = 0;
        boolean isTime = false;
        for (int i = 0; i < durationString.length(); ++i) {
            char currentChar = durationString.charAt(currentIndex);
            if (Character.isDigit(currentChar)) {
                ++digitCount;
            } else {
                switch (currentChar) {
                    case 'P': {
                        digitCount = 0;
                        break;
                    }
                    case 'T': {
                        isTime = true;
                        digitCount = 0;
                        break;
                    }
                    case 'Y': {
                        if (digitCount <= 0) break;
                        this.m_years = Integer.parseInt(durationString.substring(currentIndex - digitCount, currentIndex));
                        break;
                    }
                    case 'W': {
                        if (digitCount <= 0) break;
                        this.m_weeks = Integer.parseInt(durationString.substring(currentIndex - digitCount, currentIndex));
                        break;
                    }
                    case 'D': {
                        if (digitCount <= 0) break;
                        this.m_days = Integer.parseInt(durationString.substring(currentIndex - digitCount, currentIndex));
                        break;
                    }
                    case 'H': {
                        if (digitCount <= 0) break;
                        this.m_hours = Integer.parseInt(durationString.substring(currentIndex - digitCount, currentIndex));
                        break;
                    }
                    case 'M': {
                        if (digitCount <= 0) break;
                        if (isTime) {
                            this.m_minutes = Integer.parseInt(durationString.substring(currentIndex - digitCount, currentIndex));
                            break;
                        }
                        this.m_months = Integer.parseInt(durationString.substring(currentIndex - digitCount, currentIndex));
                        break;
                    }
                    case 'S': {
                        if (digitCount <= 0) break;
                        this.m_seconds = Integer.parseInt(durationString.substring(currentIndex - digitCount, currentIndex));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported duration format");
                    }
                }
                digitCount = 0;
            }
            ++currentIndex;
        }
    }

    public int getYears() {
        return this.m_years;
    }

    public int getMonths() {
        return this.m_months;
    }

    public int getWeeks() {
        return this.m_weeks;
    }

    public int getDays() {
        return this.m_days;
    }

    public int getHours() {
        return this.m_hours;
    }

    public int getMinutes() {
        return this.m_minutes;
    }

    public int getSeconds() {
        return this.m_seconds;
    }
}

