/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.adapter;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.BooleanProp;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ClassEnumProp;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.DurationProp;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.IntProp;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.NmtokenProp;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.PositiveIntegerProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.RunOptionArrayProp;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TimeProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.jms.ChannelType;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.sds.adapter.Duration;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import noticecast.accesscontrol.CMVersion;
import noticecast.services.soap.cm.CMSearchPathGenerator;
import org.apache.axis.types.Time;

public class ScheduleAdapter {
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final String REPEAT_FOREVER = "indefinite";
    private Schedule schedule;
    private BaseClass m_parentTask;
    private boolean m_deleteAfterLastRun;
    private ChannelType m_deliveryChannelType;
    private String m_command;
    private String m_credentialSearchPath;
    private String m_credentialOwnerStoreId = null;

    public ScheduleAdapter(Schedule schedule) {
        this.schedule = schedule;
        this.m_parentTask = this.getScheduleParent();
    }

    public ScheduleAdapter() {
        this(new Schedule());
        this.m_parentTask = new Nil();
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public boolean getActive() {
        return this.schedule.getActive() != null ? this.schedule.getActive().isValue() : false;
    }

    public void setActive(boolean active) {
        this.schedule.setActive(this.getBooleanProp(active));
    }

    public String getDailyPeriod() {
        return this.schedule.getDailyPeriod().getValue();
    }

    public void setDailyPeriod(String dailyPeriod) {
        this.schedule.setDailyPeriod(this.getNmtokenProp(dailyPeriod));
    }

    public Date getEndDate() {
        if (this.schedule.getEndDate() == null) {
            return null;
        }
        Calendar cal = this.schedule.getEndDate().getValue();
        if (cal == null) {
            return null;
        }
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        return cal.getTime();
    }

    public void setEndDate(Date endDate) {
        if (endDate != null) {
            Calendar cal = TimeUtils.dateToUTCJavaCalendar((Date)endDate);
            this.schedule.setEndDate(this.getDateTimeProp(cal));
        } else {
            this.schedule.setEndDate(this.getDateTimeProp(null));
        }
    }

    public boolean getEndType() {
        String endType = this.schedule.getEndType() != null ? this.schedule.getEndType().getValue() : "";
        return endType.equals(REPEAT_FOREVER);
    }

    public void setEndType(boolean endType) {
        if (endType) {
            this.schedule.setEndType(this.getNmtokenProp(REPEAT_FOREVER));
        }
    }

    public int getEveryNPeriods() {
        return this.schedule.getEveryNPeriods() != null ? this.schedule.getEveryNPeriods().getValue().intValue() : 0;
    }

    public void setEveryNPeriods(int everyNPeriods) {
        this.schedule.setEveryNPeriods(this.getPositiveIntegerProp(Integer.toString(everyNPeriods)));
    }

    public int getIntradayRecurrenceEnd() {
        int totalInSeconds = 0;
        TimeProp timeProp = this.schedule.getIntradayRecurrenceEnd();
        if (timeProp == null || timeProp.getValue() == null) {
            return 0;
        }
        Time time = timeProp.getValue();
        Calendar cal = time.getAsCalendar();
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        totalInSeconds = hours * 3600 + minutes * 60 + seconds;
        return totalInSeconds;
    }

    public int getIntradayRecurrenceInterval() {
        int totalDurationInSeconds = 0;
        DurationProp durationProp = this.schedule.getIntradayRecurrenceInterval();
        if (durationProp == null || durationProp.getValue() == null) {
            return 0;
        }
        String durationString = durationProp.getValue();
        Duration duration = new Duration(durationString);
        duration.getHours();
        int hours = duration.getHours();
        int minutes = duration.getMinutes();
        int seconds = duration.getSeconds();
        totalDurationInSeconds = hours * 3600 + minutes * 60 + seconds;
        return totalDurationInSeconds;
    }

    public int getIntradayRecurrenceStart() {
        int totalInSeconds = 0;
        TimeProp timeProp = this.schedule.getIntradayRecurrenceStart();
        if (timeProp == null || timeProp.getValue() == null) {
            return 0;
        }
        Time time = timeProp.getValue();
        Calendar cal = time.getAsCalendar();
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        totalInSeconds = hours * 3600 + minutes * 60 + seconds;
        return totalInSeconds;
    }

    public int getMonthlyAbsoluteDay() {
        return this.schedule.getMonthlyAbsoluteDay().getValue().intValue();
    }

    public void setMonthlyAbsoluteDay(int monthlyAbsoluteDay) {
        this.schedule.setMonthlyAbsoluteDay(this.getPositiveIntegerProp(Integer.toString(monthlyAbsoluteDay)));
    }

    public String getMonthlyRelativeDay() {
        return this.schedule.getMonthlyRelativeDay().getValue();
    }

    public void setMonthlyRelativeDay(String monthlyRelativeDay) {
        this.schedule.setMonthlyRelativeDay(this.getNmtokenProp(monthlyRelativeDay));
    }

    public String getMonthlyRelativeWeek() {
        return this.schedule.getMonthlyRelativeWeek().getValue();
    }

    public void setMonthlyRelativeWeek(String monthlyRelativeWeek) {
        this.schedule.setMonthlyRelativeWeek(this.getNmtokenProp(monthlyRelativeWeek));
    }

    public com.cognos.i18n.Calendar getNextRunTime() {
        return com.cognos.i18n.Calendar.getInstance();
    }

    public void setNextRunTime(com.cognos.i18n.Calendar nextRunTime) {
    }

    public Date getStartDate() {
        Calendar cal = this.schedule.getStartDate() != null ? this.schedule.getStartDate().getValue() : null;
        Date date = null;
        if (cal != null) {
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            date = cal.getTime();
        }
        return date;
    }

    public void setStartDate(Date startDate) {
        Calendar cal = TimeUtils.dateToUTCJavaCalendar((Date)startDate);
        this.schedule.setStartDate(this.getDateTimeProp(cal));
    }

    public String getTaskID() {
        return this.schedule.getTaskID() != null ? this.schedule.getTaskID().getValue() : null;
    }

    public void setTaskID(String taskID) {
        this.schedule.setTaskID(this.getTokenProp(taskID));
    }

    public String getTimeZoneID() {
        String tzString = null;
        if (this.schedule.getTimeZoneID() != null) {
            tzString = this.schedule.getTimeZoneID().getValue();
        }
        return tzString;
    }

    public void setTimeZoneID(String timeZoneID) {
        this.schedule.setTimeZoneID(this.getStringProp(timeZoneID));
    }

    public void setTrigger(String triggerID) {
        this.schedule.setTriggerName(this.getStringProp(triggerID));
    }

    public String getTrigger() {
        return this.schedule.getTriggerName() != null ? this.schedule.getTriggerName().getValue() : null;
    }

    public void setPeriodicalProducer(String producerID) {
        BaseClassArrayProp baseClassArrayProp = new BaseClassArrayProp();
        Nil nil = new Nil();
        GuidProp guidProp = new GuidProp();
        Guid guid = new Guid();
        guid.set_value(producerID);
        guidProp.setValue(guid);
        nil.setStoreID(guidProp);
        baseClassArrayProp.setValue(new BaseClass[]{nil});
        this.schedule.setPeriodicalProducer(baseClassArrayProp);
    }

    public String getPeriodicalProducer() {
        return this.schedule.getPeriodicalProducer() != null ? this.schedule.getPeriodicalProducer().getValue()[0].getStoreID().getValue().get_value() : null;
    }

    public String getType() {
        return this.schedule.getType() != null ? this.schedule.getType().getValue() : "";
    }

    public void setType(String type) {
        this.schedule.setType(this.getNmtokenProp(type));
    }

    public boolean getWeeklyFriday() {
        return this.schedule.getWeeklyFriday().isValue();
    }

    public void setWeeklyFriday(boolean weeklyFriday) {
        this.schedule.setWeeklyFriday(this.getBooleanProp(weeklyFriday));
    }

    public boolean getWeeklyMonday() {
        return this.schedule.getWeeklyMonday().isValue();
    }

    public void setWeeklyMonday(boolean weeklyMonday) {
        this.schedule.setWeeklyMonday(this.getBooleanProp(weeklyMonday));
    }

    public CMVersion getVersion() {
        CMVersion cmVersion = null;
        if (this.schedule.getVersion() != null) {
            cmVersion = new CMVersion(this.schedule.getVersion().getValue());
        }
        return cmVersion;
    }

    public void setCmVersion(CMVersion ver) {
        PositiveIntegerProp prop = new PositiveIntegerProp();
        prop.setValue(ver.getBigVersion());
        this.schedule.setVersion(prop);
    }

    public boolean getWeeklySaturday() {
        return this.schedule.getWeeklySaturday().isValue();
    }

    public void setWeeklySaturday(boolean weeklySaturday) {
        this.schedule.setWeeklySaturday(this.getBooleanProp(weeklySaturday));
    }

    public boolean getWeeklySunday() {
        return this.schedule.getWeeklySunday().isValue();
    }

    public void setWeeklySunday(boolean weeklySunday) {
        this.schedule.setWeeklySunday(this.getBooleanProp(weeklySunday));
    }

    public boolean getWeeklyThursday() {
        return this.schedule.getWeeklyThursday().isValue();
    }

    public void setWeeklyThursday(boolean weeklyThursday) {
        this.schedule.setWeeklyThursday(this.getBooleanProp(weeklyThursday));
    }

    public boolean getWeeklyTuesday() {
        return this.schedule.getWeeklyTuesday().isValue();
    }

    public void setWeeklyTuesday(boolean weeklyTuesday) {
        this.schedule.setWeeklyTuesday(this.getBooleanProp(weeklyTuesday));
    }

    public boolean getWeeklyWednesday() {
        return this.schedule.getWeeklyWednesday().isValue();
    }

    public void setWeeklyWednesday(boolean weeklyWednesday) {
        this.schedule.setWeeklyWednesday(this.getBooleanProp(weeklyWednesday));
    }

    public int getYearlyAbsoluteDay() {
        return this.schedule.getYearlyAbsoluteDay().getValue().intValue();
    }

    public void setYearlyAbsoluteDay(int yearlyAbsoluteDay) {
        this.schedule.setYearlyAbsoluteDay(this.getPositiveIntegerProp(Integer.toString(yearlyAbsoluteDay)));
    }

    public String getYearlyAbsoluteMonth() {
        return this.schedule.getYearlyAbsoluteMonth().getValue();
    }

    public void setYearlyAbsoluteMonth(String yearlyAbsoluteMonth) {
        this.schedule.setYearlyAbsoluteMonth(this.getNmtokenProp(yearlyAbsoluteMonth));
    }

    public String getYearlyRelativeDay() {
        return this.schedule.getYearlyRelativeDay().getValue();
    }

    public void setYearlyRelativeDay(String yearlyRelativeDay) {
        this.schedule.setYearlyRelativeDay(this.getNmtokenProp(yearlyRelativeDay));
    }

    public String getYearlyRelativeMonth() {
        return this.schedule.getYearlyRelativeMonth().getValue();
    }

    public void setYearlyRelativeMonth(String yearlyRelativeMonth) {
        this.schedule.setYearlyRelativeMonth(this.getNmtokenProp(yearlyRelativeMonth));
    }

    public String getYearlyRelativeWeek() {
        return this.schedule.getYearlyRelativeWeek().getValue();
    }

    public void setYearlyRelativeWeek(String yearlyRelativeWeek) {
        this.schedule.setYearlyRelativeWeek(this.getNmtokenProp(yearlyRelativeWeek));
    }

    public String getCommand() {
        return this.m_command;
    }

    public BaseClassArrayProp getCredential() {
        return this.schedule.getCredential();
    }

    public void setCommand(String command) {
        this.m_command = command;
    }

    public void setCredential(BaseClassArrayProp credential) {
        this.schedule.setCredential(credential);
    }

    public ParameterValueArrayProp getParameters() {
        return this.schedule.getParameters();
    }

    public void setParameters(ParameterValueArrayProp parameters) {
        this.schedule.setParameters(parameters);
    }

    public RunOptionArrayProp getRunOptions() {
        return this.schedule.getRunOptions();
    }

    public void setRunOptions(RunOptionArrayProp runOptions) {
        this.schedule.setRunOptions(runOptions);
    }

    private BooleanProp getBooleanProp(boolean value) {
        BooleanProp prop = new BooleanProp();
        prop.setValue(value);
        return prop;
    }

    public PositiveIntegerProp getPositiveIntegerProp(String value) {
        PositiveIntegerProp prop = new PositiveIntegerProp();
        prop.setValue(new BigInteger(value));
        return prop;
    }

    public NmtokenProp getNmtokenProp(String value) {
        NmtokenProp prop = new NmtokenProp();
        prop.setValue(value);
        return prop;
    }

    private DateTimeProp getDateTimeProp(Calendar value) {
        DateTimeProp prop = new DateTimeProp();
        prop.setValue(value);
        return prop;
    }

    public TokenProp getTokenProp(String value) {
        TokenProp prop = new TokenProp();
        prop.setValue(value);
        return prop;
    }

    public StringProp getStringProp(String value) {
        StringProp prop = new StringProp();
        prop.setValue(value);
        return prop;
    }

    public String getCredentialSearchPath() {
        return this.m_credentialSearchPath;
    }

    public boolean getDeleteAfterLastRun() {
        return this.m_deleteAfterLastRun;
    }

    public void setDeleteAfterLastRun(boolean deleteAfterLastRun) {
        this.m_deleteAfterLastRun = deleteAfterLastRun;
    }

    public void setCredentialSearchPath(String path) {
        this.m_credentialSearchPath = path;
    }

    public ChannelType getDeliveryChannelType() {
        return this.m_deliveryChannelType;
    }

    public void setDeliveryChannelType(ChannelType deliveryChannelType) {
        this.m_deliveryChannelType = deliveryChannelType;
    }

    public void setPriority(int priority) {
        IntProp intProp = new IntProp();
        intProp.setValue(priority);
        this.schedule.setPriority(intProp);
    }

    public int getPriority() {
        int priority = 3;
        IntProp intProp = this.schedule.getPriority();
        if (intProp != null) {
            priority = intProp.getValue();
        }
        return priority;
    }

    public String getScheduledByStoreID() {
        if (this.m_credentialOwnerStoreId != null) {
            return this.m_credentialOwnerStoreId;
        }
        String credPath = this.getCredentialSearchPath();
        if (credPath != null) {
            PropEnum[] props = new PropEnum[]{PropEnum.storeID};
            String path = CMSearchPathGenerator.getParent(credPath);
            BaseClass[] baseClasses = this.sendSignedRequest(path, props);
            if (baseClasses != null && baseClasses.length > 0) {
                this.m_credentialOwnerStoreId = ObjectModelUtil.getGuidPropValue((GuidProp)baseClasses[0].getStoreID());
            }
        }
        return this.m_credentialOwnerStoreId;
    }

    public void setOwnerStoreID(String guidString) {
        this.m_credentialOwnerStoreId = guidString;
    }

    public String getParentStoreID() {
        BaseClass[] value;
        String parentStoreID = null;
        if (this.schedule.getParent() != null && (value = this.schedule.getParent().getValue()) != null && value.length > 0 && value[0].getSearchPath() != null) {
            parentStoreID = value[0].getStoreID().getValue().get_value();
        }
        return parentStoreID;
    }

    public String getParentOwnerStoreID() {
        String ownerStoreID = null;
        if (this.m_parentTask != null && this.m_parentTask.getOwner() != null && this.m_parentTask.getOwner().getValue() != null && this.m_parentTask.getOwner().getValue().length > 0) {
            BaseClass owner = this.m_parentTask.getOwner().getValue()[0];
            ownerStoreID = owner.getStoreID().getValue().get_value();
        }
        return ownerStoreID;
    }

    public void setParentOwnerStoreID(String parentOwnerStoreId) {
        Guid guid = new Guid();
        guid.set_value(parentOwnerStoreId);
        GuidProp guidProp = new GuidProp();
        guidProp.setValue(guid);
        Account ownerAccount = new Account();
        ownerAccount.setStoreID(guidProp);
        BaseClass[] ownerArray = new BaseClass[]{ownerAccount};
        BaseClassArrayProp bcap = new BaseClassArrayProp();
        bcap.setValue(ownerArray);
        this.m_parentTask.setOwner(bcap);
    }

    public String getParentObjectClass() {
        String objectClass = null;
        if (this.m_parentTask != null && this.m_parentTask.getObjectClass() != null) {
            objectClass = this.m_parentTask.getObjectClass().getValue().getValue();
        }
        return objectClass;
    }

    public void setParentObjectClass(ClassEnum classEnum) {
        ClassEnumProp classEnumProp = new ClassEnumProp();
        classEnumProp.setValue(classEnum);
        this.m_parentTask.setObjectClass(classEnumProp);
    }

    private BaseClass getScheduleParent() {
        PropEnum[] props;
        BaseClass parentObject = null;
        String parentStoreID = this.getParentStoreID();
        if (parentStoreID == null) {
            return null;
        }
        String parentStoreIDSearchPath = "storeID(\"" + parentStoreID + "\")";
        BaseClass[] baseClasses = this.sendSignedRequest(parentStoreIDSearchPath, props = new PropEnum[]{PropEnum.searchPath, PropEnum.objectClass, PropEnum.owner});
        if (baseClasses != null && baseClasses.length >= 1) {
            parentObject = baseClasses[0];
        }
        return parentObject;
    }

    private JobBiBusHeaders getTrustedReadyHeader() {
        BiBusHeader header = new BiBusHeader();
        Tracking tracking = new Tracking();
        header.setTracking(tracking);
        return new JobBiBusHeaders(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseClass[] sendSignedRequest(String path, PropEnum[] props) {
        JobBiBusHeaders headers = this.getTrustedReadyHeader();
        ContentManagerServiceClientPort port = null;
        BaseClass[] baseClasses = null;
        try {
            port = Client.instance().getContentManagerServiceClient(headers);
            port.setLogCategory(EventManagementCategory.RUNTIME);
            port.signNextRequest("JSM", false);
            baseClasses = port.query(new SearchPathMultipleObject(path), props, null, new QueryOptions());
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
        }
        finally {
            if (port != null) {
                port.close();
            }
        }
        return baseClasses;
    }

    public void setTenantId(String tenantId) {
        this.schedule.setTenantID(this.getStringProp(tenantId));
    }

    public String getTenantId() {
        return this.schedule.getTenantID() != null ? this.schedule.getTenantID().getValue() : null;
    }
}

