/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.api;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Credential;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.ems.util.JobServiceScheduleHandlers;
import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jms.ChannelType;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.adapter.ScheduleSynchInputAdapter;
import com.cognos.sds.adapter.ScheduleSynchOutputAdapter;
import com.cognos.sds.api.TriggerQueryString;
import com.cognos.sds.core.persist.TransactionHandler;
import com.cognos.sds.core.runtime.UpdateRuntimeHandler;
import com.cognos.sds.event.EventId;
import com.cognos.sds.event.IEventId;
import com.cognos.sds.handler.IChainHandler;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.schedule.AddScheduleHandlers;
import com.cognos.sds.schedule.BatchScheduleHandler;
import com.cognos.sds.schedule.DeleteScheduleHandlers;
import com.cognos.sds.schedule.DescribeScheduleHandlers;
import com.cognos.sds.schedule.SynchronizeSchedulesHandlers;
import com.cognos.sds.schedule.TriggerScheduleHandlers;
import com.cognos.sds.schedule.TriggerSubscriptionScheduleHandlers;
import com.cognos.sds.schedule.UpdateScheduleHandlers;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import noticecast.logictier.NCObjectType;
import org.apache.axis.MessageContext;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class ScheduleService {
    private static ScheduleService instance = new ScheduleService();

    private ScheduleService() {
    }

    public static ScheduleService getInstance() {
        return instance;
    }

    public ScheduleSynchOutputAdapter[] synchronizeSchedules(ScheduleSynchInputAdapter[] inputs) throws APIException {
        ProcessContext context = new ProcessContext();
        context.setScheduleSynchInputAdapters(inputs);
        Iterator handlersIter = SynchronizeSchedulesHandlers.getInstance().getHandlers().iterator();
        try {
            while (handlersIter.hasNext()) {
                ((ProcessHandler)handlersIter.next()).invoke(context);
            }
        }
        catch (ProcessHandlerException ex) {
            throw new APIException((LocalizableException)((Object)ex));
        }
        return context.getScheduleSynchOutputAdapters();
    }

    public Schedule[] addSchedules(Schedule[] schedules) throws APIException {
        return this.process(schedules, AddScheduleHandlers.getInstance().getHandlers(), false);
    }

    public Schedule describeSchedule(String guid) throws APIException {
        ScheduleAdapter adapter = new ScheduleAdapter();
        adapter.setTaskID(guid);
        ProcessContext context = new ProcessContext();
        context.setScheduleAdapter(adapter);
        context.setTaskType(NCObjectType.NOTIFICATION_AGENT);
        Iterator handlersIter = DescribeScheduleHandlers.getInstance().getHandlers().iterator();
        try {
            while (handlersIter.hasNext()) {
                ((ProcessHandler)handlersIter.next()).invoke(context);
            }
        }
        catch (ProcessHandlerException ex) {
            throw new APIException((LocalizableException)((Object)ex));
        }
        return adapter.getSchedule();
    }

    public Schedule[] updateSchedules(Schedule[] schedules) throws APIException {
        return this.process(schedules, UpdateScheduleHandlers.getInstance().getHandlers(), false);
    }

    public Schedule[] deleteSchedules(String[] scheduleIds) throws APIException {
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        for (int i = 0; i < scheduleIds.length; ++i) {
            Schedule schedule = new Schedule();
            TokenProp id_prop = new TokenProp();
            id_prop.setValue(scheduleIds[i]);
            schedule.setTaskID(id_prop);
            schedules.add(schedule);
        }
        Schedule[] deletes = schedules.toArray(new Schedule[schedules.size()]);
        return this.process(deletes, DeleteScheduleHandlers.getInstance().getHandlers(), true);
    }

    public int trigger(BiBusHeader header, String triggerID, Option[] opts) throws APIException {
        ProcessContext context = new ProcessContext();
        context.setBiBusHeader(header);
        TriggerQueryString tqs = new TriggerQueryString(triggerID);
        context.setTriggerId(tqs.getTriggerName());
        context.setTriggerFolders(tqs.getFolders());
        context.setTriggerOptions(opts);
        int count = 0;
        try {
            Iterator handlers = TriggerScheduleHandlers.getInstance().getHandlers().iterator();
            while (handlers.hasNext()) {
                ((ProcessHandler)handlers.next()).invoke(context);
            }
            count = context.getTriggeredTasks().length;
        }
        catch (ProcessHandlerException ex) {
            throw new APIException((LocalizableException)((Object)ex));
        }
        return count;
    }

    public int triggerSubscriptions(BiBusHeader header, String producerID, String documentVersionID) throws APIException {
        ProcessContext context = new ProcessContext();
        context.setBiBusHeader(header);
        context.setProducerID(producerID);
        context.setDocumentVersionID(documentVersionID);
        int count = 0;
        try {
            Iterator handlers = TriggerSubscriptionScheduleHandlers.getInstance().getHandlers().iterator();
            while (handlers.hasNext()) {
                ((ProcessHandler)handlers.next()).invoke(context);
            }
            count = context.getTriggeredTasks().length;
        }
        catch (ProcessHandlerException ex) {
            throw new APIException((LocalizableException)((Object)ex));
        }
        return count;
    }

    public IEventId addTransientSchedule(Date runTime, Credential credential, Account account, BaseClass objectToRun) throws APIException {
        EventId eventId = null;
        ScheduleAdapter adapter = this.getTransientAdapter(runTime, credential, account, objectToRun);
        ProcessContext context = new ProcessContext();
        context.setTaskType(NCObjectType.JOB_SERVICE_AGENT);
        context.setScheduleAdapter(adapter);
        try {
            Iterator handlersIter = JobServiceScheduleHandlers.getInstance().getHandlers().iterator();
            while (handlersIter.hasNext()) {
                ((ProcessHandler)handlersIter.next()).invoke(context);
            }
            NCObjectId taskId = context.getTask().getNCObjectId();
            Date requestRunDate = context.getTaskSchedule().getNextExecution();
            eventId = new EventId(taskId, requestRunDate);
        }
        catch (ProcessHandlerException e) {
            throw new APIException((LocalizableException)((Object)e));
        }
        return eventId;
    }

    private Schedule[] process(Schedule[] schedules, List action_handlers, boolean isDelete) throws APIException {
        ProcessContext context = new ProcessContext();
        context.setSchedules(schedules);
        context.setTaskType(NCObjectType.NOTIFICATION_AGENT);
        IChainHandler transaction = this.getBatchedScheduleTransactionHandler(action_handlers, isDelete);
        Schedule[] return_schedules = new Schedule[]{};
        try {
            transaction.invoke(context);
            if (!isDelete) {
                new UpdateRuntimeHandler(0).invoke(context);
            }
            return_schedules = context.getSchedules();
        }
        catch (ProcessHandlerException e) {
            throw new APIException((LocalizableException)((Object)e));
        }
        return return_schedules;
    }

    private IChainHandler getBatchedScheduleTransactionHandler(List handlers, boolean isDelete) {
        TransactionHandler transaction = new TransactionHandler();
        transaction.set(handlers);
        BatchScheduleHandler batch_handler = new BatchScheduleHandler(true);
        batch_handler.add(transaction);
        return batch_handler;
    }

    private ScheduleAdapter getTransientAdapter(Date runTime, Credential credential, Account account, BaseClass objectToRun) {
        BaseClass[] ownerArray;
        ScheduleAdapter adapter = new ScheduleAdapter();
        adapter.setActive(true);
        adapter.setEveryNPeriods(1);
        adapter.setStartDate(runTime);
        adapter.setTimeZoneID("UTC");
        adapter.setDailyPeriod("daily");
        adapter.setEndDate(runTime);
        adapter.setTimeZoneID("UTC");
        adapter.setType("once");
        adapter.setEndType(true);
        adapter.setDeleteAfterLastRun(true);
        adapter.setDeliveryChannelType(ChannelType.JOBSERVICE_DELIVERY_CHANNEL);
        adapter.setCredentialSearchPath(credential.getSearchPath().getValue());
        BaseClass[] bc = new BaseClass[]{credential};
        BaseClassArrayProp bcap = new BaseClassArrayProp();
        bcap.setValue(bc);
        adapter.setCredential(bcap);
        String text = this.getBodyText();
        adapter.setCommand(text);
        if (objectToRun.getOwner().getValue() != null && (ownerArray = objectToRun.getOwner().getValue()) != null && ownerArray.length > 0) {
            Account ownerAccount = (Account)ownerArray[0];
            adapter.setParentOwnerStoreID(ownerAccount.getStoreID().getValue().get_value());
        }
        if (objectToRun.getObjectClass() != null) {
            adapter.setParentObjectClass(objectToRun.getObjectClass().getValue());
        }
        adapter.setOwnerStoreID(account.getStoreID().getValue().get_value());
        return adapter;
    }

    private String getBodyText() {
        Document requestDocument = (Document)MessageContext.getCurrentContext().getProperty("dom4j.request.document");
        Element node = requestDocument.getRootElement();
        if (node == null) {
            return null;
        }
        Element body = node.element("Body");
        if (body == null) {
            return null;
        }
        Element body2 = body.createCopy();
        if (body2 == null) {
            return null;
        }
        List envDecNames = node.declaredNamespaces();
        List body2DecNames = body2.declaredNamespaces();
        for (int i = 0; i < envDecNames.size(); ++i) {
            Namespace ns = (Namespace)envDecNames.get(i);
            Namespace newNS2 = body2.getNamespaceForPrefix(ns.getPrefix());
            if (newNS2 != null || body2DecNames.contains(ns)) continue;
            body.addNamespace(ns.getPrefix(), ns.getURI());
        }
        return body.asXML();
    }
}

