/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.api;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class TriggerQueryString {
    private Vector items;
    private String triggerName;

    public TriggerQueryString(String vArgs) {
        try {
            this.items = new Vector();
            int triggerNameLength = vArgs.indexOf("?");
            if (triggerNameLength > 0) {
                this.triggerName = vArgs.substring(0, triggerNameLength);
                String theArgs = vArgs.substring(triggerNameLength + 1);
                StringTokenizer vST = new StringTokenizer(theArgs, "&");
                while (vST.hasMoreTokens()) {
                    String token = vST.nextToken();
                    int splitter = token.indexOf("=");
                    if (splitter <= 0 || splitter >= token.length() - 1) continue;
                    String name = token.substring(0, splitter);
                    String value = token.substring(splitter + 1);
                    this.items.add(new Item(name, TriggerQueryString.cmdecode(value)));
                }
            } else {
                this.triggerName = vArgs;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getTriggerName() {
        return this.triggerName;
    }

    List getValues(String param) {
        Vector<String> x = new Vector<String>();
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = (Item)this.items.elementAt(i);
            if (param.compareTo(item.getName()) != 0) continue;
            x.add(item.getValue());
        }
        return x;
    }

    Set getFolders() {
        return new HashSet(this.getValues("f"));
    }

    String getParameter(String param) {
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = (Item)this.items.elementAt(i);
            if (param.compareTo(item.getName()) != 0) continue;
            return item.getValue();
        }
        return null;
    }

    public static String cmdecode(String s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException();
        }
        StringBuffer sbuf = new StringBuffer(s.length());
        int ch = -1;
        block3: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            ch = c;
            switch (c) {
                case '%': {
                    ch = s.charAt(++i);
                    int hb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    int b = hb << 4 | lb;
                    sbuf.append((char)b);
                    continue block3;
                }
                default: {
                    sbuf.append((char)ch);
                }
            }
        }
        return sbuf.toString();
    }

    class Item {
        String Name;
        String Value;

        public Item(String name, String value) {
            this.Name = name;
            this.Value = value;
        }

        String getName() {
            return this.Name;
        }

        String getValue() {
            return this.Value;
        }
    }
}

