/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.api.converter.recipient;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jms.ChannelType;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.util.UtilException;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.IConverter;
import com.cognos.sds.util.ObjectFactoryUtil;
import java.net.MalformedURLException;
import java.net.URL;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.recipient.DeliveryAddressType;
import noticecast.logictier.recipient.IDeliveryAddress;
import noticecast.logictier.recipient.IRecipient;
import noticecast.logictier.recipient.RecipientOrigin;
import noticecast.persist.INCObjectUpdate;

public class RecipientConverter
implements IConverter {
    @Override
    public Object createNCObject(Object adapter) throws ConverterException {
        IRecipient recipient = null;
        try {
            recipient = (IRecipient)ObjectFactoryUtil.getFromObjectFactory(NCObjectType.RECIPIENT);
        }
        catch (UtilException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.RCPT_CREATE_ERROR);
            throw new ConverterException(I18NCode.RCPT_CREATE_ERROR, (LocalizableException)((Object)ex));
        }
        recipient = this.populate(adapter, recipient);
        return recipient;
    }

    @Override
    public Object updateNCObject(Object adapter, Object object) throws ConverterException {
        INCObjectUpdate updateObject = (INCObjectUpdate)object;
        IRecipient recipient = (IRecipient)updateObject.getObject();
        recipient = this.populate(adapter, recipient);
        return object;
    }

    @Override
    public Object createAdapter(Object object) throws ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object updateAdapter(Object object, Object objectToUpdate) throws ConverterException {
        IRecipient taskSchedule = (IRecipient)object;
        ScheduleAdapter adapter = (ScheduleAdapter)objectToUpdate;
        return adapter;
    }

    private IRecipient populate(Object adapter, IRecipient recipient) throws ConverterException {
        boolean usedefaultTarget = true;
        String target = null;
        if (usedefaultTarget) {
            try {
                String uri = CRNProperties.getInstance().getProperties().getProperty("internalDispatcher");
                URL dispatcherURL = new URL(uri);
                target = dispatcherURL.toString();
            }
            catch (MalformedURLException mue) {
                target = "http://localhost:8080/p2pd/servlet/dispatch/";
            }
        }
        IDeliveryAddress deliveryAddress = null;
        try {
            deliveryAddress = (IDeliveryAddress)ObjectFactoryUtil.getFromObjectFactory(NCObjectType.DELIVERY_ADDRESS);
        }
        catch (UtilException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.RCPT_CREATE_ADDRESS_ERROR);
            throw new ConverterException(I18NCode.RCPT_CREATE_ADDRESS_ERROR, (LocalizableException)((Object)ex));
        }
        deliveryAddress.setAddress(target);
        deliveryAddress.setIsDefault(true);
        deliveryAddress.setType(DeliveryAddressType.NOTICECAST);
        deliveryAddress.setDeliveryChannelType(ChannelType.JOBSERVICE_DELIVERY_CHANNEL);
        recipient.setName("Schedulable Recipient");
        recipient.setDescription("");
        recipient.setDeliveryAddresses(new IDeliveryAddress[]{deliveryAddress});
        recipient.setRecipientOrigin(RecipientOrigin.SERVICE);
        return recipient;
    }
}

