/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.api.converter.scheduling;

import com.cognos.ems.EventManagementCategory;
import com.cognos.i18n.TimeZone;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.scheduling.ScheduleConverter;
import java.util.Date;
import java.util.Map;
import noticecast.persist.INCObjectUpdate;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.schedules.DailySchedule;
import noticecast.scheduling.schedules.DailyScheduleWithIntradayRecurrence;
import noticecast.scheduling.schedules.FixedIntervalSchedule;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.MonthlySchedule;
import noticecast.scheduling.schedules.MonthlyScheduleWithIntradayRecurrence;
import noticecast.scheduling.schedules.Schedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.scheduling.schedules.SubscriptionSchedule;
import noticecast.scheduling.schedules.TriggeredSchedule;
import noticecast.scheduling.schedules.WeeklySchedule;
import noticecast.scheduling.schedules.WeeklyScheduleWithIntradayRecurrence;
import noticecast.scheduling.schedules.YearlySchedule;
import noticecast.scheduling.schedules.YearlyScheduleWithIntradayRecurrence;
import noticecast.util.NcDayConstants;
import noticecast.util.NcMonthConstants;

class AdapterToNcSchedule
extends ScheduleConverter {
    @Override
    public Object createNCObject(Object adapter) throws ConverterException {
        ScheduleAdapter scheduleAdapter = null;
        if (!(adapter instanceof ScheduleAdapter)) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SCHD_INCORRECT_ADAPTER, (Map)ap);
            throw new ConverterException(I18NCode.SCHD_INCORRECT_ADAPTER);
        }
        scheduleAdapter = (ScheduleAdapter)adapter;
        TimeZone tz = null;
        ISchedule schedule = null;
        String name = null;
        String type = scheduleAdapter.getType();
        if (type.equals("never")) {
            return null;
        }
        String timeZoneID = scheduleAdapter.getTimeZoneID();
        tz = timeZoneID == null ? TimeUtils.getServerTimeZone() : TimeZone.getTimeZone((String)timeZoneID);
        Date start = scheduleAdapter.getStartDate();
        if (start == null && !type.equals("trigger")) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SCHD_CREATE_ERROR, (Map)ap);
            throw new ConverterException(I18NCode.SCHD_CREATE_ERROR);
        }
        Date end = scheduleAdapter.getEndDate();
        int interval = scheduleAdapter.getEveryNPeriods();
        boolean repeatForever = scheduleAdapter.getEndType();
        int intradayRecurrenceStart = scheduleAdapter.getIntradayRecurrenceStart();
        int intradayRecurrenceEnd = scheduleAdapter.getIntradayRecurrenceEnd();
        int intradayRecurrenceInterval = scheduleAdapter.getIntradayRecurrenceInterval();
        Date current = new Date();
        if (tz.useDaylightTime() && tz.inDaylightTime(current)) {
            intradayRecurrenceStart += 3600;
            intradayRecurrenceEnd += 3600;
        }
        if (type.equals("once")) {
            schedule = this.buildOnceSchedule(scheduleAdapter, tz, start);
            name = "Run Once";
        } else if (type.equals("trigger")) {
            schedule = this.buildTriggerSchedule(scheduleAdapter, tz, start, end, repeatForever);
            name = "Triggered Schedule";
        } else if (type.equals("subscription")) {
            schedule = this.buildSubscriptionSchedule(scheduleAdapter, tz, start, end, repeatForever);
            name = "Subscription Schedule";
        } else if (type.equals("daily")) {
            schedule = this.buildDailySchedule(scheduleAdapter, tz, start, end, repeatForever, interval);
            String dailyPeriod = scheduleAdapter.getDailyPeriod();
            if (dailyPeriod.equals("minute")) {
                name = "Minutely Schedule";
            } else if (dailyPeriod.equals("hour")) {
                name = "Hourly Schedule";
            } else if (dailyPeriod.equals("day")) {
                name = "Daily Schedule";
            }
        } else if (type.equals("weekly")) {
            schedule = this.buildWeeklySchedule(scheduleAdapter, tz, start, end, repeatForever, interval);
            name = "Weekly Schedule";
        } else if (type.equals("monthlyAbsolute")) {
            schedule = this.buildMonthlySchedule(scheduleAdapter, tz, start, end, repeatForever, interval, type);
            name = "Monthly Schedule";
        } else if (type.equals("monthlyRelative")) {
            schedule = this.buildMonthlySchedule(scheduleAdapter, tz, start, end, repeatForever, interval, type);
            name = "Monthly Schedule";
        } else if (type.equals("yearlyAbsolute")) {
            schedule = this.buildYearlySchedule(scheduleAdapter, tz, start, end, repeatForever, interval, type);
            name = "Yearly Schedule";
        } else if (type.equals("yearlyRelative")) {
            schedule = this.buildYearlySchedule(scheduleAdapter, tz, start, end, repeatForever, interval, type);
            name = "Yearly Schedule";
        } else if (type.equals("dailyWithIntradayRecurrence")) {
            schedule = this.buildDailyScheduleWithIntradayRecurrence(scheduleAdapter, tz, start, end, repeatForever, interval, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
            name = "Daily Schedule with intraday recurrence";
        } else if (type.equals("weeklyWithIntradayRecurrence")) {
            schedule = this.buildWeeklyScheduleWithIntradayRecurrence(scheduleAdapter, tz, start, end, repeatForever, interval, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
            name = "Weekly Schedule with intraday recurrence";
        } else if (type.equals("monthlyAbsoluteWithIntradayRecurrence")) {
            schedule = this.buildMonthlyAbsoluteScheduleWithIntradayRecurrence(scheduleAdapter, tz, start, end, repeatForever, interval, type, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
            name = "Monthly Absolute Schedule with intraday recurrence";
        } else if (type.equals("monthlyRelativeWithIntradayRecurrence")) {
            schedule = this.buildMonthlyRelativeScheduleWithIntradayRecurrence(scheduleAdapter, tz, start, end, repeatForever, interval, type, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
            name = "Monthly Relative Schedule with intraday recurrence";
        } else if (type.equals("yearlyAbsoluteWithIntradayRecurrence")) {
            schedule = this.buildYearlyAbsoluteScheduleWithIntradayRecurrence(scheduleAdapter, tz, start, end, repeatForever, interval, type, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
            name = "Yearly Absolute Schedule with intraday recurrence";
        } else if (type.equals("yearlyRelativeWithIntradayRecurrence")) {
            schedule = this.buildYearlyRelativeScheduleWithIntradayRecurrence(scheduleAdapter, tz, start, end, repeatForever, interval, type, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
            name = "Yearly Relative Schedule with intraday recurrence";
        } else {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_INVALID_SCHEDULE_PROPERTIES, (Map)ap);
            throw new ConverterException(I18NCode.MSG_INVALID_SCHEDULE_PROPERTIES);
        }
        NCObjectId id = NCObjectId.createNew();
        String description = "Schedule";
        return new NcScheduleWrapper(id, name, description, schedule);
    }

    @Override
    public Object updateNCObject(Object adapter, Object object) throws ConverterException {
        INCObjectUpdate update = (INCObjectUpdate)object;
        NcScheduleWrapper ncScheduleWrapper = (NcScheduleWrapper)update.getObject();
        NcScheduleWrapper newOne = (NcScheduleWrapper)this.createNCObject(adapter);
        ncScheduleWrapper.setDescription(newOne.getDescription());
        ncScheduleWrapper.setName(newOne.getName());
        ncScheduleWrapper.setSchedule(newOne.getSchedule());
        ncScheduleWrapper.setCMVersion(newOne.getCMVersion());
        return object;
    }

    private ISchedule buildTriggerSchedule(ScheduleAdapter adapter, TimeZone tz, Date start, Date end, boolean repeatForever) {
        if (start == null) {
            start = new Date();
        }
        TriggeredSchedule nc_schedule = new TriggeredSchedule(adapter.getTrigger(), start, end, repeatForever, tz);
        return nc_schedule;
    }

    private ISchedule buildSubscriptionSchedule(ScheduleAdapter adapter, TimeZone tz, Date start, Date end, boolean repeatForever) {
        if (start == null) {
            start = new Date();
        }
        SubscriptionSchedule nc_schedule = new SubscriptionSchedule(adapter.getPeriodicalProducer(), start, end, repeatForever, tz);
        return nc_schedule;
    }

    private ISchedule buildOnceSchedule(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start) throws ConverterException {
        Date end = start;
        boolean never_end = false;
        FixedIntervalSchedule nc_schedule = new FixedIntervalSchedule(ScheduleType.FIXED_INT_HOUR_SCHEDULE, start, end, never_end, 1, tz);
        return nc_schedule;
    }

    private ISchedule buildDailySchedule(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start, Date end, boolean repeatForever, int interval) throws ConverterException {
        String dailyType = scheduleAdapter.getDailyPeriod();
        Schedule nc_schedule = null;
        if (dailyType.equals("minute")) {
            nc_schedule = new FixedIntervalSchedule(ScheduleType.FIXED_INT_MINUTE_SCHEDULE, start, end, repeatForever, interval, tz);
        } else if (dailyType.equals("hour")) {
            nc_schedule = new FixedIntervalSchedule(ScheduleType.FIXED_INT_HOUR_SCHEDULE, start, end, repeatForever, interval, tz);
        } else if (dailyType.equals("day")) {
            nc_schedule = new DailySchedule(ScheduleType.DAILY_SCHEDULE, start, end, repeatForever, interval, tz);
        } else {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SCHD_INVALID_ERROR, (Map)ap);
            throw new ConverterException(I18NCode.SCHD_INVALID_ERROR);
        }
        return nc_schedule;
    }

    private ISchedule buildDailyScheduleWithIntradayRecurrence(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start, Date end, boolean repeatForever, int interval, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) throws ConverterException {
        return new DailyScheduleWithIntradayRecurrence(ScheduleType.DAILY_WITH_INTRADAY_RECURRENCE_SCHEDULE, start, end, repeatForever, interval, tz, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
    }

    private ISchedule buildWeeklySchedule(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start, Date end, boolean repeatForever, int interval) throws ConverterException {
        int days_of_week = this.processDaysOfWeek(scheduleAdapter);
        WeeklySchedule schedule = null;
        if (days_of_week == 0) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SCHD_INVALID_ERROR, (Map)ap);
            throw new ConverterException(I18NCode.SCHD_INVALID_ERROR);
        }
        schedule = new WeeklySchedule(ScheduleType.WEEKLY_SCHEDULE, start, end, repeatForever, interval, days_of_week, tz);
        return schedule;
    }

    private ISchedule buildWeeklyScheduleWithIntradayRecurrence(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start, Date end, boolean repeatForever, int intervalInWeeks, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) throws ConverterException {
        int daysOfWeek = this.processDaysOfWeek(scheduleAdapter);
        if (daysOfWeek <= 0) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SCHD_INVALID_ERROR, (Map)ap);
            throw new ConverterException(I18NCode.SCHD_INVALID_ERROR);
        }
        return new WeeklyScheduleWithIntradayRecurrence(ScheduleType.WEEKLY_WITH_INTRADAY_RECURRENCE_SCHEDULE, start, end, repeatForever, intervalInWeeks, daysOfWeek, tz, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
    }

    private ISchedule buildMonthlySchedule(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start, Date end, boolean repeatForever, int interval, String type) throws ConverterException {
        MonthlySchedule nc_schedule = null;
        if (type.equals("monthlyRelative")) {
            int week_in_month = this.determineWeek(scheduleAdapter.getMonthlyRelativeWeek());
            NcDayConstants day_of_week = NcDayConstants.getDay(scheduleAdapter.getMonthlyRelativeDay());
            nc_schedule = new MonthlySchedule(ScheduleType.MONTHLY_SCHEDULE, start, end, repeatForever, interval, false, -1, week_in_month, day_of_week, tz);
        } else if (type.equals("monthlyAbsolute")) {
            int day_of_month = scheduleAdapter.getMonthlyAbsoluteDay();
            nc_schedule = new MonthlySchedule(ScheduleType.MONTHLY_SCHEDULE, start, end, repeatForever, interval, true, day_of_month, -1, null, tz);
        } else {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SCHD_INVALID_ERROR, (Map)ap);
            throw new ConverterException(I18NCode.SCHD_INVALID_ERROR);
        }
        return nc_schedule;
    }

    private ISchedule buildMonthlyAbsoluteScheduleWithIntradayRecurrence(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start, Date end, boolean repeatForever, int interval, String type, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) throws ConverterException {
        int day_of_month = scheduleAdapter.getMonthlyAbsoluteDay();
        return new MonthlyScheduleWithIntradayRecurrence(ScheduleType.MONTHLY_ABSOLUTE_WITH_INTRADAY_RECURRENCE_SCHEDULE, start, end, repeatForever, interval, true, day_of_month, -1, null, tz, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
    }

    private ISchedule buildMonthlyRelativeScheduleWithIntradayRecurrence(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start, Date end, boolean repeatForever, int interval, String type, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) throws ConverterException {
        int week_in_month = this.determineWeek(scheduleAdapter.getMonthlyRelativeWeek());
        NcDayConstants day_of_week = NcDayConstants.getDay(scheduleAdapter.getMonthlyRelativeDay());
        return new MonthlyScheduleWithIntradayRecurrence(ScheduleType.MONTHLY_RELATIVE_WITH_INTRADAY_RECURRENCE_SCHEDULE, start, end, repeatForever, interval, false, -1, week_in_month, day_of_week, tz, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
    }

    private ISchedule buildYearlySchedule(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start, Date end, boolean repeatForever, int interval, String type) throws ConverterException {
        YearlySchedule schedule = null;
        if (type.equals("yearlyRelative")) {
            NcDayConstants day_of_week = NcDayConstants.getDay(scheduleAdapter.getYearlyRelativeDay());
            int week_in_month = this.determineWeek(scheduleAdapter.getYearlyRelativeWeek());
            NcMonthConstants month_of_year = NcMonthConstants.getMonth(scheduleAdapter.getYearlyRelativeMonth());
            schedule = new YearlySchedule(ScheduleType.YEARLY_SCHEDULE, start, end, repeatForever, 12, false, -1, week_in_month, day_of_week, month_of_year, tz);
        } else if (type.equals("yearlyAbsolute")) {
            int day_of_month = scheduleAdapter.getYearlyAbsoluteDay();
            NcMonthConstants month_of_year = NcMonthConstants.getMonth(scheduleAdapter.getYearlyAbsoluteMonth());
            schedule = new YearlySchedule(ScheduleType.YEARLY_SCHEDULE, start, end, repeatForever, 12, true, day_of_month, -1, null, month_of_year, tz);
        } else {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SCHD_INVALID_ERROR, (Map)ap);
            throw new ConverterException(I18NCode.SCHD_INVALID_ERROR);
        }
        return schedule;
    }

    private ISchedule buildYearlyAbsoluteScheduleWithIntradayRecurrence(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start, Date end, boolean repeatForever, int interval, String type, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) throws ConverterException {
        int day_of_month = scheduleAdapter.getYearlyAbsoluteDay();
        NcMonthConstants month_of_year = NcMonthConstants.getMonth(scheduleAdapter.getYearlyAbsoluteMonth());
        return new YearlyScheduleWithIntradayRecurrence(ScheduleType.YEARLY_ABSOLUTE_WITH_INTRADAY_RECURRENCE_SCHEDULE, start, end, repeatForever, 12, true, day_of_month, -1, null, month_of_year, tz, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
    }

    private ISchedule buildYearlyRelativeScheduleWithIntradayRecurrence(ScheduleAdapter scheduleAdapter, TimeZone tz, Date start, Date end, boolean repeatForever, int interval, String type, int intradayRecurrenceStart, int intradayRecurrenceEnd, int intradayRecurrenceInterval) throws ConverterException {
        NcDayConstants day_of_week = NcDayConstants.getDay(scheduleAdapter.getYearlyRelativeDay());
        int week_in_month = this.determineWeek(scheduleAdapter.getYearlyRelativeWeek());
        NcMonthConstants month_of_year = NcMonthConstants.getMonth(scheduleAdapter.getYearlyRelativeMonth());
        return new YearlyScheduleWithIntradayRecurrence(ScheduleType.YEARLY_RELATIVE_WITH_INTRADAY_RECURRENCE_SCHEDULE, start, end, repeatForever, 12, false, -1, week_in_month, day_of_week, month_of_year, tz, intradayRecurrenceStart, intradayRecurrenceEnd, intradayRecurrenceInterval);
    }

    private int determineWeek(String order) {
        int week = 1;
        if (order.equals("first")) {
            week = 1;
        }
        if (order.equals("second")) {
            week = 2;
        }
        if (order.equals("third")) {
            week = 3;
        }
        if (order.equals("fourth")) {
            week = 4;
        }
        if (order.equals("last")) {
            week = -1;
        }
        return week;
    }

    private int processDaysOfWeek(ScheduleAdapter scheduleAdapter) {
        int total = 0;
        if (scheduleAdapter.getWeeklySunday()) {
            ++total;
        }
        if (scheduleAdapter.getWeeklyMonday()) {
            total += 2;
        }
        if (scheduleAdapter.getWeeklyTuesday()) {
            total += 4;
        }
        if (scheduleAdapter.getWeeklyWednesday()) {
            total += 8;
        }
        if (scheduleAdapter.getWeeklyThursday()) {
            total += 16;
        }
        if (scheduleAdapter.getWeeklyFriday()) {
            total += 32;
        }
        if (scheduleAdapter.getWeeklySaturday()) {
            total += 64;
        }
        return total;
    }
}

