/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.api.converter.scheduling;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.scheduling.ScheduleConverter;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.ScheduleType;
import noticecast.scheduling.schedules.TriggeredSchedule;
import noticecast.scheduling.schedules.WeeklySchedule;

public class NcScheduleToAdapter
extends ScheduleConverter {
    @Override
    public Object createAdapter(Object object) throws ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object updateAdapter(Object object, Object objectToUpdate) throws ConverterException {
        NcScheduleWrapper scheduleWrapper = (NcScheduleWrapper)object;
        ScheduleAdapter adapter = (ScheduleAdapter)objectToUpdate;
        ISchedule schedule = scheduleWrapper.getSchedule();
        adapter.setEndDate(schedule.getEndDate());
        adapter.setEndType(schedule.getRepeatForever());
        adapter.setEveryNPeriods(schedule.getRepeatInterval());
        adapter.setStartDate(schedule.getStartDate());
        adapter.setTimeZoneID(schedule.getTimeZone().getID());
        this.setDailyParams(schedule, adapter);
        this.setWeeklyParams(schedule, adapter);
        this.setMonthlyParams(schedule, adapter);
        this.setYearlyParams(schedule, adapter);
        this.setTrigger(schedule, adapter);
        return adapter;
    }

    private void setDailyParams(ISchedule schedule, ScheduleAdapter adapter) {
        if (schedule.getType().equals(ScheduleType.FIXED_INT_MINUTE_SCHEDULE)) {
            adapter.setDailyPeriod("minute");
            adapter.setType("daily");
        } else if (schedule.getType().equals(ScheduleType.FIXED_INT_HOUR_SCHEDULE)) {
            adapter.setDailyPeriod("hour");
            adapter.setType("daily");
        } else if (schedule.getType().equals(ScheduleType.DAILY_SCHEDULE)) {
            adapter.setDailyPeriod("day");
            adapter.setType("daily");
        } else {
            adapter.setDailyPeriod("");
        }
    }

    private void setWeeklyParams(ISchedule schedule, ScheduleAdapter adapter) {
        if (schedule.getType().equals(ScheduleType.WEEKLY_SCHEDULE)) {
            adapter.setType("weekly");
            int daysOfWeek = ((WeeklySchedule)schedule).getDaysOfWeek();
            this.setDefaultWeekDayProps(adapter);
            if (daysOfWeek >= 64) {
                adapter.setWeeklySaturday(true);
                daysOfWeek -= 64;
            }
            if (daysOfWeek >= 32) {
                adapter.setWeeklySunday(true);
                daysOfWeek -= 32;
            }
            if (daysOfWeek >= 16) {
                adapter.setWeeklyMonday(true);
                daysOfWeek -= 16;
            }
            if (daysOfWeek >= 8) {
                adapter.setWeeklyTuesday(true);
                daysOfWeek -= 8;
            }
            if (daysOfWeek >= 4) {
                adapter.setWeeklyWednesday(true);
                daysOfWeek -= 4;
            }
            if (daysOfWeek >= 2) {
                adapter.setWeeklyThursday(true);
                daysOfWeek -= 2;
            }
            if (daysOfWeek >= 1) {
                adapter.setWeeklyFriday(true);
                --daysOfWeek;
            }
        }
    }

    private void setMonthlyParams(ISchedule schedule, ScheduleAdapter adapter) throws ConverterException {
        if (schedule.getType().equals(ScheduleType.MONTHLY_SCHEDULE)) {
            if (schedule.getUseDayNumber()) {
                adapter.setMonthlyAbsoluteDay(schedule.getDayOfMonth());
            } else {
                String dayOfWeekInMonth = this.determineWeekString(schedule.getDayOfWeekInMonth());
                String dayOfWeek = schedule.getDayOfWeek().toString();
                adapter.setMonthlyRelativeDay(dayOfWeekInMonth);
                adapter.setMonthlyRelativeWeek(dayOfWeek);
            }
        }
    }

    private void setYearlyParams(ISchedule schedule, ScheduleAdapter adapter) throws ConverterException {
        if (schedule.getType().equals(ScheduleType.YEARLY_SCHEDULE)) {
            if (schedule.getUseDayNumber()) {
                adapter.setYearlyAbsoluteDay(schedule.getDayOfMonth());
                adapter.setYearlyAbsoluteMonth(schedule.getMonthOfYear().stringValue());
            } else {
                String dayOfWeekInMonth = this.determineWeekString(schedule.getDayOfWeekInMonth());
                String dayOfWeek = schedule.getDayOfWeek().toString();
                String monthOfYear = schedule.getMonthOfYear().stringValue();
                adapter.setYearlyRelativeDay(dayOfWeekInMonth);
                adapter.setYearlyRelativeWeek(dayOfWeek);
                adapter.setYearlyRelativeMonth(monthOfYear);
            }
        }
    }

    private void setTrigger(ISchedule schedule, ScheduleAdapter adapter) {
        if (schedule.getType().equals(ScheduleType.TRIGGERED_SCHEULE)) {
            TriggeredSchedule trigger = (TriggeredSchedule)schedule;
            adapter.setTrigger(trigger.getTrigger());
        }
    }

    private void setDefaultWeekDayProps(ScheduleAdapter adapter) {
        adapter.setWeeklySaturday(false);
        adapter.setWeeklySunday(false);
        adapter.setWeeklyMonday(false);
        adapter.setWeeklyTuesday(false);
        adapter.setWeeklyWednesday(false);
        adapter.setWeeklyThursday(false);
        adapter.setWeeklyFriday(false);
    }

    private void setDefaultYearlyProps(ScheduleAdapter adapter) {
        adapter.setYearlyAbsoluteDay(1);
        adapter.setYearlyAbsoluteMonth("january");
        adapter.setYearlyRelativeDay("sunday");
        adapter.setYearlyRelativeMonth("january");
        adapter.setYearlyRelativeWeek("last");
    }

    private void setDefaultMonthlyProps(ScheduleAdapter adapter) {
        adapter.setMonthlyAbsoluteDay(1);
        adapter.setMonthlyRelativeDay("sunday");
        adapter.setMonthlyRelativeWeek("last");
    }

    private String determineWeekString(int weekInt) throws ConverterException {
        String weekString;
        switch (weekInt) {
            case 1: {
                weekString = "first";
                break;
            }
            case 2: {
                weekString = "second";
                break;
            }
            case 3: {
                weekString = "third";
                break;
            }
            case 4: {
                weekString = "fourth";
                break;
            }
            case -1: {
                weekString = "last";
                break;
            }
            default: {
                throw new ConverterException(I18NCode.SCHD_INVALID_ERROR);
            }
        }
        return weekString;
    }
}

