/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.api.converter.scheduling;

import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.IConverter;
import com.cognos.sds.api.converter.scheduling.AdapterToNcSchedule;
import com.cognos.sds.api.converter.scheduling.NcScheduleToAdapter;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.ScheduleType;

public class ScheduleConverter
implements IConverter {
    public static final String TYPE_NEVER = "never";
    public static final String TYPE_ONCE = "once";
    public static final String TYPE_SECOND = "second";
    public static final String TYPE_MINUTE = "minute";
    public static final String TYPE_HOUR = "hour";
    public static final String TYPE_DAY = "day";
    public static final String TYPE_DAILY = "daily";
    public static final String TYPE_WEEKLY = "weekly";
    public static final String TYPE_MONTHLY_ABS = "monthlyAbsolute";
    public static final String TYPE_MONTHLY_REL = "monthlyRelative";
    public static final String TYPE_YEARLY_ABS = "yearlyAbsolute";
    public static final String TYPE_YEARLY_REL = "yearlyRelative";
    public static final String TYPE_TRIGGER = "trigger";
    public static final String TYPE_SUBSCRIPTION = "subscription";
    public static final String TYPE_FIRST_WEEK = "first";
    public static final String TYPE_SECOND_WEEK = "second";
    public static final String TYPE_THIRD_WEEK = "third";
    public static final String TYPE_FORTH_WEEK = "fourth";
    public static final String TYPE_LAST_WEEK = "last";
    public static final String TYPE_DAILY_WITH_INTRADAY_RECURRENCE = "dailyWithIntradayRecurrence";
    public static final String TYPE_WEEKLY_WITH_INTRADAY_RECURRENCE = "weeklyWithIntradayRecurrence";
    public static final String TYPE_MONTHLY_ABSOLUTE_WITH_INTRADAY_RECURRENCE = "monthlyAbsoluteWithIntradayRecurrence";
    public static final String TYPE_MONTHLY_RELATIVE_WITH_INTRADAY_RECURRENCE = "monthlyRelativeWithIntradayRecurrence";
    public static final String TYPE_YEARLY_ABSOLUTE_WITH_INTRADAY_RECURRENCE = "yearlyAbsoluteWithIntradayRecurrence";
    public static final String TYPE_YEARLY_RELATIVE_WITH_INTRADAY_RECURRENCE = "yearlyRelativeWithIntradayRecurrence";
    public static final String DEFAULT_DESCRIPTION = "Schedule";
    private static final AdapterToNcSchedule adapterToNcSchedule = new AdapterToNcSchedule();
    private static final NcScheduleToAdapter ncScheduleToAdapter = new NcScheduleToAdapter();

    @Override
    public Object createNCObject(Object adapter) throws ConverterException {
        return adapterToNcSchedule.createNCObject(adapter);
    }

    @Override
    public Object updateNCObject(Object adapter, Object object) throws ConverterException {
        return adapterToNcSchedule.updateNCObject(adapter, object);
    }

    @Override
    public Object createAdapter(Object object) throws ConverterException {
        return ncScheduleToAdapter.createAdapter(object);
    }

    @Override
    public Object updateAdapter(Object object, Object objectToUpdate) throws ConverterException {
        return ncScheduleToAdapter.updateAdapter(object, objectToUpdate);
    }

    public static String getOMScheduleType(NcScheduleWrapper scheduleWrapper) {
        ISchedule schedule = scheduleWrapper.getSchedule();
        String type = "";
        if (ScheduleType.DAILY_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_DAILY;
        } else if (ScheduleType.DAILY_WITH_INTRADAY_RECURRENCE_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_DAILY_WITH_INTRADAY_RECURRENCE;
        } else if (ScheduleType.FIXED_INT_HOUR_SCHEDULE.equals(schedule.getType())) {
            type = scheduleWrapper.getName().equals("Run Once") ? TYPE_ONCE : TYPE_DAILY;
        } else if (ScheduleType.FIXED_INT_MINUTE_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_DAILY;
        } else if (ScheduleType.WEEKLY_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_WEEKLY;
        } else if (ScheduleType.WEEKLY_WITH_INTRADAY_RECURRENCE_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_WEEKLY_WITH_INTRADAY_RECURRENCE;
        } else if (ScheduleType.MONTHLY_SCHEDULE.equals(schedule.getType())) {
            type = schedule.getUseDayNumber() ? TYPE_MONTHLY_ABS : TYPE_MONTHLY_REL;
        } else if (ScheduleType.MONTHLY_ABSOLUTE_WITH_INTRADAY_RECURRENCE_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_MONTHLY_ABSOLUTE_WITH_INTRADAY_RECURRENCE;
        } else if (ScheduleType.MONTHLY_RELATIVE_WITH_INTRADAY_RECURRENCE_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_MONTHLY_RELATIVE_WITH_INTRADAY_RECURRENCE;
        } else if (ScheduleType.YEARLY_SCHEDULE.equals(schedule.getType())) {
            type = schedule.getUseDayNumber() ? TYPE_YEARLY_ABS : TYPE_YEARLY_REL;
        } else if (ScheduleType.YEARLY_ABSOLUTE_WITH_INTRADAY_RECURRENCE_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_YEARLY_ABSOLUTE_WITH_INTRADAY_RECURRENCE;
        } else if (ScheduleType.YEARLY_RELATIVE_WITH_INTRADAY_RECURRENCE_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_YEARLY_RELATIVE_WITH_INTRADAY_RECURRENCE;
        } else if (ScheduleType.TRIGGERED_SCHEULE.equals(schedule.getType())) {
            type = TYPE_TRIGGER;
        } else if (ScheduleType.SUBSCRIPTION_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_SUBSCRIPTION;
        } else if (ScheduleType.FIXED_INT_SECOND_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_DAILY;
        } else if (ScheduleType.FIXED_SCHEDULE.equals(schedule.getType())) {
            type = TYPE_DAILY;
        }
        return type;
    }
}

