/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.api.converter.task;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jms.ChannelType;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.UtilException;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.IConverter;
import com.cognos.sds.util.ObjectFactoryUtil;
import java.util.Vector;
import noticecast.exceptions.NCException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.message.RecipientLinkImpl;
import noticecast.logictier.message.TextMessageLine;
import noticecast.logictier.recipient.IRecipient;
import noticecast.logictier.recipient.RecipientFeatherWeightImpl;
import noticecast.logictier.recipient.RecipientOrigin;

public class MessageConverter
implements IConverter {
    private IRecipient m_recipient;

    public MessageConverter(IRecipient recipient) {
        this.m_recipient = recipient;
    }

    @Override
    public Object createNCObject(Object adapter) throws ConverterException {
        IMessageStruct ms = null;
        try {
            ms = (IMessageStruct)ObjectFactoryUtil.getFromObjectFactory(NCObjectType.MESSAGE_STRUCT);
        }
        catch (UtilException ex) {
            throw new ConverterException(I18NCode.MSG_CREATE_ERROR, (LocalizableException)((Object)ex));
        }
        ms = this.populate(adapter, ms);
        return ms;
    }

    @Override
    public Object updateNCObject(Object adapter, Object object) throws ConverterException {
        IMessageStruct ms = null;
        if (!(object instanceof IMessageStruct)) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_UPDATE_ERROR);
            throw new ConverterException(I18NCode.MSG_UPDATE_ERROR);
        }
        ms = (IMessageStruct)object;
        ms = this.populate(adapter, ms);
        return ms;
    }

    @Override
    public Object createAdapter(Object object) throws ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object updateAdapter(Object object, Object objectToUpdate) throws ConverterException {
        IMessageStruct ms = (IMessageStruct)object;
        ScheduleAdapter adapter = (ScheduleAdapter)objectToUpdate;
        return adapter;
    }

    private IMessageStruct populate(Object adapter, IMessageStruct messageStruct) throws ConverterException {
        ScheduleAdapter scheduleAdapter = null;
        if (!(adapter instanceof ScheduleAdapter)) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_INCORRECT_ADAPTER);
            throw new ConverterException(I18NCode.MSG_INCORRECT_ADAPTER);
        }
        scheduleAdapter = (ScheduleAdapter)adapter;
        ChannelType channelType = scheduleAdapter.getDeliveryChannelType();
        if (channelType == null) {
            channelType = ChannelType.JOBSERVICE_DELIVERY_CHANNEL;
        }
        messageStruct.setChannelType(channelType);
        String credential = scheduleAdapter.getCredentialSearchPath();
        messageStruct.setCredential(credential);
        int TRUNC_SIZE = 1000;
        String command = scheduleAdapter.getCommand();
        Vector<TextMessageLine> messageLines = new Vector<TextMessageLine>();
        int i = 0;
        for (int sizeLeft = command.length(); sizeLeft > 0; sizeLeft -= TRUNC_SIZE) {
            if (sizeLeft <= TRUNC_SIZE) {
                messageLines.add(new TextMessageLine(command.substring(i)));
                break;
            }
            messageLines.add(new TextMessageLine(command.substring(i, i + TRUNC_SIZE)));
            i += TRUNC_SIZE;
        }
        messageStruct.setMessageLines(messageLines);
        RecipientFeatherWeightImpl rfw = null;
        try {
            rfw = new RecipientFeatherWeightImpl(RecipientOrigin.SERVICE, this.m_recipient.getNCObjectId(), "Schedulable target", "Schedulable interface construction", "", "");
        }
        catch (NCException ex) {
            throw new ConverterException(I18NCode.RCPT_STORE_ERROR, ex);
        }
        RecipientLinkImpl rl = new RecipientLinkImpl(rfw);
        messageStruct.addRecipientLink(rl);
        return messageStruct;
    }
}

