/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.api.converter.task;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.UtilException;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.IConverter;
import com.cognos.sds.api.converter.task.MessageConverter;
import com.cognos.sds.util.ObjectFactoryUtil;
import java.util.Map;
import java.util.Vector;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.DetectionOption;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.agent.TaskType;
import noticecast.logictier.message.IMessageStruct;
import noticecast.logictier.recipient.IRecipient;
import noticecast.persist.INCObjectUpdate;

public abstract class TaskConverter
implements IConverter {
    private IConverter m_messageConverter;

    public TaskConverter(IRecipient recipient) throws ConverterException {
        this.m_messageConverter = new MessageConverter(recipient);
    }

    @Override
    public Object createNCObject(Object adapter) throws ConverterException {
        ITask task = null;
        try {
            task = (ITask)ObjectFactoryUtil.getFromObjectFactory(NCObjectType.TASK);
        }
        catch (UtilException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.PERST_UNABLE_CREATE_OBJECT, (Object[])new String[]{task.toString()}, (Map)ap);
            throw new ConverterException(I18NCode.PERST_UNABLE_CREATE_OBJECT, new Object[]{NCObjectType.TASK}, (LocalizableException)((Object)ex));
        }
        task = this.populateTask(adapter, task);
        IMessageStruct ms = (IMessageStruct)this.m_messageConverter.createNCObject(adapter);
        Vector<IMessageStruct> messages = new Vector<IMessageStruct>();
        messages.add(ms);
        task.setMessages(messages);
        return task;
    }

    @Override
    public Object updateNCObject(Object adapter, Object object) throws ConverterException {
        INCObjectUpdate updateObject = (INCObjectUpdate)object;
        ITask task = (ITask)updateObject.getObject();
        task = this.populateTask(adapter, task);
        IMessageStruct ms = null;
        while (task.getMessages().hasNext() && ms == null) {
            ms = (IMessageStruct)task.getMessages().next();
        }
        if (ms == null) {
            throw new ConverterException(I18NCode.AGENT_HAS_NO_MESSAGE);
        }
        this.m_messageConverter.updateNCObject(adapter, ms);
        return object;
    }

    @Override
    public Object createAdapter(Object object) throws ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object updateAdapter(Object object, Object objectToUpdate) throws ConverterException {
        ITask task = (ITask)object;
        ScheduleAdapter adapter = (ScheduleAdapter)objectToUpdate;
        this.m_messageConverter.updateAdapter(null, null);
        return adapter;
    }

    protected abstract NCObjectType getType();

    private ITask populateTask(Object adapter, ITask task) throws ConverterException {
        task.setName("Schedulable Agent");
        task.setDescription("Schedulable Agent");
        task.setDetectionOption(DetectionOption.CONTINUE);
        task.setTaskType(TaskType.BUSINESS_EVENT);
        task.setAgentSubType(this.getType());
        if (adapter instanceof ScheduleAdapter) {
            ScheduleAdapter scheduleAdapter = (ScheduleAdapter)adapter;
            if (scheduleAdapter.getVersion() != null) {
                task.setCMVersion(scheduleAdapter.getVersion());
            }
            task.setObjectClass(scheduleAdapter.getParentObjectClass());
            task.setOwner(scheduleAdapter.getParentOwnerStoreID());
        }
        return task;
    }
}

