/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.api.converter.task;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.api.converter.ConverterException;
import com.cognos.sds.api.converter.IConverter;
import com.cognos.sds.event.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import noticecast.exceptions.NCException;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.base.NCFeatherWeightImpl;
import noticecast.persist.INCObjectUpdate;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.NcScheduleWrapper;
import noticecast.scheduling.nc.ScheduleLink;
import noticecast.scheduling.nc.TaskScheduleImpl;

public class TaskScheduleConverter
implements IConverter {
    private NCObjectId m_taskId;
    private NcScheduleWrapper[] m_scheduleWrappers;

    public TaskScheduleConverter(NCObjectId taskId, NcScheduleWrapper[] scheduleWrappers) {
        this.m_taskId = taskId;
        this.m_scheduleWrappers = scheduleWrappers;
    }

    @Override
    public Object createNCObject(Object adapter) throws ConverterException {
        ScheduleAdapter scheduleAdapter = null;
        if (!(adapter instanceof ScheduleAdapter)) {
            throw new ConverterException(I18NCode.SCHD_INCORRECT_ADAPTER);
        }
        scheduleAdapter = (ScheduleAdapter)adapter;
        boolean isActive = scheduleAdapter.getActive();
        if (this.m_taskId == null || this.m_scheduleWrappers == null) {
            throw new ConverterException(I18NCode.AGENT_HAS_NO_SCHEDULE);
        }
        TaskScheduleImpl task_schedule = null;
        NCFeatherWeightImpl schedule_fw = null;
        ArrayList<ScheduleLink> links_list = new ArrayList<ScheduleLink>(this.m_scheduleWrappers.length);
        try {
            for (int i = 0; i < this.m_scheduleWrappers.length; ++i) {
                if (this.m_scheduleWrappers[i] == null) continue;
                schedule_fw = new NCFeatherWeightImpl(NCObjectType.SCHEDULE, this.m_scheduleWrappers[i].getNCObjectId(), this.m_scheduleWrappers[i].getName(), this.m_scheduleWrappers[i].getDescription());
                ScheduleLink link = new ScheduleLink(schedule_fw, true, true);
                link.setSchedule(this.m_scheduleWrappers[i]);
                link.setActive(isActive);
                links_list.add(link);
            }
            ScheduleLink[] schedule_links = new ScheduleLink[links_list.size()];
            links_list.toArray(schedule_links);
            task_schedule = new TaskScheduleImpl(schedule_links);
            task_schedule.setNCObjectId(NCObjectId.createNew());
            task_schedule.setTaskId(this.m_taskId);
            task_schedule.setPriority(scheduleAdapter.getPriority());
            task_schedule.setDeleteAfterLastRun(scheduleAdapter.getDeleteAfterLastRun());
            task_schedule.setOwnerStoreID(scheduleAdapter.getScheduledByStoreID());
            task_schedule.setTenantID(scheduleAdapter.getTenantId());
        }
        catch (NCException e) {
            throw new ConverterException(I18NCode.PERST_UNABLE_CREATE_OBJECT, new Object[]{NCObjectType.SCHEDULE}, e);
        }
        return task_schedule;
    }

    @Override
    public Object updateNCObject(Object adapter, Object object) throws ConverterException {
        INCObjectUpdate updateObject = (INCObjectUpdate)object;
        ITaskSchedule taskSchedule = (ITaskSchedule)updateObject.getObject();
        ITaskSchedule newOne = (ITaskSchedule)this.createNCObject(adapter);
        ScheduleLink[] oldLinks = taskSchedule.getScheduleLinks();
        ScheduleLink[] newLinks = newOne.getScheduleLinks();
        block0: for (int i = 0; i < oldLinks.length; ++i) {
            NCObjectId oldSchedID = oldLinks[i].getScheduleId();
            for (int j = 0; j < newLinks.length; ++j) {
                NCObjectId newSchedId = newLinks[j].getScheduleId();
                if (!oldSchedID.equals(newSchedId)) continue;
                Collection oldOverrideEvents = oldLinks[i].getOverrideEvents();
                Iterator oldOverrideEventsIter = oldOverrideEvents.iterator();
                while (oldOverrideEventsIter.hasNext()) {
                    newLinks[j].addOverrideEvent((Event)oldOverrideEventsIter.next());
                }
                continue block0;
            }
        }
        newOne.setNCObjectId(taskSchedule.getNCObjectId());
        updateObject.setObject(newOne);
        return object;
    }

    @Override
    public Object createAdapter(Object object) throws ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object updateAdapter(Object object, Object objectToUpdate) throws ConverterException {
        ITaskSchedule taskSchedule = (ITaskSchedule)object;
        ScheduleAdapter adapter = (ScheduleAdapter)objectToUpdate;
        adapter.setActive(taskSchedule.isActive());
        if (taskSchedule.getOwnerStoreID() != null) {
            adapter.setOwnerStoreID(taskSchedule.getOwnerStoreID());
        }
        return adapter;
    }
}

