/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core;

import com.cognos.ems.EventManagementCategory;
import com.cognos.ems.i18n.EmsI18NCode;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.sds.core.ScheduleMender;
import com.cognos.sds.core.persist.PublishedGuidPersist;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import noticecast.datatier.scheduling.JDBCDhTaskScheduleImpl;
import noticecast.datatier.task.JDBCDhJDBCTask;
import noticecast.logictier.NCObjectType;
import noticecast.persist.IPersistManager;
import noticecast.services.RepositoryServicesImpl;

public class DatatierRecovery {
    private static DatatierRecovery m_datatier_cleaner = new DatatierRecovery();

    public static DatatierRecovery instance() {
        return m_datatier_cleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanGuid(String guid) {
        JDBCConnection connection = null;
        boolean success = true;
        try {
            connection = NCConnection.instance().getConnectionFactory().createConnection();
            connection.setAutoCommit(false);
            PublishedGuidPersist.getInstance().deleteGuid((Connection)connection, guid);
        }
        catch (Throwable e) {
            success = false;
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, e);
        }
        finally {
            this.releaseConnection(connection, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cleanTaskAndTaskSchedule(NCObjectId taskId) {
        boolean success = true;
        JDBCConnection connection = null;
        String guid = null;
        try {
            connection = NCConnection.instance().getConnectionFactory().createConnection();
            connection.setAutoCommit(false);
            NCObjectId taskScheduleId = this.findTaskSheduleId((Connection)connection, taskId);
            guid = this.cleanTask((Connection)connection, taskId);
            this.cleanTaskSchedule((Connection)connection, taskScheduleId);
        }
        catch (Throwable e) {
            success = false;
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, e);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, EmsI18NCode.SCHDR_REPAIR_CORRUPTION_ERROR, new Object[]{guid != null ? guid : "?"});
        }
        finally {
            this.releaseConnection(connection, success);
        }
        return success ? guid : null;
    }

    public void repairTaskAndTaskSchedule(NCObjectId taskId) {
        String guid = this.cleanTaskAndTaskSchedule(taskId);
        ScheduleMender.instance().mendSchedule(guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cleanTaskScheduleAndTask(NCObjectId taskScheduleId) {
        boolean success = true;
        String guid = null;
        JDBCConnection connection = null;
        try {
            connection = NCConnection.instance().getConnectionFactory().createConnection();
            connection.setAutoCommit(false);
            NCObjectId taskId = this.findTaskId((Connection)connection, taskScheduleId);
            this.cleanTaskSchedule((Connection)connection, taskScheduleId);
            guid = this.cleanTask((Connection)connection, taskId);
        }
        catch (Throwable e) {
            success = false;
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, e);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, EmsI18NCode.SCHDR_REPAIR_CORRUPTION_ERROR, new Object[]{guid != null ? guid : "?"});
        }
        finally {
            this.releaseConnection(connection, success);
        }
        return guid;
    }

    public void repairTaskScheduleAndTask(NCObjectId taskScheduleId) {
        String guid = this.cleanTaskScheduleAndTask(taskScheduleId);
        ScheduleMender.instance().mendSchedule(guid);
    }

    private NCObjectId findTaskSheduleId(Connection connection, NCObjectId taskId) throws Exception {
        NCObjectId task_sched_id = null;
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        JDBCDhJDBCTask dataHelper = (JDBCDhJDBCTask)pm.getDataHelper(NCObjectType.TASK);
        task_sched_id = dataHelper.findTaskScheduleId(connection, taskId);
        return task_sched_id;
    }

    private NCObjectId findTaskId(Connection connection, NCObjectId taskSchedId) throws Exception {
        NCObjectId task_id = null;
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        JDBCDhTaskScheduleImpl dataHelper = (JDBCDhTaskScheduleImpl)pm.getDataHelper(NCObjectType.TASK_SCHEDULE);
        task_id = dataHelper.findTaskId(connection, taskSchedId);
        return task_id;
    }

    private String cleanTask(Connection connection, NCObjectId taskId) throws Exception {
        if (taskId == null) {
            return null;
        }
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        String guid = null;
        JDBCDhJDBCTask dataHelper = (JDBCDhJDBCTask)pm.getDataHelper(NCObjectType.TASK);
        dataHelper.deleteTaskAndRecipients(connection, taskId);
        this.deleteObCatEntries(connection, pm, new NCObjectId[]{taskId});
        guid = this.deleteGuid(connection, taskId);
        return guid;
    }

    private void cleanTaskSchedule(Connection connection, NCObjectId taskSchedId) throws Exception {
        if (taskSchedId == null) {
            return;
        }
        IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
        JDBCDhTaskScheduleImpl dataHelper = (JDBCDhTaskScheduleImpl)pm.getDataHelper(NCObjectType.TASK_SCHEDULE);
        NCObjectId[] schedIds = dataHelper.deleteTaskScheduleAndSchedules(connection, taskSchedId);
        ArrayList<NCObjectId> allIds = new ArrayList<NCObjectId>(Arrays.asList(schedIds));
        allIds.add(taskSchedId);
        this.deleteObCatEntries(connection, pm, allIds.toArray(new NCObjectId[0]));
    }

    private void deleteObCatEntries(Connection con, IPersistManager pm, NCObjectId[] ids) throws Exception {
        for (int i = 0; i < ids.length; ++i) {
            pm.getObjectCatHelper().delete(con, ids[i], null);
        }
    }

    private String deleteGuid(Connection con, NCObjectId id) throws Exception {
        String guid = null;
        guid = PublishedGuidPersist.getInstance().getGuid(con, id);
        PublishedGuidPersist.getInstance().deleteGuid(con, guid);
        return guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(JDBCConnection con, boolean success) {
        try {
            if (success) {
                con.commit();
            } else {
                con.rollback();
            }
        }
        catch (SQLException ex) {
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES, (Map)ap);
        }
        finally {
            try {
                try {
                    con.setAutoCommit(true);
                }
                finally {
                    NCConnection.instance().getConnectionFactory().releaseConnection(con);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private DatatierRecovery() {
    }
}

