/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.ems.EventManagementCategory;
import com.cognos.ems.i18n.EmsI18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.sds.api.ScheduleService;

public class ScheduleMender {
    private static ScheduleMender m_instance = new ScheduleMender();

    public static ScheduleMender instance() {
        return m_instance;
    }

    public void mendSchedule(String guid) {
        JobBiBusHeaders headers = this.makeHeaders();
        Schedule schedule = null;
        if (guid != null) {
            schedule = this.getSchedule(headers, guid);
        }
        if (schedule == null) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, EmsI18NCode.SCHDR_REPAIR_CORRUPTION_ERROR, new Object[]{guid});
            return;
        }
        ScheduleService sservice = ScheduleService.getInstance();
        try {
            Schedule[] schedules = sservice.addSchedules(new Schedule[]{schedule});
            if (schedules.length == 0) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, EmsI18NCode.SCHDR_REPAIR_CORRUPTION_ERROR, new Object[]{guid});
            } else {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, EmsI18NCode.SCHDR_REPAIR_CORRUPTION, new Object[0]);
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, EmsI18NCode.SCHDR_REPAIR_CORRUPTION_ERROR, new Object[]{guid});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schedule getSchedule(JobBiBusHeaders headers, String guid) {
        ContentManagerServiceClientPort cm = null;
        Schedule schedule = null;
        try {
            cm = Client.instance().getContentManagerServiceClient(headers);
            PropEnum[] query_props = new PropEnum[]{PropEnum.defaultName, PropEnum.parent, PropEnum.version, PropEnum.parameters, PropEnum.runOptions, PropEnum.timeZoneID, PropEnum.triggerName, PropEnum.active, PropEnum.credential, PropEnum.dailyPeriod, PropEnum.endDate, PropEnum.endType, PropEnum.everyNPeriods, PropEnum.monthlyAbsoluteDay, PropEnum.monthlyRelativeDay, PropEnum.monthlyRelativeWeek, PropEnum.startDate, PropEnum.type, PropEnum.weeklyFriday, PropEnum.weeklyMonday, PropEnum.weeklySaturday, PropEnum.weeklySunday, PropEnum.weeklyThursday, PropEnum.weeklyTuesday, PropEnum.weeklyWednesday, PropEnum.yearlyAbsoluteDay, PropEnum.yearlyAbsoluteMonth, PropEnum.yearlyRelativeDay, PropEnum.yearlyRelativeMonth, PropEnum.yearlyRelativeWeek};
            QueryRequest request = new QueryRequest();
            request.setOptions(new QueryOptions());
            request.setProperties(query_props);
            request.setSearch("//schedule[@taskID='" + guid + "']");
            cm.signNextRequest("JSM");
            BaseClass base = cm.query(request);
            if (base instanceof Schedule) {
                schedule = (Schedule)base;
                TokenProp prop = new TokenProp();
                prop.setValue(guid);
                schedule.setTaskID(prop);
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, EmsI18NCode.OTH_CM_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        finally {
            if (cm != null) {
                cm.close();
            }
        }
        return schedule;
    }

    private JobBiBusHeaders makeHeaders() {
        BiBusHeader header = new BiBusHeader();
        header.setTracking(new Tracking());
        return new JobBiBusHeaders(header);
    }

    private ScheduleMender() {
    }
}

