/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.sds.core.guid;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.sds.adapter.ScheduleAdapter;
import com.cognos.sds.core.persist.PublishedGuidException;
import com.cognos.sds.core.persist.PublishedGuidPersist;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.Connection;
import java.util.Map;

public class PublishedGuidDeleteHandler
implements ProcessHandler {
    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        ScheduleAdapter adapter = context.getScheduleAdapter();
        String guid = adapter.getTaskID();
        JDBCConnection connection = context.getConnection();
        try {
            PublishedGuidPersist.getInstance().deleteGuid((Connection)connection, guid);
        }
        catch (PublishedGuidException ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Failure");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GUID_DELETE_ERROR, new Object[]{guid}, (Map)ap);
            throw new ProcessHandlerException(I18NCode.GUID_DELETE_ERROR, new Object[]{guid}, (LocalizableException)((Object)ex));
        }
    }
}

